/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.context.event;

import java.util.Map;
import java.util.SortedMap;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.spring.boot.util.DubboUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;

@Order
public class OverrideDubboConfigApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    @Override
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        Logger logger2 = LoggerFactory.getLogger(this.getClass());
        ConfigurableEnvironment environment2 = event.getEnvironment();
        boolean override = environment2.getProperty("dubbo.config.override", Boolean.TYPE, true);
        if (override) {
            SortedMap<String, Object> dubboProperties = DubboUtils.filterDubboProperties(environment2);
            ConfigUtils.getProperties().putAll((Map<?, ?>)dubboProperties);
            if (logger2.isInfoEnabled()) {
                logger2.info("Dubbo Config was overridden by externalized configuration {}", (Object)dubboProperties);
            }
        } else if (logger2.isInfoEnabled()) {
            logger2.info("Disable override Dubbo Config caused by property {} = {}", (Object)"dubbo.config.override", (Object)override);
        }
    }
}

