/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class EventDispatcher {
    private ExecutorService executor = null;
    private BlockingQueue<ServiceInfo> changedServices = new LinkedBlockingQueue<ServiceInfo>();
    private ConcurrentMap<String, List<EventListener>> observerMap = new ConcurrentHashMap<String, List<EventListener>>();

    public EventDispatcher() {
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "com.alibaba.nacos.naming.client.listener");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.executor.execute(new Notifier());
    }

    public void addListener(ServiceInfo serviceInfo, String clusters, EventListener listener) {
        LogUtils.NAMING_LOGGER.info("[LISTENER] adding " + serviceInfo.getName() + " with " + clusters + " to listener map");
        List<EventListener> observers = Collections.synchronizedList(new ArrayList());
        observers.add(listener);
        observers = this.observerMap.putIfAbsent(ServiceInfo.getKey(serviceInfo.getName(), clusters), observers);
        if (observers != null) {
            observers.add(listener);
        }
        this.serviceChanged(serviceInfo);
    }

    public void removeListener(String serviceName, String clusters, EventListener listener) {
        LogUtils.NAMING_LOGGER.info("[LISTENER] removing " + serviceName + " with " + clusters + " from listener map");
        List observers = (List)this.observerMap.get(ServiceInfo.getKey(serviceName, clusters));
        if (observers != null) {
            Iterator iter = observers.iterator();
            while (iter.hasNext()) {
                EventListener oldListener = (EventListener)iter.next();
                if (!oldListener.equals(listener)) continue;
                iter.remove();
            }
            if (observers.isEmpty()) {
                this.observerMap.remove(ServiceInfo.getKey(serviceName, clusters));
            }
        }
    }

    public List<ServiceInfo> getSubscribeServices() {
        ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>();
        for (String key : this.observerMap.keySet()) {
            serviceInfos.add(ServiceInfo.fromKey(key));
        }
        return serviceInfos;
    }

    public void serviceChanged(ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return;
        }
        this.changedServices.add(serviceInfo);
    }

    public void setExecutor(ExecutorService executor) {
        ExecutorService oldExecutor = this.executor;
        this.executor = executor;
        oldExecutor.shutdown();
    }

    private class Notifier
    implements Runnable {
        private Notifier() {
        }

        @Override
        public void run() {
            block4: while (true) {
                ServiceInfo serviceInfo = null;
                try {
                    serviceInfo = (ServiceInfo)EventDispatcher.this.changedServices.poll(5L, TimeUnit.MINUTES);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (serviceInfo == null) continue;
                try {
                    List listeners = (List)EventDispatcher.this.observerMap.get(serviceInfo.getKey());
                    if (CollectionUtils.isEmpty(listeners)) continue;
                    Iterator iterator = listeners.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block4;
                        EventListener listener = (EventListener)iterator.next();
                        List<Instance> hosts = Collections.unmodifiableList(serviceInfo.getHosts());
                        listener.onEvent(new NamingEvent(serviceInfo.getName(), serviceInfo.getGroupName(), serviceInfo.getClusters(), hosts));
                    }
                }
                catch (Exception e) {
                    LogUtils.NAMING_LOGGER.error("[NA] notify error for service: " + serviceInfo.getName() + ", clusters: " + serviceInfo.getClusters(), e);
                    continue;
                }
                break;
            }
        }
    }
}

