/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.net.baghandle;

import com.mugui.spring.base.Cache;
import com.mugui.spring.base.Filter;
import com.mugui.spring.base.Listener;
import com.mugui.spring.net.baghandle.NetBagModuleManager;
import com.mugui.spring.net.bean.Message;
import com.mugui.spring.net.bean.NetBag;
import com.mugui.spring.net.cache.CacheModel;
import com.mugui.spring.net.filter.FilterModel;
import com.mugui.spring.net.forward.ForwardNetBag;
import com.mugui.spring.net.listener.ListenerModel;
import com.mugui.spring.net.lock.NetBagHandle;
import com.mugui.spring.net.lock.SynchronizeLock;
import com.mugui.spring.net.sys.SysLogManager;
import com.mugui.spring.util.RedisAccess;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ProcessorManager {
    private HashMap<String, List<FilterModel>> filterMap = new HashMap();
    private HashMap<String, List<ListenerModel>> listenerMap = new HashMap();
    private HashMap<String, List<CacheModel>> cacheMap = new HashMap();
    @Autowired
    private SysLogManager dataManager;
    @Autowired
    private RedisAccess redisAccess;
    @Autowired
    private NetBagModuleManager manager;
    @Value(value="${spring.application.name:\u672a\u547d\u540d}")
    private String appliction_name;
    private static long time = 0L;
    static boolean listener_sys_info = false;
    static boolean listener_sys_error = false;
    private ThreadLocal<List<CacheModel>> cacheLocal = new ThreadLocal();
    @Autowired
    private NetBagHandle netBagHandle;
    @Autowired
    private SynchronizeLock synchronizeLock;
    static final String MATCH_STR = "[a-z A-Z 0-9 . _]*";
    @Autowired
    ForwardNetBag forward;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void init() {
        this.dataManager.init(null);
        if (System.currentTimeMillis() - time <= 30000L) return;
        Class<ProcessorManager> clazz = ProcessorManager.class;
        synchronized (ProcessorManager.class) {
            if (System.currentTimeMillis() - time <= 30000L) return;
            time = System.currentTimeMillis();
            listener_sys_info = "true".equals(this.redisAccess.get("listener_sys_info"));
            listener_sys_error = "true".equals(this.redisAccess.get("listener_sys_error"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAddListener(NetBag bag, Message data) {
        List<ListenerModel> listenerModels = null;
        listenerModels = this.listenerMap.get(bag.getFunc());
        if (listenerModels == null) {
            HashMap<String, List<ListenerModel>> hashMap = this.listenerMap;
            synchronized (hashMap) {
                listenerModels = this.listenerMap.get(bag.getFunc());
                if (listenerModels == null) {
                    listenerModels = new LinkedList<ListenerModel>();
                    this.listenerMap.put(bag.getFunc(), listenerModels);
                    if (this.manager.getListenerMessage() != null) {
                        for (Map.Entry<String, ListenerModel> entry : this.manager.getListenerMessage().entrySet()) {
                            String string = bag.getFunc();
                            boolean bool = this.handleListenerModel(string, entry.getValue());
                            if (!bool) continue;
                            listenerModels.add(entry.getValue());
                        }
                        listenerModels.sort(new Comparator<ListenerModel>(){

                            @Override
                            public int compare(ListenerModel o1, ListenerModel o2) {
                                Listener filter1 = o1.getClass().getAnnotation(Listener.class);
                                Listener filter2 = o2.getClass().getAnnotation(Listener.class);
                                return filter1.weight() - filter2.weight();
                            }
                        });
                    }
                }
            }
        }
        for (ListenerModel model : listenerModels) {
            try {
                if (listener_sys_info) {
                    this.dataManager.ListenerLog().info(this.appliction_name, bag, (Object)data);
                }
                model.listener(data, bag);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!listener_sys_error) continue;
                this.dataManager.ListenerLog().error(this.appliction_name, bag, (Object)data, e);
            }
        }
    }

    void saveCache(Message data, NetBag bag) {
        List<CacheModel> cacheModels = this.cacheLocal.get();
        for (CacheModel model : cacheModels) {
            try {
                if (listener_sys_info) {
                    this.dataManager.CacheLog().info(this.appliction_name, bag, (Object)data);
                }
                model.save(data, bag);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!listener_sys_error) continue;
                this.dataManager.CacheLog().error(this.appliction_name, bag, (Object)data, e);
            }
        }
        this.cacheLocal.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NetBag handleAddCache(NetBag bag) {
        List<CacheModel> cacheModels = null;
        cacheModels = this.cacheMap.get(bag.getFunc());
        if (cacheModels == null) {
            HashMap<String, List<CacheModel>> hashMap = this.cacheMap;
            synchronized (hashMap) {
                cacheModels = this.cacheMap.get(bag.getFunc());
                if (cacheModels == null) {
                    cacheModels = new LinkedList<CacheModel>();
                    this.cacheMap.put(bag.getFunc(), cacheModels);
                    if (this.manager.getCacheMessage() != null) {
                        for (Map.Entry<String, CacheModel> entry : this.manager.getCacheMessage().entrySet()) {
                            String string = bag.getFunc();
                            boolean bool = this.handleCacheModel(string, entry.getValue());
                            if (!bool) continue;
                            cacheModels.add(entry.getValue());
                        }
                    }
                }
            }
        }
        this.cacheLocal.set(cacheModels);
        for (CacheModel model : cacheModels) {
            try {
                if (listener_sys_info) {
                    this.dataManager.CacheLog().info(this.appliction_name, bag);
                }
                if (model.load(bag) != null) continue;
                if (listener_sys_info) {
                    this.dataManager.CacheLog().info(this.appliction_name, bag);
                }
                return bag;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!listener_sys_error) continue;
                this.dataManager.CacheLog().error(this.appliction_name, bag, e);
            }
        }
        if (listener_sys_info) {
            this.dataManager.CacheLog().info(this.appliction_name, bag, "");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NetBag handleAddFilter(NetBag bag) {
        List<FilterModel> filterModels = null;
        filterModels = this.filterMap.get(bag.getFunc());
        if (filterModels == null) {
            HashMap<String, List<FilterModel>> hashMap = this.filterMap;
            synchronized (hashMap) {
                filterModels = this.filterMap.get(bag.getFunc());
                if (filterModels == null) {
                    filterModels = new LinkedList<FilterModel>();
                    this.filterMap.put(bag.getFunc(), filterModels);
                    if (this.manager.getFilterMessage() != null) {
                        for (Map.Entry<String, FilterModel> entry : this.manager.getFilterMessage().entrySet()) {
                            String string = bag.getFunc();
                            boolean bool = this.handleFilterModel(string, entry.getValue());
                            if (!bool) continue;
                            filterModels.add(entry.getValue());
                        }
                        filterModels.sort(new Comparator<FilterModel>(){

                            @Override
                            public int compare(FilterModel o1, FilterModel o2) {
                                Filter filter1 = o1.getClass().getAnnotation(Filter.class);
                                Filter filter2 = o2.getClass().getAnnotation(Filter.class);
                                return filter2.weight() - filter1.weight();
                            }
                        });
                    }
                }
            }
        }
        for (FilterModel model : filterModels) {
            try {
                if (listener_sys_info) {
                    this.dataManager.FilterLog().info(this.appliction_name, bag);
                }
                if (model.filter(bag) != null) continue;
                this.netBagHandle.listener(null, bag);
                this.synchronizeLock.listener(null, bag);
                return bag;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!listener_sys_error) continue;
                this.dataManager.FilterLog().error(this.appliction_name, bag, e);
            }
        }
        return null;
    }

    boolean handleFilterModel(String string, FilterModel filterModel) {
        Filter filter2 = filterModel.getClass().getAnnotation(Filter.class);
        String[] values = filter2.value();
        boolean b = filter2.type() != 0;
        block4: for (String value : values) {
            boolean bool = string.matches(value.replaceAll("[*]", MATCH_STR));
            switch (filter2.type()) {
                case 0: {
                    if (!bool) continue block4;
                    return true;
                }
                case 1: {
                    if (!bool) continue block4;
                    return false;
                }
            }
        }
        return b;
    }

    boolean handleListenerModel(String string, ListenerModel listenerModel) {
        Listener listener = listenerModel.getClass().getAnnotation(Listener.class);
        String[] values = listener.value();
        boolean b = listener.type() != 0;
        block4: for (String value : values) {
            boolean bool = string.matches(value.replaceAll("[*]", MATCH_STR));
            switch (listener.type()) {
                case 0: {
                    if (!bool) continue block4;
                    return true;
                }
                case 1: {
                    if (!bool) continue block4;
                    return false;
                }
            }
        }
        return b;
    }

    boolean handleCacheModel(String string, CacheModel cacheModel) {
        Cache listener = cacheModel.getClass().getAnnotation(Cache.class);
        String[] values = listener.value();
        boolean b = listener.type() != 0;
        block4: for (String value : values) {
            boolean bool = string.matches(value.replaceAll("[*]", MATCH_STR));
            switch (listener.type()) {
                case 0: {
                    if (!bool) continue block4;
                    return true;
                }
                case 1: {
                    if (!bool) continue block4;
                    return false;
                }
            }
        }
        return b;
    }

    NetBag handleAddForward(NetBag bag) {
        String[] func = bag.getFunc().split("[.]");
        if (bag.getFunc().startsWith("&forward.insert.")) {
            Message message;
            block7: {
                message = null;
                try {
                    if (listener_sys_info) {
                        this.dataManager.ForwardLog().info(this.appliction_name, bag);
                    }
                    message = (Message)((Object)this.forward.invokeFunction(func[func.length - 1], new Object[]{bag}));
                    if (listener_sys_info) {
                        this.dataManager.ForwardLog().info(this.appliction_name, bag, (Object)message);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (message != null) {
                        message.setDate(e.getMessage());
                    } else {
                        message = Message.error("\u9519\u8bef");
                    }
                    if (!listener_sys_error) break block7;
                    this.dataManager.ForwardLog().error(this.appliction_name, bag, (Object)message, e);
                }
            }
            bag.setCode(200);
            bag.setData((Object)message);
            return bag;
        }
        return null;
    }
}

