/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.net.forward;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.XmlUtil;
import com.alibaba.fastjson.JSONArray;
import com.mugui.Mugui;
import com.mugui.bean.JsonBean;
import com.mugui.spring.base.ManagerInterface;
import com.mugui.spring.base.Module;
import com.mugui.spring.net.auto.AutoManager;
import com.mugui.spring.net.classutil.DataSave;
import com.mugui.spring.net.forward.Forward;
import com.mugui.spring.net.forward.ForwardBean;
import com.mugui.spring.net.forward.ForwardTask;
import com.mugui.spring.net.websocket.WebSocket;
import com.mugui.spring.net.websocket.WebSocketBean;
import com.mugui.spring.net.websocket.WebSocketMethodConf;
import com.mugui.spring.net.websocket.WebSocketMethodConfBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@AutoManager
@Component
public class ForwardManager
implements ManagerInterface<String, Object> {
    private static HashMap<String, Object> map = null;
    private ApplicationContext applicationContext = null;
    private String url = null;
    private String value = null;
    private String inject = null;
    private String classes = null;
    @Autowired
    private ForwardTask forwardTask;

    public void init() {
        this.clear();
        map = new HashMap();
        this.applicationContext = (ApplicationContext)System.getProperties().get("Application");
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return map.entrySet();
    }

    @Override
    public boolean init(Object name) {
        this.init();
        this.loadByDefaultConfigXml();
        this.loadByClass((Class)name);
        return true;
    }

    private void loadByDefaultConfigXml() {
        ClassPathResource resource = new ClassPathResource("ForwardConfig.xml");
        try {
            Document document = null;
            try {
                document = XmlUtil.readXML(resource.getInputStream());
            }
            catch (Exception e) {
                return;
            }
            NodeList list = document.getChildNodes().item(0).getChildNodes();
            for (int i2 = 0; i2 < list.getLength(); ++i2) {
                Node item = list.item(i2);
                if (!item.getNodeName().equals("server-node")) continue;
                NodeList childNodes = item.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    if (childNodes.item(j).getNodeName().equals("url")) {
                        this.url = childNodes.item(j).getChildNodes().item(0).getNodeValue();
                        continue;
                    }
                    if (childNodes.item(j).getNodeName().equals("value")) {
                        this.value = childNodes.item(j).getChildNodes().item(0).getNodeValue();
                        continue;
                    }
                    if (childNodes.item(j).getNodeName().equals("inject")) {
                        this.inject = childNodes.item(j).getChildNodes().item(0).getNodeValue();
                        continue;
                    }
                    if (!childNodes.item(j).getNodeName().equals("classes")) continue;
                    this.classes = childNodes.item(j).getChildNodes().item(0).getNodeValue();
                }
                System.out.println(this.url + " " + this.value + " " + this.inject + " " + this.classes);
                Forward forward = new Forward(){
                    String u;
                    String v;
                    String i;
                    String c;
                    {
                        this.u = ForwardManager.this.url;
                        this.v = ForwardManager.this.value;
                        this.i = ForwardManager.this.inject;
                        this.c = ForwardManager.this.classes;
                    }

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return null;
                    }

                    @Override
                    public String[] value() {
                        return this.v.split(",");
                    }

                    @Override
                    public String url() {
                        return this.u;
                    }

                    @Override
                    public String[] inject() {
                        return this.i.split(",");
                    }

                    @Override
                    public Class<Mugui>[] classes() {
                        if (StringUtils.isBlank(this.c)) {
                            return null;
                        }
                        String[] split2 = this.c.split(",");
                        Class[] classes = new Class[split2.length];
                        try {
                            for (int i2 = 0; i2 < split2.length; ++i2) {
                                Class<?> forName = Class.forName(split2[i2]);
                                Object bean2 = ForwardManager.this.applicationContext.getBean(forName);
                                if (!forName.isAnnotationPresent(Module.class) || !(bean2 instanceof Mugui)) {
                                    throw new RuntimeException("\u7c7b\u5c5e\u6027\u9519\u8bef\uff0c\u5173\u4e8e class:" + forName.getName());
                                }
                                classes[i2] = forName;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException("\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", e);
                        }
                        return classes;
                    }
                };
                if (StringUtils.isNotBlank(forward.url())) {
                    for (String key : forward.value()) {
                        this.handleKey(key, forward);
                    }
                }
                if (this.inject == null) continue;
                this.injectOtherServer(forward);
            }
        }
        catch (UtilException e) {
            e.printStackTrace();
        }
    }

    private void injectOtherServer(Forward forward) {
        for (String str : forward.inject()) {
            Class<Mugui>[] classes2;
            if (StringUtils.isBlank(str)) continue;
            ForwardBean forwardBean = new ForwardBean();
            forwardBean.setUrl(forward.url());
            String value = null;
            if (forward.value() != null && forward.value().length > 0) {
                value = ArrayUtil.join(forward.value(), (CharSequence)",");
            }
            if ((classes2 = forward.classes()) != null && classes2.length > 0) {
                JSONArray object = new JSONArray();
                for (Class<Mugui> class1 : classes2) {
                    Module annotation = class1.getAnnotation(Module.class);
                    String module = annotation.name() + "." + annotation.type() + ".*";
                    value = value == null ? module : value + "," + module;
                    if (!class1.isAnnotationPresent(WebSocket.class)) continue;
                    WebSocket annotation2 = class1.getAnnotation(WebSocket.class);
                    WebSocketBean webSocketBean = new WebSocketBean();
                    webSocketBean.setBlank(annotation2.blank());
                    webSocketBean.setClass_name(class1.getName());
                    webSocketBean.setType(annotation2.type());
                    webSocketBean.setValue(module);
                    this.handleWebSocketMethod(webSocketBean, class1, object);
                }
                if (!object.isEmpty()) {
                    forwardBean.setWs(object.toJSONString());
                }
            }
            forwardBean.setValue(value);
            forwardBean.setMd5(Base64.encode(forwardBean.toString().getBytes(Charset.forName("UTF-8"))));
            forwardBean.get().put("server_url", (Object)str);
            this.forwardTask.insert(forwardBean);
        }
    }

    private void handleWebSocketMethod(WebSocketBean webSocket, Class<?> class_name, JSONArray object) {
        Method[] methods2;
        for (Method method : methods2 = class_name.getDeclaredMethods()) {
            System.out.println("handleWebSocketMethod\u521d\u59cb\u5316->" + class_name.getName() + "." + method.getName());
            WebSocketBean webSocketBean = (WebSocketBean)WebSocketBean.newBean((JsonBean)webSocket);
            if (method.isAnnotationPresent(WebSocketMethodConf.class)) {
                WebSocketMethodConf annotation = method.getAnnotation(WebSocketMethodConf.class);
                WebSocketMethodConfBean webSocketMethodConfBean = new WebSocketMethodConfBean(annotation);
                webSocketBean.setConf(webSocketMethodConfBean);
            }
            webSocketBean.setValue(webSocket.getValue().replace(".*", "." + method.getName()));
            object.add((Object)webSocketBean.toJson());
        }
    }

    private void loadByClass(Class<?> name) {
        for (Class<?> class_name : DataSave.initClassList(name)) {
            if (!class_name.isAnnotationPresent(Forward.class)) continue;
            Forward filter2 = class_name.getAnnotation(Forward.class);
            if (StringUtils.isNotBlank(filter2.url())) {
                for (String key : filter2.value()) {
                    this.handleKey(key, filter2);
                }
            }
            this.injectOtherServer(filter2);
        }
    }

    private void handleKey(String key, Forward filter2) {
        String[] keys = key.split("[.]");
        HashMap<String, Object> tempmap = map;
        for (String temp : keys) {
            temp = temp.trim();
            HashMap<String, Object> t = null;
            t = (HashMap<String, Object>)tempmap.get(temp);
            if (t == null) {
                t = new HashMap<String, Object>();
                tempmap.put(temp, t);
            }
            tempmap = t;
        }
        tempmap.put("&&", filter2);
    }

    @Override
    public boolean clear() {
        if (map != null) {
            map.clear();
        }
        return true;
    }

    @Override
    public boolean is(String name) {
        if (map == null) {
            throw new NullPointerException("please run init");
        }
        return !map.isEmpty() && map.get(name) != null;
    }

    @Override
    public Object del(String name) {
        if (map == null) {
            throw new NullPointerException("please run init");
        }
        return map.remove(name);
    }

    @Override
    public Object get(String name) {
        if (map == null) {
            throw new NullPointerException("please run init");
        }
        HashMap tempmap = map;
        for (String key : name.split("[.]")) {
            HashMap temp = (HashMap)tempmap.get(key);
            if (temp == null) {
                temp = (HashMap)tempmap.get("*");
            }
            if (temp == null) {
                return null;
            }
            tempmap = temp;
            if (tempmap.size() == 1 && temp.containsKey("&&")) break;
        }
        return tempmap.get("&&");
    }

    @Override
    public boolean add(String name, Object object) {
        if (map == null) {
            throw new NullPointerException("please run init");
        }
        final ForwardBean forwardBean = (ForwardBean)((Object)ForwardBean.newBean(ForwardBean.class, (Object)object));
        Forward forward = new Forward(){
            String u;
            String v;
            {
                this.u = forwardBean.getUrl();
                this.v = forwardBean.getValue();
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return null;
            }

            @Override
            public String[] value() {
                return this.v.split(",");
            }

            @Override
            public String url() {
                return this.u;
            }

            @Override
            public String[] inject() {
                return null;
            }

            @Override
            public Class<Mugui>[] classes() {
                return null;
            }
        };
        for (String key : forward.value()) {
            this.handleKey(key, forward);
        }
        return true;
    }

    @Override
    public boolean isInit() {
        return false;
    }
}

