/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.net.websocket;

import com.mugui.spring.base.ManagerInterface;
import com.mugui.spring.net.auto.AutoManager;
import com.mugui.spring.net.bean.NetBag;
import com.mugui.spring.net.task.TaskManager;
import com.mugui.spring.net.websocket.WebSocketManager;
import com.mugui.spring.net.websocket.WebSocketPingTask;
import com.mugui.spring.net.websocket.WebSocketTask;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AutoManager
public class WebSocketSessionManager
implements ManagerInterface<String, Session> {
    private static Map<String, Session> map = null;
    @Autowired
    private WebSocketManager webSocketManager;
    @Autowired
    private WebSocketPingTask webSocketPingTask;
    @Autowired
    private WebSocketTask webSocketTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        if (map != null) return;
        Class<WebSocketSessionManager> clazz = WebSocketSessionManager.class;
        synchronized (WebSocketSessionManager.class) {
            if (map != null) return;
            map = new ConcurrentHashMap<String, Session>();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean init(Object name) {
        System.out.println(WebSocketSessionManager.class.getName() + "\u521d\u59cb\u5316");
        this.init();
        this.clear();
        if (!this.webSocketManager.isOpenWebSocket()) {
            return true;
        }
        this.webSocketPingTask.init();
        TaskManager.getTaskManager().add(this.webSocketPingTask);
        this.webSocketTask.init();
        TaskManager.getTaskManager().add(this.webSocketTask);
        return true;
    }

    @Override
    public Session get(String name) {
        this.init();
        return map.get(name);
    }

    @Override
    public Session del(String name) {
        this.init();
        Session remove = map.remove(name);
        if (remove != null) {
            Collection values = this.webSocketTask.values();
            for (ConcurrentHashMap concurrentHashMap : values) {
                for (ConcurrentHashMap concurrentHashMap2 : concurrentHashMap.values()) {
                    concurrentHashMap2.remove(remove);
                }
            }
        }
        return remove;
    }

    public void sub(Session session, NetBag bag) {
        this.webSocketTask.sub(session, bag);
    }

    public void unsub(Session session, NetBag bag) {
        this.webSocketTask.unsub(session, bag);
    }

    @Override
    public boolean add(String name, Session object) {
        this.init();
        map.put(name, object);
        return true;
    }

    @Override
    public boolean clear() {
        this.init();
        this.webSocketTask.clear();
        map.clear();
        return true;
    }

    @Override
    public boolean is(String name) {
        return map.containsKey(name);
    }

    public Collection<Session> values() {
        return map.values();
    }

    @Override
    public boolean isInit() {
        return false;
    }
}

