/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import java.beans.PropertyEditorSupport;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.annotation.Method;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.AnnotatedInterfaceConfigBeanBuilder;
import org.apache.dubbo.config.spring.beans.factory.annotation.AnnotationPropertyValuesAdapter;
import org.apache.dubbo.config.spring.util.AnnotationUtils;
import org.apache.dubbo.config.spring.util.BeanFactoryUtils;
import org.apache.dubbo.config.spring.util.ObjectUtils;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

class ReferenceBeanBuilder
extends AnnotatedInterfaceConfigBeanBuilder<ReferenceBean> {
    static final String[] IGNORE_FIELD_NAMES = ObjectUtils.of("application", "module", "consumer", "monitor", "registry");

    private ReferenceBeanBuilder(AnnotationAttributes attributes, ApplicationContext applicationContext) {
        super(attributes, applicationContext);
    }

    private void configureInterface(AnnotationAttributes attributes, ReferenceBean referenceBean) {
        Class<?> serviceInterfaceClass = AnnotationUtils.resolveServiceInterfaceClass(attributes, this.interfaceClass);
        Assert.isTrue(serviceInterfaceClass.isInterface(), "The class of field or method that was annotated @Reference is not an interface!");
        referenceBean.setInterface(serviceInterfaceClass);
    }

    private void configureConsumerConfig(AnnotationAttributes attributes, ReferenceBean<?> referenceBean) {
        String consumerBeanName = (String)AnnotationUtils.getAttribute(attributes, "consumer");
        ConsumerConfig consumerConfig = BeanFactoryUtils.getOptionalBean(this.applicationContext, consumerBeanName, ConsumerConfig.class);
        referenceBean.setConsumer(consumerConfig);
    }

    void configureMethodConfig(AnnotationAttributes attributes, ReferenceBean<?> referenceBean) {
        Method[] methods = (Method[])attributes.get("methods");
        List<MethodConfig> methodConfigs = MethodConfig.constructMethodConfig(methods);
        if (!methodConfigs.isEmpty()) {
            referenceBean.setMethods(methodConfigs);
        }
    }

    @Override
    protected ReferenceBean doBuild() {
        return new ReferenceBean();
    }

    @Override
    protected void preConfigureBean(AnnotationAttributes attributes, ReferenceBean referenceBean) {
        Assert.notNull((Object)this.interfaceClass, "The interface class must set first!");
        DataBinder dataBinder = new DataBinder(referenceBean);
        dataBinder.registerCustomEditor(String.class, "filter", new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(String.class, "listener", new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(Map.class, "parameters", new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) throws IllegalArgumentException {
                String content = StringUtils.trimAllWhitespace(text);
                if (!StringUtils.hasText(content)) {
                    return;
                }
                content = StringUtils.replace(content, "=", ",");
                content = StringUtils.replace(content, ":", ",");
                Map<String, String> parameters = CollectionUtils.toStringMap(StringUtils.commaDelimitedListToStringArray(content));
                this.setValue(parameters);
            }
        });
        dataBinder.bind(new AnnotationPropertyValuesAdapter(attributes, (PropertyResolver)this.applicationContext.getEnvironment(), IGNORE_FIELD_NAMES));
    }

    @Override
    protected String resolveModuleConfigBeanName(AnnotationAttributes attributes) {
        return (String)AnnotationUtils.getAttribute(attributes, "module");
    }

    @Override
    protected String resolveApplicationConfigBeanName(AnnotationAttributes attributes) {
        return (String)AnnotationUtils.getAttribute(attributes, "application");
    }

    @Override
    protected String[] resolveRegistryConfigBeanNames(AnnotationAttributes attributes) {
        return (String[])AnnotationUtils.getAttribute(attributes, "registry");
    }

    @Override
    protected String resolveMonitorConfigBeanName(AnnotationAttributes attributes) {
        return (String)AnnotationUtils.getAttribute(attributes, "monitor");
    }

    @Override
    protected void postConfigureBean(AnnotationAttributes attributes, ReferenceBean bean2) throws Exception {
        bean2.setApplicationContext(this.applicationContext);
        this.configureInterface(attributes, bean2);
        this.configureConsumerConfig(attributes, bean2);
        this.configureMethodConfig(attributes, bean2);
        bean2.afterPropertiesSet();
    }

    @Deprecated
    public static ReferenceBeanBuilder create(Reference reference, ClassLoader classLoader, ApplicationContext applicationContext) {
        return ReferenceBeanBuilder.create(AnnotationAttributes.fromMap(AnnotationUtils.getAttributes((Annotation)reference, applicationContext.getEnvironment(), true, new String[0])), applicationContext);
    }

    public static ReferenceBeanBuilder create(AnnotationAttributes attributes, ApplicationContext applicationContext) {
        return new ReferenceBeanBuilder(attributes, applicationContext);
    }
}

