/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.sync.RedisServerCommands;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisClusterServerCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceServerCommands;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class LettuceClusterServerCommands
extends LettuceServerCommands
implements RedisClusterServerCommands {
    private final LettuceClusterConnection connection;

    LettuceClusterServerCommands(LettuceClusterConnection connection) {
        super(connection);
        this.connection = connection;
    }

    @Override
    public void bgReWriteAof(RedisClusterNode node) {
        this.executeCommandOnSingleNode(RedisServerCommands::bgrewriteaof, node);
    }

    @Override
    public void bgSave(RedisClusterNode node) {
        this.executeCommandOnSingleNode(RedisServerCommands::bgsave, node);
    }

    @Override
    public Long lastSave(RedisClusterNode node) {
        return (Long)this.executeCommandOnSingleNode(client -> client.lastsave().getTime(), node).getValue();
    }

    @Override
    public void save(RedisClusterNode node) {
        this.executeCommandOnSingleNode(RedisServerCommands::save, node);
    }

    @Override
    public Long dbSize() {
        List dbSizes = this.executeCommandOnAllNodes(RedisServerCommands::dbsize).resultsAsList();
        if (CollectionUtils.isEmpty(dbSizes)) {
            return 0L;
        }
        Long size = 0L;
        for (Long value : dbSizes) {
            size = size + value;
        }
        return size;
    }

    @Override
    public Long dbSize(RedisClusterNode node) {
        return (Long)this.executeCommandOnSingleNode(RedisServerCommands::dbsize, node).getValue();
    }

    @Override
    public void flushDb() {
        this.executeCommandOnAllNodes(RedisServerCommands::flushdb);
    }

    @Override
    public void flushDb(RedisClusterNode node) {
        this.executeCommandOnSingleNode(RedisServerCommands::flushdb, node);
    }

    @Override
    public void flushAll() {
        this.executeCommandOnAllNodes(RedisServerCommands::flushall);
    }

    @Override
    public void flushAll(RedisClusterNode node) {
        this.executeCommandOnSingleNode(RedisServerCommands::flushall, node);
    }

    @Override
    public Properties info(RedisClusterNode node) {
        return LettuceConverters.toProperties((String)this.executeCommandOnSingleNode(RedisServerCommands::info, node).getValue());
    }

    @Override
    public Properties info() {
        Properties infos = new Properties();
        List nodeResults = this.executeCommandOnAllNodes(client -> LettuceConverters.toProperties(client.info())).getResults();
        for (ClusterCommandExecutor.NodeResult nodePorperties : nodeResults) {
            for (Map.Entry<Object, Object> entry : ((Properties)nodePorperties.getValue()).entrySet()) {
                infos.put(nodePorperties.getNode().asString() + "." + entry.getKey(), entry.getValue());
            }
        }
        return infos;
    }

    @Override
    public Properties info(String section) {
        Assert.hasText(section, "Section must not be null or empty!");
        Properties infos = new Properties();
        List nodeResults = this.executeCommandOnAllNodes(client -> LettuceConverters.toProperties(client.info(section))).getResults();
        for (ClusterCommandExecutor.NodeResult nodePorperties : nodeResults) {
            for (Map.Entry<Object, Object> entry : ((Properties)nodePorperties.getValue()).entrySet()) {
                infos.put(nodePorperties.getNode().asString() + "." + entry.getKey(), entry.getValue());
            }
        }
        return infos;
    }

    @Override
    public Properties info(RedisClusterNode node, String section) {
        Assert.hasText(section, "Section must not be null or empty!");
        return LettuceConverters.toProperties((String)this.executeCommandOnSingleNode(client -> client.info(section), node).getValue());
    }

    @Override
    public void shutdown(RedisClusterNode node) {
        this.executeCommandOnSingleNode(client -> {
            client.shutdown(true);
            return null;
        }, node);
    }

    @Override
    public Properties getConfig(String pattern) {
        Assert.hasText(pattern, "Pattern must not be null or empty!");
        List mapResult = this.executeCommandOnAllNodes(client -> client.configGet(pattern)).getResults();
        Properties properties = new Properties();
        for (ClusterCommandExecutor.NodeResult entry : mapResult) {
            String prefix = entry.getNode().asString();
            ((Map)entry.getValue()).forEach((key, value) -> properties.setProperty(prefix + "." + key, (String)value));
        }
        return properties;
    }

    @Override
    public Properties getConfig(RedisClusterNode node, String pattern) {
        Assert.hasText(pattern, "Pattern must not be null or empty!");
        return (Properties)this.executeCommandOnSingleNode(client -> Converters.toProperties(client.configGet(pattern)), node).getValue();
    }

    @Override
    public void setConfig(String param, String value) {
        Assert.hasText(param, "Parameter must not be null or empty!");
        Assert.hasText(value, "Value must not be null or empty!");
        this.executeCommandOnAllNodes(client -> client.configSet(param, value));
    }

    @Override
    public void setConfig(RedisClusterNode node, String param, String value) {
        Assert.hasText(param, "Parameter must not be null or empty!");
        Assert.hasText(value, "Value must not be null or empty!");
        this.executeCommandOnSingleNode(client -> client.configSet(param, value), node);
    }

    @Override
    public void resetConfigStats() {
        this.executeCommandOnAllNodes(RedisServerCommands::configResetstat);
    }

    @Override
    public void resetConfigStats(RedisClusterNode node) {
        this.executeCommandOnSingleNode(RedisServerCommands::configResetstat, node);
    }

    @Override
    public Long time() {
        return LettuceClusterServerCommands.convertListOfStringToTime((List)this.connection.getClusterCommandExecutor().executeCommandOnArbitraryNode(RedisServerCommands::time).getValue());
    }

    @Override
    public Long time(RedisClusterNode node) {
        return LettuceClusterServerCommands.convertListOfStringToTime((List)this.executeCommandOnSingleNode(RedisServerCommands::time, node).getValue());
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        List map = this.executeCommandOnAllNodes(RedisServerCommands::clientList).resultsAsList();
        ArrayList<RedisClientInfo> result = new ArrayList<RedisClientInfo>();
        for (String infos : map) {
            result.addAll(LettuceConverters.toListOfRedisClientInformation(infos));
        }
        return result;
    }

    @Override
    public List<RedisClientInfo> getClientList(RedisClusterNode node) {
        return LettuceConverters.toListOfRedisClientInformation((String)this.executeCommandOnSingleNode(RedisServerCommands::clientList, node).getValue());
    }

    @Override
    public void slaveOf(String host, int port) {
        throw new InvalidDataAccessApiUsageException("SlaveOf is not supported in cluster environment. Please use CLUSTER REPLICATE.");
    }

    @Override
    public void slaveOfNoOne() {
        throw new InvalidDataAccessApiUsageException("SlaveOf is not supported in cluster environment. Please use CLUSTER REPLICATE.");
    }

    private <T> ClusterCommandExecutor.NodeResult<T> executeCommandOnSingleNode(LettuceClusterConnection.LettuceClusterCommandCallback<T> command, RedisClusterNode node) {
        return this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(command, node);
    }

    private <T> ClusterCommandExecutor.MultiNodeResult<T> executeCommandOnAllNodes(LettuceClusterConnection.LettuceClusterCommandCallback<T> cmd) {
        return this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(cmd);
    }

    private static Long convertListOfStringToTime(List<byte[]> serverTimeInformation) {
        Assert.notEmpty(serverTimeInformation, "Received invalid result from server. Expected 2 items in collection.");
        Assert.isTrue(serverTimeInformation.size() == 2, "Received invalid number of arguments from redis server. Expected 2 received " + serverTimeInformation.size());
        return Converters.toTimeMillis(LettuceConverters.toString(serverTimeInformation.get(0)), LettuceConverters.toString(serverTimeInformation.get(1)));
    }
}

