/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Lazy<T>
implements Supplier<T> {
    private static final Lazy<?> EMPTY = new Lazy<Object>(() -> null, null, true);
    private final Supplier<? extends T> supplier;
    @Nullable
    private T value = null;
    private boolean resolved = false;

    public static <T> Lazy<T> of(Supplier<? extends T> supplier) {
        return new Lazy<T>(supplier);
    }

    public static <T> Lazy<T> of(T value) {
        Assert.notNull(value, "Value must not be null!");
        return new Lazy<Object>(() -> value);
    }

    public static <T> Lazy<T> empty() {
        return EMPTY;
    }

    @Override
    public T get() {
        T value = this.getNullable();
        if (value == null) {
            throw new IllegalStateException("Expected lazy evaluation to yield a non-null value but got null!");
        }
        return value;
    }

    public Optional<T> getOptional() {
        return Optional.ofNullable(this.getNullable());
    }

    public Lazy<T> or(Supplier<? extends T> supplier) {
        Assert.notNull(supplier, "Supplier must not be null!");
        return Lazy.of(() -> this.orElseGet(supplier));
    }

    public Lazy<T> or(T value) {
        Assert.notNull(value, "Value must not be null!");
        return Lazy.of(() -> this.orElse(value));
    }

    @Nullable
    public T orElse(@Nullable T value) {
        T nullable = this.getNullable();
        return nullable == null ? value : nullable;
    }

    @Nullable
    private T orElseGet(Supplier<? extends T> supplier) {
        Assert.notNull(supplier, "Default value supplier must not be null!");
        T value = this.getNullable();
        return value == null ? supplier.get() : value;
    }

    public <S> Lazy<S> map(Function<? super T, ? extends S> function) {
        Assert.notNull(function, "Function must not be null!");
        return Lazy.of(() -> function.apply((T)this.get()));
    }

    public <S> Lazy<S> flatMap(Function<? super T, Lazy<? extends S>> function) {
        Assert.notNull(function, "Function must not be null!");
        return Lazy.of(() -> ((Lazy)function.apply((T)this.get())).get());
    }

    @Nullable
    public T getNullable() {
        T value = this.value;
        if (this.resolved) {
            return value;
        }
        this.value = value = this.supplier.get();
        this.resolved = true;
        return value;
    }

    @Generated
    public Lazy(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    @Generated
    private Lazy(Supplier<? extends T> supplier, @Nullable T value, boolean resolved) {
        this.supplier = supplier;
        this.value = value;
        this.resolved = resolved;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Lazy)) {
            return false;
        }
        Lazy other = (Lazy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<T> this$supplier = this.supplier;
        Supplier<? extends T> other$supplier = other.supplier;
        if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
            return false;
        }
        T this$value = this.value;
        T other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.resolved == other.resolved;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Lazy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<T> $supplier = this.supplier;
        result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
        T $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.resolved ? 79 : 97);
        return result;
    }
}

