/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ParallelFlux;
import reactor.util.annotation.Nullable;

final class ParallelReduceSeed<T, R>
extends ParallelFlux<R>
implements Scannable,
Fuseable {
    final ParallelFlux<? extends T> source;
    final Supplier<R> initialSupplier;
    final BiFunction<R, ? super T, R> reducer;

    ParallelReduceSeed(ParallelFlux<? extends T> source, Supplier<R> initialSupplier, BiFunction<R, ? super T, R> reducer) {
        this.source = source;
        this.initialSupplier = initialSupplier;
        this.reducer = reducer;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        return null;
    }

    @Override
    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void subscribe(CoreSubscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        CoreSubscriber[] parents = new CoreSubscriber[n];
        for (int i2 = 0; i2 < n; ++i2) {
            R initialValue;
            try {
                initialValue = Objects.requireNonNull(this.initialSupplier.get(), "The initialSupplier returned a null value");
            }
            catch (Throwable ex) {
                this.reportError(subscribers, Operators.onOperatorError(ex, subscribers[i2].currentContext()));
                return;
            }
            parents[i2] = new ParallelReduceSeedSubscriber<T, R>(subscribers[i2], initialValue, this.reducer);
        }
        this.source.subscribe(parents);
    }

    void reportError(Subscriber<?>[] subscribers, Throwable ex) {
        for (Subscriber<?> s : subscribers) {
            Operators.error(s, ex);
        }
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelReduceSeedSubscriber<T, R>
    extends Operators.MonoSubscriber<T, R> {
        final BiFunction<R, ? super T, R> reducer;
        R accumulator;
        Subscription s;
        boolean done;

        ParallelReduceSeedSubscriber(CoreSubscriber<? super R> subscriber, R initialValue, BiFunction<R, ? super T, R> reducer) {
            super(subscriber);
            this.accumulator = initialValue;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            R v;
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            try {
                v = Objects.requireNonNull(this.reducer.apply(this.accumulator, t), "The reducer returned a null value");
            }
            catch (Throwable ex) {
                this.onError(Operators.onOperatorError(this, ex, t, this.actual.currentContext()));
                return;
            }
            this.accumulator = v;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.accumulator = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            R a = this.accumulator;
            this.accumulator = null;
            this.complete(a);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

