/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.nosql.redis;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.setting.Setting;
import java.io.Closeable;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisDS
implements Closeable {
    public static final String REDIS_CONFIG_PATH = "config/redis.setting";
    private Setting setting;
    private JedisPool pool;

    public static RedisDS create() {
        return new RedisDS();
    }

    public static RedisDS create(String group) {
        return new RedisDS(group);
    }

    public static RedisDS create(Setting setting, String group) {
        return new RedisDS(setting, group);
    }

    public RedisDS() {
        this(null, null);
    }

    public RedisDS(String group) {
        this(null, group);
    }

    public RedisDS(Setting setting, String group) {
        this.setting = setting;
        this.init(group);
    }

    public RedisDS init(String group) {
        if (null == this.setting) {
            this.setting = new Setting(REDIS_CONFIG_PATH, true);
        }
        JedisPoolConfig config = new JedisPoolConfig();
        this.setting.toBean(config);
        if (StrUtil.isNotBlank(group)) {
            this.setting.toBean(group, config);
        }
        this.pool = new JedisPool(config, this.setting.getStr("host", group, "localhost"), this.setting.getInt("port", group, 6379), this.setting.getInt("connectionTimeout", group, this.setting.getInt("timeout", group, 2000)), this.setting.getInt("soTimeout", group, this.setting.getInt("timeout", group, 2000)), this.setting.getStr("password", group, null), this.setting.getInt("database", group, 0), this.setting.getStr("clientName", group, "Hutool"), this.setting.getBool("ssl", group, false), null, null, null);
        return this;
    }

    public Jedis getJedis() {
        return this.pool.getResource();
    }

    public String getStr(String key) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.get(key);
            return string;
        }
    }

    public String setStr(String key, String value) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.set(key, value);
            return string;
        }
    }

    public Long del(String ... keys) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.del(keys);
            return l;
        }
    }

    @Override
    public void close() {
        IoUtil.close(this.pool);
    }
}

