/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.net.dblistener;

import com.mugui.sql.SqlModel;
import com.mugui.sql.SqlServer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionStatus;

@Configuration
public class SqlModeTransactionManager
implements PlatformTransactionManager {
    private SqlModel SqlModel = new SqlModel();
    @Value(value="${mugui.SqlModel.status:false}")
    private boolean dataType;

    @Override
    public TransactionStatus getTransaction(TransactionDefinition definition) throws TransactionException {
        if (this.dataType) {
            try {
                this.SqlModel.getSqlServer().setAutoCommit(false);
                if (definition.isReadOnly()) {
                    this.SqlModel.getSqlServer().setLockOfSelect(true);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return new DefaultTransactionStatus(definition, true, false, definition.isReadOnly(), false, null);
        }
        return null;
    }

    @Override
    public void commit(TransactionStatus status) throws TransactionException {
        if (this.dataType) {
            if (!this.SqlModel.getSqlServer().isAutoCommit()) {
                try {
                    this.SqlModel.getSqlServer().commit();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        this.SqlModel.getSqlServer().setAutoCommit(true);
                    }
                    catch (Exception exception) {}
                }
            }
            SqlServer.reback();
        }
    }

    @Override
    public void rollback(TransactionStatus status) throws TransactionException {
        System.out.println("rollback");
        if (this.dataType) {
            if (!this.SqlModel.getSqlServer().isAutoCommit()) {
                try {
                    this.SqlModel.getSqlServer().rollback();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        this.SqlModel.getSqlServer().setAutoCommit(true);
                    }
                    catch (Exception exception) {}
                }
            }
            SqlServer.reback();
        }
    }
}

