/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.net.session;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.util.ArrayUtil;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class SessionContext {
    private static final TimedCache<String, TempSession> mymap = new TimedCache<String, TempSession>(21600000L){

        @Override
        protected void onRemove(String key, TempSession cachedObject) {
            cachedObject.clear();
        }
    };
    private static ThreadLocal<HttpSession> threadLocal;

    public static synchronized void AddSession(HttpSession session) {
        if (session != null) {
            threadLocal.set(session);
            TempSession tempSession = (TempSession)mymap.get(session.getId());
            if (tempSession == null) {
                mymap.put(session.getId(), new TempSession(session));
            } else {
                tempSession.session = session;
            }
        }
    }

    public static HttpSession getLocalSession() {
        return threadLocal.get();
    }

    public static synchronized void DelSession(HttpSession session) {
        if (session != null) {
            try {
                threadLocal.remove();
                mymap.remove(session.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            session.invalidate();
        }
    }

    public static void DelLocalSession() {
        threadLocal.remove();
    }

    public static synchronized HttpSession getSession(String session_id) {
        if (session_id == null) {
            return null;
        }
        return (HttpSession)mymap.get(session_id);
    }

    public static Iterator<TempSession> AllSession() {
        return mymap.iterator();
    }

    static {
        mymap.schedulePrune(3600000L);
        threadLocal = new ThreadLocal();
    }

    private static class TempSession
    implements HttpSession,
    Serializable {
        HttpSession session;
        private ConcurrentHashMap<String, Object> hashMap = new ConcurrentHashMap<String, Object>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void clear() {
                for (Object object : hashMap.values()) {
                    if (!(object instanceof ReentrantLock)) continue;
                    ReentrantLock lock = (ReentrantLock)object;
                    try {
                        if (!lock.isHeldByCurrentThread()) continue;
                        lock.unlock();
                    }
                    catch (Exception exception) {}
                }
                super.clear();
            }
        };

        public void clear() {
            this.hashMap.clear();
        }

        public TempSession(HttpSession session) {
            this.session = session;
        }

        @Override
        public Object getAttribute(String key) {
            Object object = this.hashMap.get(key);
            if (object == null) {
                return this.session.getAttribute(key);
            }
            return object;
        }

        @Override
        public String getId() {
            return this.session.getId();
        }

        @Override
        public void setAttribute(String attributeName, Object attributeValue) {
            this.hashMap.put(attributeName, attributeValue);
            this.session.setAttribute(attributeName, attributeValue);
        }

        @Override
        public void removeAttribute(String attributeName) {
            this.hashMap.remove(attributeName);
            this.session.removeAttribute(attributeName);
        }

        @Override
        public long getCreationTime() {
            return this.session.getCreationTime();
        }

        @Override
        public long getLastAccessedTime() {
            return this.session.getLastAccessedTime();
        }

        @Override
        public ServletContext getServletContext() {
            return this.session.getServletContext();
        }

        @Override
        public void setMaxInactiveInterval(int interval) {
            this.session.setMaxInactiveInterval(interval);
        }

        @Override
        public int getMaxInactiveInterval() {
            return this.session.getMaxInactiveInterval();
        }

        @Override
        public HttpSessionContext getSessionContext() {
            return this.session.getSessionContext();
        }

        @Override
        public Object getValue(String name) {
            Object object = this.hashMap.get(name);
            return object;
        }

        @Override
        public Enumeration<String> getAttributeNames() {
            return this.session.getAttributeNames();
        }

        @Override
        public String[] getValueNames() {
            return ArrayUtil.toArray(new HashSet(this.hashMap.keySet()).iterator(), String.class);
        }

        @Override
        public void putValue(String name, Object value) {
            this.hashMap.put(name, value);
        }

        @Override
        public void removeValue(String name) {
            this.hashMap.remove(name);
        }

        @Override
        public void invalidate() {
            this.session.invalidate();
        }

        @Override
        public boolean isNew() {
            return this.session.isNew();
        }
    }
}

