/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.builders.AbstractBuilder;

public class ApplicationBuilder
extends AbstractBuilder<ApplicationConfig, ApplicationBuilder> {
    private String name;
    private String version;
    private String owner;
    private String organization;
    private String architecture;
    private String environment = "product";
    private String compiler;
    private String logger;
    private List<RegistryConfig> registries;
    private String registryIds;
    private MonitorConfig monitor;
    private Boolean isDefault;
    private String dumpDirectory;
    private Boolean qosEnable;
    private Integer qosPort;
    private Boolean qosAcceptForeignIp;
    private Map<String, String> parameters;
    private String shutwait;

    public ApplicationBuilder name(String name) {
        this.name = name;
        return this.getThis();
    }

    public ApplicationBuilder version(String version) {
        this.version = version;
        return this.getThis();
    }

    public ApplicationBuilder owner(String owner) {
        this.owner = owner;
        return this.getThis();
    }

    public ApplicationBuilder organization(String organization) {
        this.organization = organization;
        return this.getThis();
    }

    public ApplicationBuilder architecture(String architecture) {
        this.architecture = architecture;
        return this.getThis();
    }

    public ApplicationBuilder environment(String environment2) {
        this.environment = environment2;
        return this.getThis();
    }

    public ApplicationBuilder compiler(String compiler) {
        this.compiler = compiler;
        return this.getThis();
    }

    public ApplicationBuilder logger(String logger) {
        this.logger = logger;
        return this.getThis();
    }

    public ApplicationBuilder addRegistry(RegistryConfig registry) {
        if (this.registries == null) {
            this.registries = new ArrayList<RegistryConfig>();
        }
        this.registries.add(registry);
        return this.getThis();
    }

    public ApplicationBuilder addRegistries(List<? extends RegistryConfig> registries) {
        if (this.registries == null) {
            this.registries = new ArrayList<RegistryConfig>();
        }
        this.registries.addAll(registries);
        return this.getThis();
    }

    public ApplicationBuilder registryIds(String registryIds) {
        this.registryIds = registryIds;
        return this.getThis();
    }

    public ApplicationBuilder monitor(MonitorConfig monitor) {
        this.monitor = monitor;
        return this.getThis();
    }

    public ApplicationBuilder monitor(String monitor) {
        this.monitor = new MonitorConfig(monitor);
        return this.getThis();
    }

    public ApplicationBuilder isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this.getThis();
    }

    public ApplicationBuilder dumpDirectory(String dumpDirectory) {
        this.dumpDirectory = dumpDirectory;
        return this.getThis();
    }

    public ApplicationBuilder qosEnable(Boolean qosEnable) {
        this.qosEnable = qosEnable;
        return this.getThis();
    }

    public ApplicationBuilder qosPort(Integer qosPort) {
        this.qosPort = qosPort;
        return this.getThis();
    }

    public ApplicationBuilder qosAcceptForeignIp(Boolean qosAcceptForeignIp) {
        this.qosAcceptForeignIp = qosAcceptForeignIp;
        return this.getThis();
    }

    public ApplicationBuilder shutwait(String shutwait) {
        this.shutwait = shutwait;
        return this.getThis();
    }

    public ApplicationBuilder appendParameter(String key, String value) {
        this.parameters = ApplicationBuilder.appendParameter(this.parameters, key, value);
        return this.getThis();
    }

    public ApplicationBuilder appendParameters(Map<String, String> appendParameters) {
        this.parameters = ApplicationBuilder.appendParameters(this.parameters, appendParameters);
        return this.getThis();
    }

    public ApplicationConfig build() {
        ApplicationConfig config = new ApplicationConfig();
        super.build(config);
        config.setName(this.name);
        config.setVersion(this.version);
        config.setOwner(this.owner);
        config.setOrganization(this.organization);
        config.setArchitecture(this.architecture);
        config.setEnvironment(this.environment);
        config.setCompiler(this.compiler);
        config.setLogger(this.logger);
        config.setRegistries(this.registries);
        config.setRegistryIds(this.registryIds);
        config.setMonitor(this.monitor);
        config.setDefault(this.isDefault);
        config.setDumpDirectory(this.dumpDirectory);
        config.setQosEnable(this.qosEnable);
        config.setQosPort(this.qosPort);
        config.setQosAcceptForeignIp(this.qosAcceptForeignIp);
        config.setParameters(this.parameters);
        if (!StringUtils.isEmpty(this.shutwait)) {
            config.setShutwait(this.shutwait);
        }
        return config;
    }

    @Override
    protected ApplicationBuilder getThis() {
        return this;
    }
}

