/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataActivationContext;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataLoaders;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataLocationResolvers;
import org.springframework.boot.context.config.ConfigDataNotFoundAction;
import org.springframework.boot.context.config.ConfigDataNotFoundException;
import org.springframework.boot.context.config.ConfigDataResolutionResult;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.logging.DeferredLogFactory;

class ConfigDataImporter {
    private final Log logger;
    private final ConfigDataLocationResolvers resolvers;
    private final ConfigDataLoaders loaders;
    private final ConfigDataNotFoundAction notFoundAction;
    private final Set<ConfigDataResource> loaded = new HashSet<ConfigDataResource>();

    ConfigDataImporter(DeferredLogFactory logFactory, ConfigDataNotFoundAction notFoundAction, ConfigDataLocationResolvers resolvers, ConfigDataLoaders loaders) {
        this.logger = logFactory.getLog(this.getClass());
        this.resolvers = resolvers;
        this.loaders = loaders;
        this.notFoundAction = notFoundAction;
    }

    Map<ConfigDataResolutionResult, ConfigData> resolveAndLoad(ConfigDataActivationContext activationContext, ConfigDataLocationResolverContext locationResolverContext, ConfigDataLoaderContext loaderContext, List<ConfigDataLocation> locations) {
        try {
            Profiles profiles = activationContext != null ? activationContext.getProfiles() : null;
            List<ConfigDataResolutionResult> resolved = this.resolve(locationResolverContext, profiles, locations);
            return this.load(loaderContext, resolved);
        }
        catch (IOException ex) {
            throw new IllegalStateException("IO error on loading imports from " + locations, ex);
        }
    }

    private List<ConfigDataResolutionResult> resolve(ConfigDataLocationResolverContext locationResolverContext, Profiles profiles, List<ConfigDataLocation> locations) {
        ArrayList<ConfigDataResolutionResult> resolved = new ArrayList<ConfigDataResolutionResult>(locations.size());
        for (ConfigDataLocation location : locations) {
            resolved.addAll(this.resolve(locationResolverContext, profiles, location));
        }
        return Collections.unmodifiableList(resolved);
    }

    private List<ConfigDataResolutionResult> resolve(ConfigDataLocationResolverContext locationResolverContext, Profiles profiles, ConfigDataLocation location) {
        try {
            return this.resolvers.resolve(locationResolverContext, location, profiles);
        }
        catch (ConfigDataNotFoundException ex) {
            this.handle(ex, location);
            return Collections.emptyList();
        }
    }

    private Map<ConfigDataResolutionResult, ConfigData> load(ConfigDataLoaderContext loaderContext, List<ConfigDataResolutionResult> candidates) throws IOException {
        LinkedHashMap<ConfigDataResolutionResult, ConfigData> result = new LinkedHashMap<ConfigDataResolutionResult, ConfigData>();
        for (int i2 = candidates.size() - 1; i2 >= 0; --i2) {
            ConfigDataResolutionResult candidate = candidates.get(i2);
            ConfigDataLocation location = candidate.getLocation();
            ConfigDataResource resource = candidate.getResource();
            if (!this.loaded.add(resource)) continue;
            try {
                ConfigData loaded = this.loaders.load(loaderContext, resource);
                if (loaded == null) continue;
                result.put(candidate, loaded);
                continue;
            }
            catch (ConfigDataNotFoundException ex) {
                this.handle(ex, location);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private void handle(ConfigDataNotFoundException ex, ConfigDataLocation location) {
        if (ex instanceof ConfigDataResourceNotFoundException) {
            ex = ((ConfigDataResourceNotFoundException)ex).withLocation(location);
        }
        this.getNotFoundAction(location).handle(this.logger, ex);
    }

    private ConfigDataNotFoundAction getNotFoundAction(ConfigDataLocation location) {
        return !location.isOptional() ? this.notFoundAction : ConfigDataNotFoundAction.IGNORE;
    }
}

