/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.reactive.context;

import org.springframework.boot.web.reactive.context.WebServerManager;
import org.springframework.context.SmartLifecycle;

class WebServerGracefulShutdownLifecycle
implements SmartLifecycle {
    private final WebServerManager serverManager;
    private volatile boolean running;

    WebServerGracefulShutdownLifecycle(WebServerManager serverManager) {
        this.serverManager = serverManager;
    }

    @Override
    public void start() {
        this.running = true;
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException("Stop must not be invoked directly");
    }

    @Override
    public void stop(Runnable callback) {
        this.running = false;
        this.serverManager.shutDownGracefully(callback);
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

