/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.metrics.jfr;

import java.util.ArrayDeque;
import java.util.Deque;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.metrics.StartupStep;
import org.springframework.core.metrics.jfr.FlightRecorderStartupStep;

public class FlightRecorderApplicationStartup
implements ApplicationStartup {
    private long currentSequenceId = 0L;
    private final Deque<Long> currentSteps = new ArrayDeque<Long>();

    public FlightRecorderApplicationStartup() {
        this.currentSteps.offerFirst(0L);
    }

    @Override
    public StartupStep start(String name) {
        FlightRecorderStartupStep step = new FlightRecorderStartupStep(++this.currentSequenceId, name, this.currentSteps.getFirst(), committedStep -> this.currentSteps.removeFirst());
        this.currentSteps.offerFirst(this.currentSequenceId);
        return step;
    }
}

