/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.time.Duration;
import org.springframework.data.redis.cache.CacheStatisticsCollector;
import org.springframework.data.redis.cache.CacheStatisticsProvider;
import org.springframework.data.redis.cache.DefaultRedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface RedisCacheWriter
extends CacheStatisticsProvider {
    public static RedisCacheWriter nonLockingRedisCacheWriter(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, "ConnectionFactory must not be null!");
        return new DefaultRedisCacheWriter(connectionFactory);
    }

    public static RedisCacheWriter lockingRedisCacheWriter(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, "ConnectionFactory must not be null!");
        return new DefaultRedisCacheWriter(connectionFactory, Duration.ofMillis(50L));
    }

    public void put(String var1, byte[] var2, byte[] var3, @Nullable Duration var4);

    @Nullable
    public byte[] get(String var1, byte[] var2);

    @Nullable
    public byte[] putIfAbsent(String var1, byte[] var2, byte[] var3, @Nullable Duration var4);

    public void remove(String var1, byte[] var2);

    public void clean(String var1, byte[] var2);

    public void clearStatistics(String var1);

    public RedisCacheWriter withStatisticsCollector(CacheStatisticsCollector var1);
}

