/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class RedisListenerContainerParser
extends AbstractSimpleBeanDefinitionParser {
    RedisListenerContainerParser() {
    }

    protected Class<RedisMessageListenerContainer> getBeanClass(Element element) {
        return RedisMessageListenerContainer.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            if (!this.isEligibleAttribute(attribute, parserContext)) continue;
            String propertyName = this.extractPropertyName(attribute.getLocalName());
            Assert.state(StringUtils.hasText(propertyName), "Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            builder.addPropertyReference(propertyName, attribute.getValue());
        }
        String phase = element.getAttribute("phase");
        if (StringUtils.hasText(phase)) {
            builder.addPropertyValue("phase", phase);
        }
        this.postProcess(builder, element);
        List<Element> listDefs = DomUtils.getChildElementsByTagName(element, "listener");
        if (!listDefs.isEmpty()) {
            ManagedMap<BeanDefinition, Collection> listeners = new ManagedMap<BeanDefinition, Collection>(listDefs.size());
            for (Element listElement : listDefs) {
                Object[] listenerDefinition = this.parseListener(listElement);
                listeners.put((BeanDefinition)listenerDefinition[0], (Collection)listenerDefinition[1]);
            }
            builder.addPropertyValue("messageListeners", listeners);
        }
    }

    @Override
    protected boolean isEligibleAttribute(String attributeName) {
        return !"phase".equals(attributeName);
    }

    private Object[] parseListener(Element element) {
        String serializer;
        Object[] ret = new Object[2];
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MessageListenerAdapter.class);
        builder.addConstructorArgReference(element.getAttribute("ref"));
        String method = element.getAttribute("method");
        if (StringUtils.hasText(method)) {
            builder.addPropertyValue("defaultListenerMethod", method);
        }
        if (StringUtils.hasText(serializer = element.getAttribute("serializer"))) {
            builder.addPropertyReference("serializer", serializer);
        }
        ArrayList<PatternTopic> topics = new ArrayList<PatternTopic>();
        String xTopics = element.getAttribute("topic");
        if (StringUtils.hasText(xTopics)) {
            String[] array;
            for (String string : array = StringUtils.delimitedListToStringArray(xTopics, " ")) {
                topics.add((PatternTopic)(string.contains("*") ? new PatternTopic(string) : new ChannelTopic(string)));
            }
        }
        ret[0] = builder.getBeanDefinition();
        ret[1] = topics;
        return ret;
    }

    @Override
    protected boolean shouldGenerateId() {
        return true;
    }
}

