/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisStandaloneConfiguration
implements RedisConfiguration,
RedisConfiguration.WithHostAndPort,
RedisConfiguration.WithPassword,
RedisConfiguration.WithDatabaseIndex {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 6379;
    private String hostName = "localhost";
    private int port = 6379;
    private int database;
    @Nullable
    private String username = null;
    private RedisPassword password = RedisPassword.none();

    public RedisStandaloneConfiguration() {
    }

    public RedisStandaloneConfiguration(String hostName) {
        this(hostName, 6379);
    }

    public RedisStandaloneConfiguration(String hostName, int port) {
        Assert.hasText(hostName, "Host name must not be null or empty!");
        Assert.isTrue(port >= 1 && port <= 65535, () -> String.format("Port %d must be a valid TCP port in the range between 1-65535!", port));
        this.hostName = hostName;
        this.port = port;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(int index) {
        Assert.isTrue(index >= 0, () -> String.format("Invalid DB index '%s' (a positive index required)", index));
        this.database = index;
    }

    @Override
    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Override
    public RedisPassword getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, "RedisPassword must not be null!");
        this.password = password;
    }
}

