/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.util.Assert;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.params.GeoRadiusParam;

class JedisClusterGeoCommands
implements RedisGeoCommands {
    private final JedisClusterConnection connection;

    JedisClusterGeoCommands(JedisClusterConnection connection) {
        Assert.notNull((Object)connection, "Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Long geoAdd(byte[] key, Point point, byte[] member) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)point, "Point must not be null!");
        Assert.notNull((Object)member, "Member must not be null!");
        try {
            return this.connection.getCluster().geoadd(key, point.getX(), point.getY(), member);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(memberCoordinateMap, "MemberCoordinateMap must not be null!");
        HashMap<byte[], GeoCoordinate> redisGeoCoordinateMap = new HashMap<byte[], GeoCoordinate>();
        for (byte[] mapKey : memberCoordinateMap.keySet()) {
            redisGeoCoordinateMap.put(mapKey, JedisConverters.toGeoCoordinate(memberCoordinateMap.get(mapKey)));
        }
        try {
            return this.connection.getCluster().geoadd(key, redisGeoCoordinateMap);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(locations, "Locations must not be null!");
        HashMap<byte[], GeoCoordinate> redisGeoCoordinateMap = new HashMap<byte[], GeoCoordinate>();
        for (RedisGeoCommands.GeoLocation<byte[]> location : locations) {
            redisGeoCoordinateMap.put(location.getName(), JedisConverters.toGeoCoordinate(location.getPoint()));
        }
        try {
            return this.connection.getCluster().geoadd(key, redisGeoCoordinateMap);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)member1, "Member1 must not be null!");
        Assert.notNull((Object)member2, "Member2 must not be null!");
        try {
            return JedisConverters.distanceConverterForMetric(RedisGeoCommands.DistanceUnit.METERS).convert(this.connection.getCluster().geodist(key, member1, member2));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)member1, "Member1 must not be null!");
        Assert.notNull((Object)member2, "Member2 must not be null!");
        Assert.notNull((Object)metric, "Metric must not be null!");
        GeoUnit geoUnit = JedisConverters.toGeoUnit(metric);
        try {
            return JedisConverters.distanceConverterForMetric(metric).convert(this.connection.getCluster().geodist(key, member1, member2, geoUnit));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<String> geoHash(byte[] key, byte[] ... members) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)members, "Members must not be null!");
        Assert.noNullElements((Object[])members, "Members must not contain null!");
        try {
            return JedisConverters.toStrings(this.connection.getCluster().geohash(key, members));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Point> geoPos(byte[] key, byte[] ... members) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)members, "Members must not be null!");
        Assert.noNullElements((Object[])members, "Members must not contain null!");
        try {
            return JedisConverters.geoCoordinateToPointConverter().convert(this.connection.getCluster().geopos(key, members));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)within, "Within must not be null!");
        try {
            return JedisConverters.geoRadiusResponseToGeoResultsConverter(within.getRadius().getMetric()).convert(this.connection.getCluster().georadius(key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), JedisConverters.toGeoUnit(within.getRadius().getMetric())));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)within, "Within must not be null!");
        Assert.notNull((Object)args, "Args must not be null!");
        GeoRadiusParam geoRadiusParam = JedisConverters.toGeoRadiusParam(args);
        try {
            return JedisConverters.geoRadiusResponseToGeoResultsConverter(within.getRadius().getMetric()).convert(this.connection.getCluster().georadius(key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), JedisConverters.toGeoUnit(within.getRadius().getMetric()), geoRadiusParam));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)member, "Member must not be null!");
        Assert.notNull((Object)radius, "Radius must not be null!");
        GeoUnit geoUnit = JedisConverters.toGeoUnit(radius.getMetric());
        try {
            return JedisConverters.geoRadiusResponseToGeoResultsConverter(radius.getMetric()).convert(this.connection.getCluster().georadiusByMember(key, member, radius.getValue(), geoUnit));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)member, "Member must not be null!");
        Assert.notNull((Object)radius, "Radius must not be null!");
        Assert.notNull((Object)args, "Args must not be null!");
        GeoUnit geoUnit = JedisConverters.toGeoUnit(radius.getMetric());
        GeoRadiusParam geoRadiusParam = JedisConverters.toGeoRadiusParam(args);
        try {
            return JedisConverters.geoRadiusResponseToGeoResultsConverter(radius.getMetric()).convert(this.connection.getCluster().georadiusByMember(key, member, radius.getValue(), geoUnit, geoRadiusParam));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long geoRemove(byte[] key, byte[] ... members) {
        return this.connection.zRem(key, members);
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

