/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.XClaimArgs;
import io.lettuce.core.XGroupCreateArgs;
import io.lettuce.core.XReadArgs;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.data.redis.connection.lettuce.RangeConverter;
import org.springframework.data.redis.connection.lettuce.StreamConverters;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.util.Assert;

class LettuceStreamCommands
implements RedisStreamCommands {
    private final LettuceConnection connection;

    LettuceStreamCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long xAck(byte[] key, String group, RecordId ... recordIds) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.hasText(group, "Group name must not be null or empty!");
        Assert.notNull((Object)recordIds, "recordIds must not be null!");
        String[] ids = LettuceStreamCommands.entryIdsToString(recordIds);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xack((Object)key, (Object)LettuceConverters.toBytes(group), ids)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xack((Object)key, (Object)LettuceConverters.toBytes(group), ids)));
                return null;
            }
            return this.getConnection().xack((Object)key, (Object)LettuceConverters.toBytes(group), ids);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record, RedisStreamCommands.XAddOptions options) {
        Assert.notNull(record.getStream(), "Stream must not be null!");
        Assert.notNull(record, "Record must not be null!");
        XAddArgs args = new XAddArgs();
        args.id(record.getId().getValue());
        if (options.hasMaxlen()) {
            args.maxlen(options.getMaxlen().longValue());
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xadd(record.getStream(), args, (Map)record.getValue()), RecordId::of));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xadd(record.getStream(), args, (Map)record.getValue()), RecordId::of));
                return null;
            }
            return RecordId.of(this.getConnection().xadd(record.getStream(), args, (Map)record.getValue()));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<RecordId> xClaimJustId(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        String[] ids = options.getIdsAsStringArray();
        io.lettuce.core.Consumer from = io.lettuce.core.Consumer.from((Object)LettuceConverters.toBytes(group), (Object)LettuceConverters.toBytes(newOwner));
        XClaimArgs args = StreamConverters.toXClaimArgs(options).justid();
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xclaim((Object)key, from, args, ids), StreamConverters.messagesToIds()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xclaim((Object)key, from, args, ids), StreamConverters.messagesToIds()));
                return null;
            }
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
        return StreamConverters.messagesToIds().convert(this.getConnection().xclaim((Object)key, from, args, ids));
    }

    @Override
    public List<ByteRecord> xClaim(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        String[] ids = options.getIdsAsStringArray();
        io.lettuce.core.Consumer from = io.lettuce.core.Consumer.from((Object)LettuceConverters.toBytes(group), (Object)LettuceConverters.toBytes(newOwner));
        XClaimArgs args = StreamConverters.toXClaimArgs(options);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xclaim((Object)key, from, args, ids), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xclaim((Object)key, from, args, ids), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return StreamConverters.byteRecordListConverter().convert(this.getConnection().xclaim((Object)key, from, args, ids));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long xDel(byte[] key, RecordId ... recordIds) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)recordIds, "recordIds must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xdel((Object)key, LettuceStreamCommands.entryIdsToString(recordIds))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xdel((Object)key, LettuceStreamCommands.entryIdsToString(recordIds))));
                return null;
            }
            return this.getConnection().xdel((Object)key, LettuceStreamCommands.entryIdsToString(recordIds));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset) {
        return this.xGroupCreate(key, groupName, readOffset, false);
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset, boolean mkSteam) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.hasText(groupName, "Group name must not be null or empty!");
        Assert.notNull((Object)readOffset, "ReadOffset must not be null!");
        try {
            XReadArgs.StreamOffset streamOffset = XReadArgs.StreamOffset.from((Object)key, (String)readOffset.getOffset());
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xgroupCreate(streamOffset, (Object)LettuceConverters.toBytes(groupName), XGroupCreateArgs.Builder.mkstream((boolean)mkSteam))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xgroupCreate(streamOffset, (Object)LettuceConverters.toBytes(groupName), XGroupCreateArgs.Builder.mkstream((boolean)mkSteam))));
                return null;
            }
            return this.getConnection().xgroupCreate(streamOffset, (Object)LettuceConverters.toBytes(groupName), XGroupCreateArgs.Builder.mkstream((boolean)mkSteam));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean xGroupDelConsumer(byte[] key, Consumer consumer) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)consumer, "Consumer must not be null!");
        try {
            io.lettuce.core.Consumer<byte[]> lettuceConsumer = LettuceStreamCommands.toConsumer(consumer);
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xgroupDelconsumer((Object)key, lettuceConsumer), Objects::nonNull));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xgroupDelconsumer((Object)key, lettuceConsumer), Objects::nonNull));
                return null;
            }
            return Objects.nonNull(this.getConnection().xgroupDelconsumer((Object)key, lettuceConsumer));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean xGroupDestroy(byte[] key, String groupName) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.hasText(groupName, "Group name must not be null or empty!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xgroupDestroy((Object)key, (Object)LettuceConverters.toBytes(groupName))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xgroupDestroy((Object)key, (Object)LettuceConverters.toBytes(groupName))));
                return null;
            }
            return this.getConnection().xgroupDestroy((Object)key, (Object)LettuceConverters.toBytes(groupName));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public StreamInfo.XInfoStream xInfo(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xinfoStream((Object)key), StreamInfo.XInfoStream::fromList));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xinfoStream((Object)key), StreamInfo.XInfoStream::fromList));
                return null;
            }
            return StreamInfo.XInfoStream.fromList(this.getConnection().xinfoStream((Object)key));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public StreamInfo.XInfoGroups xInfoGroups(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xinfoGroups((Object)key), StreamInfo.XInfoGroups::fromList));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xinfoGroups((Object)key), StreamInfo.XInfoGroups::fromList));
                return null;
            }
            return StreamInfo.XInfoGroups.fromList(this.getConnection().xinfoGroups((Object)key));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public StreamInfo.XInfoConsumers xInfoConsumers(byte[] key, String groupName) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)groupName, "GroupName must not be null!");
        byte[] binaryGroupName = LettuceConverters.toBytes(groupName);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xinfoConsumers((Object)key, (Object)binaryGroupName), it -> StreamInfo.XInfoConsumers.fromList(groupName, it)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xinfoConsumers((Object)key, (Object)binaryGroupName), it -> StreamInfo.XInfoConsumers.fromList(groupName, it)));
                return null;
            }
            return StreamInfo.XInfoConsumers.fromList(groupName, this.getConnection().xinfoConsumers((Object)key, (Object)binaryGroupName));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long xLen(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xlen((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xlen((Object)key)));
                return null;
            }
            return this.getConnection().xlen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public PendingMessagesSummary xPending(byte[] key, String groupName) {
        byte[] group = LettuceConverters.toBytes(groupName);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xpending((Object)key, (Object)group), it -> StreamConverters.toPendingMessagesInfo(groupName, it)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xpending((Object)key, (Object)group), it -> StreamConverters.toPendingMessagesInfo(groupName, it)));
                return null;
            }
            return StreamConverters.toPendingMessagesInfo(groupName, this.getConnection().xpending((Object)key, (Object)group));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public PendingMessages xPending(byte[] key, String groupName, RedisStreamCommands.XPendingOptions options) {
        byte[] group = LettuceConverters.toBytes(groupName);
        Range<String> range = RangeConverter.toRangeWithDefault(options.getRange(), "-", "+", Function.identity());
        Limit limit = options.isLimited() ? Limit.from((long)options.getCount()) : Limit.unlimited();
        try {
            if (options.hasConsumer()) {
                if (this.isPipelined()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xpending((Object)key, io.lettuce.core.Consumer.from((Object)group, (Object)LettuceConverters.toBytes(options.getConsumerName())), range, limit), it -> StreamConverters.toPendingMessages(groupName, options.getRange(), it)));
                    return null;
                }
                if (this.isQueueing()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xpending((Object)key, io.lettuce.core.Consumer.from((Object)group, (Object)LettuceConverters.toBytes(options.getConsumerName())), range, limit), it -> StreamConverters.toPendingMessages(groupName, options.getRange(), it)));
                    return null;
                }
                return StreamConverters.toPendingMessages(groupName, options.getRange(), this.getConnection().xpending((Object)key, io.lettuce.core.Consumer.from((Object)group, (Object)LettuceConverters.toBytes(options.getConsumerName())), range, limit));
            }
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xpending((Object)key, (Object)group, range, limit), it -> StreamConverters.toPendingMessages(groupName, options.getRange(), it)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xpending((Object)key, (Object)group, range, limit), it -> StreamConverters.toPendingMessages(groupName, options.getRange(), it)));
                return null;
            }
            return StreamConverters.toPendingMessages(groupName, options.getRange(), this.getConnection().xpending((Object)key, (Object)group, range, limit));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xRange(byte[] key, org.springframework.data.domain.Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(range, "Range must not be null!");
        Assert.notNull((Object)limit, "Limit must not be null!");
        Range lettuceRange = RangeConverter.toRange(range, Function.identity());
        Limit lettuceLimit = LettuceConverters.toLimit(limit);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xrange((Object)key, lettuceRange, lettuceLimit), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xrange((Object)key, lettuceRange, lettuceLimit), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return StreamConverters.byteRecordListConverter().convert(this.getConnection().xrange((Object)key, lettuceRange, lettuceLimit));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xRead(StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, "StreamReadOptions must not be null!");
        Assert.notNull(streams, "StreamOffsets must not be null!");
        XReadArgs.StreamOffset<byte[]>[] streamOffsets = LettuceStreamCommands.toStreamOffsets(streams);
        XReadArgs args = StreamConverters.toReadArgs(readOptions);
        if (readOptions.isBlocking()) {
            try {
                if (this.isPipelined()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncDedicatedConnection().xread(args, streamOffsets), StreamConverters.byteRecordListConverter()));
                    return null;
                }
                if (this.isQueueing()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncDedicatedConnection().xread(args, streamOffsets), StreamConverters.byteRecordListConverter()));
                    return null;
                }
                return StreamConverters.byteRecordListConverter().convert(this.getDedicatedConnection().xread(args, streamOffsets));
            }
            catch (Exception ex) {
                throw this.convertLettuceAccessException(ex);
            }
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xread(args, streamOffsets), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xread(args, streamOffsets), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return StreamConverters.byteRecordListConverter().convert(this.getConnection().xread(args, streamOffsets));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xReadGroup(Consumer consumer, StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)consumer, "Consumer must not be null!");
        Assert.notNull((Object)readOptions, "StreamReadOptions must not be null!");
        Assert.notNull(streams, "StreamOffsets must not be null!");
        XReadArgs.StreamOffset<byte[]>[] streamOffsets = LettuceStreamCommands.toStreamOffsets(streams);
        XReadArgs args = StreamConverters.toReadArgs(readOptions);
        io.lettuce.core.Consumer<byte[]> lettuceConsumer = LettuceStreamCommands.toConsumer(consumer);
        if (readOptions.isBlocking()) {
            try {
                if (this.isPipelined()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncDedicatedConnection().xreadgroup(lettuceConsumer, args, streamOffsets), StreamConverters.byteRecordListConverter()));
                    return null;
                }
                if (this.isQueueing()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncDedicatedConnection().xreadgroup(lettuceConsumer, args, streamOffsets), StreamConverters.byteRecordListConverter()));
                    return null;
                }
                return StreamConverters.byteRecordListConverter().convert(this.getDedicatedConnection().xreadgroup(lettuceConsumer, args, streamOffsets));
            }
            catch (Exception ex) {
                throw this.convertLettuceAccessException(ex);
            }
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xreadgroup(lettuceConsumer, args, streamOffsets), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xreadgroup(lettuceConsumer, args, streamOffsets), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return StreamConverters.byteRecordListConverter().convert(this.getConnection().xreadgroup(lettuceConsumer, args, streamOffsets));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xRevRange(byte[] key, org.springframework.data.domain.Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(range, "Range must not be null!");
        Assert.notNull((Object)limit, "Limit must not be null!");
        Range lettuceRange = RangeConverter.toRange(range, Function.identity());
        Limit lettuceLimit = LettuceConverters.toLimit(limit);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xrevrange((Object)key, lettuceRange, lettuceLimit), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xrevrange((Object)key, lettuceRange, lettuceLimit), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return StreamConverters.byteRecordListConverter().convert(this.getConnection().xrevrange((Object)key, lettuceRange, lettuceLimit));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long xTrim(byte[] key, long count) {
        return this.xTrim(key, count, false);
    }

    @Override
    public Long xTrim(byte[] key, long count, boolean approximateTrimming) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xtrim((Object)key, approximateTrimming, count)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xtrim((Object)key, approximateTrimming, count)));
                return null;
            }
            return this.getConnection().xtrim((Object)key, approximateTrimming, count);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncDedicatedConnection() {
        return this.connection.getAsyncDedicatedConnection();
    }

    RedisClusterCommands<byte[], byte[]> getDedicatedConnection() {
        return this.connection.getDedicatedConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    private static XReadArgs.StreamOffset<byte[]>[] toStreamOffsets(StreamOffset<byte[]>[] streams) {
        return (XReadArgs.StreamOffset[])Arrays.stream(streams).map(it -> XReadArgs.StreamOffset.from(it.getKey(), (String)it.getOffset().getOffset())).toArray(XReadArgs.StreamOffset[]::new);
    }

    private static io.lettuce.core.Consumer<byte[]> toConsumer(Consumer consumer) {
        return io.lettuce.core.Consumer.from((Object)LettuceConverters.toBytes(consumer.getGroup()), (Object)LettuceConverters.toBytes(consumer.getName()));
    }

    private static String[] entryIdsToString(RecordId[] recordIds) {
        if (recordIds.length == 1) {
            return new String[]{recordIds[0].getValue()};
        }
        return (String[])Arrays.stream(recordIds).map(RecordId::getValue).toArray(String[]::new);
    }
}

