/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Consumer {
    private final String group;
    private final String name;

    private Consumer(String group, String name) {
        this.group = group;
        this.name = name;
    }

    public static Consumer from(String group, String name) {
        Assert.hasText(group, "Group must not be null");
        Assert.hasText(name, "Name must not be null");
        return new Consumer(group, name);
    }

    public String toString() {
        return String.format("%s:%s", this.group, this.name);
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Consumer consumer = (Consumer)o;
        if (!ObjectUtils.nullSafeEquals(this.group, consumer.group)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.name, consumer.name);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.group);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.name);
        return result;
    }
}

