/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.redis.connection.stream.ByteBufferRecord;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StringRecord;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class StreamRecords {
    public static ByteRecord rawBytes(Map<byte[], byte[]> raw) {
        return new ByteMapBackedRecord(null, RecordId.autoGenerate(), raw);
    }

    public static ByteBufferRecord rawBuffer(Map<ByteBuffer, ByteBuffer> raw) {
        return new ByteBufferMapBackedRecord(null, RecordId.autoGenerate(), raw);
    }

    public static StringRecord string(Map<String, String> raw) {
        return new StringMapBackedRecord(null, RecordId.autoGenerate(), raw);
    }

    public static <S, K, V> MapRecord<S, K, V> mapBacked(Map<K, V> map) {
        return new MapBackedRecord<Object, K, V>(null, RecordId.autoGenerate(), map);
    }

    public static <S, V> ObjectRecord<S, V> objectBacked(V value) {
        return new ObjectBackedRecord<Object, V>(null, RecordId.autoGenerate(), value);
    }

    public static RecordBuilder<?> newRecord() {
        return new RecordBuilder<Object>(null, RecordId.autoGenerate());
    }

    private StreamRecords() {
    }

    static class ObjectBackedRecord<S, V>
    implements ObjectRecord<S, V> {
        @Nullable
        private S stream;
        private RecordId recordId;
        private final V value;

        ObjectBackedRecord(@Nullable S stream, RecordId recordId, V value) {
            this.stream = stream;
            this.recordId = recordId;
            this.value = value;
        }

        @Override
        @Nullable
        public S getStream() {
            return this.stream;
        }

        @Override
        @Nullable
        public RecordId getId() {
            return this.recordId;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public ObjectRecord<S, V> withId(RecordId id) {
            return new ObjectBackedRecord<S, V>(this.stream, id, this.value);
        }

        @Override
        public <SK> ObjectRecord<SK, V> withStreamKey(SK key) {
            return new ObjectBackedRecord<SK, V>(key, this.recordId, this.value);
        }

        public String toString() {
            return "ObjectBackedRecord{recordId=" + this.recordId + ", value=" + this.value + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectBackedRecord that = (ObjectBackedRecord)o;
            if (!ObjectUtils.nullSafeEquals(this.stream, that.stream)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.recordId, that.recordId)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.value, that.value);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode(this.stream);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.recordId);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.value);
            return result;
        }
    }

    static class StringMapBackedRecord
    extends MapBackedRecord<String, String, String>
    implements StringRecord {
        StringMapBackedRecord(String stream, RecordId recordId, Map<String, String> stringStringMap) {
            super(stream, recordId, stringStringMap);
        }

        @Override
        public StringRecord withStreamKey(String key) {
            return new StringMapBackedRecord(key, this.getId(), (Map<String, String>)this.getValue());
        }

        @Override
        public StringMapBackedRecord withId(RecordId id) {
            return new StringMapBackedRecord((String)this.getStream(), id, (Map<String, String>)this.getValue());
        }
    }

    static class ByteBufferMapBackedRecord
    extends MapBackedRecord<ByteBuffer, ByteBuffer, ByteBuffer>
    implements ByteBufferRecord {
        ByteBufferMapBackedRecord(ByteBuffer stream, RecordId recordId, Map<ByteBuffer, ByteBuffer> map) {
            super(stream, recordId, map);
        }

        @Override
        public ByteBufferMapBackedRecord withStreamKey(ByteBuffer key) {
            return new ByteBufferMapBackedRecord(key, this.getId(), (Map<ByteBuffer, ByteBuffer>)this.getValue());
        }

        @Override
        public ByteBufferMapBackedRecord withId(RecordId id) {
            return new ByteBufferMapBackedRecord((ByteBuffer)this.getStream(), id, (Map<ByteBuffer, ByteBuffer>)this.getValue());
        }
    }

    static class ByteMapBackedRecord
    extends MapBackedRecord<byte[], byte[], byte[]>
    implements ByteRecord {
        ByteMapBackedRecord(byte[] stream, RecordId recordId, Map<byte[], byte[]> map) {
            super(stream, recordId, map);
        }

        @Override
        public ByteMapBackedRecord withStreamKey(byte[] key) {
            return new ByteMapBackedRecord(key, this.getId(), (Map<byte[], byte[]>)this.getValue());
        }

        @Override
        public ByteMapBackedRecord withId(RecordId id) {
            return new ByteMapBackedRecord((byte[])this.getStream(), id, (Map<byte[], byte[]>)this.getValue());
        }
    }

    static class MapBackedRecord<S, K, V>
    implements MapRecord<S, K, V> {
        @Nullable
        private S stream;
        private RecordId recordId;
        private final Map<K, V> kvMap;

        MapBackedRecord(@Nullable S stream, RecordId recordId, Map<K, V> kvMap) {
            this.stream = stream;
            this.recordId = recordId;
            this.kvMap = kvMap;
        }

        @Override
        @Nullable
        public S getStream() {
            return this.stream;
        }

        @Override
        @Nullable
        public RecordId getId() {
            return this.recordId;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.kvMap.entrySet().iterator();
        }

        @Override
        public Map<K, V> getValue() {
            return this.kvMap;
        }

        @Override
        public MapRecord<S, K, V> withId(RecordId id) {
            return new MapBackedRecord<S, K, V>(this.stream, id, this.kvMap);
        }

        @Override
        public <S1> MapRecord<S1, K, V> withStreamKey(S1 key) {
            return new MapBackedRecord<S1, K, V>(key, this.recordId, this.kvMap);
        }

        public String toString() {
            return "MapBackedRecord{recordId=" + this.recordId + ", kvMap=" + this.kvMap + '}';
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!ClassUtils.isAssignable(MapBackedRecord.class, o.getClass())) {
                return false;
            }
            MapBackedRecord that = (MapBackedRecord)o;
            if (!ObjectUtils.nullSafeEquals(this.stream, that.stream)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.recordId, that.recordId)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.kvMap, that.kvMap);
        }

        public int hashCode() {
            int result = this.stream != null ? this.stream.hashCode() : 0;
            result = 31 * result + this.recordId.hashCode();
            result = 31 * result + this.kvMap.hashCode();
            return result;
        }
    }

    public static class RecordBuilder<S> {
        private RecordId id;
        private S stream;

        RecordBuilder(@Nullable S stream, RecordId recordId) {
            this.stream = stream;
            this.id = recordId;
        }

        public <STREAM_KEY> RecordBuilder<STREAM_KEY> in(STREAM_KEY stream) {
            Assert.notNull(stream, "Stream key must not be null");
            return new RecordBuilder<STREAM_KEY>(stream, this.id);
        }

        public RecordBuilder<S> withId(String id) {
            return this.withId(RecordId.of(id));
        }

        public RecordBuilder<S> withId(RecordId id) {
            Assert.notNull((Object)id, "RecordId must not be null");
            this.id = id;
            return this;
        }

        public <K, V> MapRecord<S, K, V> ofMap(Map<K, V> map) {
            return new MapBackedRecord<S, K, V>(this.stream, this.id, map);
        }

        public StringRecord ofStrings(Map<String, String> map) {
            return new StringMapBackedRecord(ObjectUtils.nullSafeToString(this.stream), this.id, map);
        }

        public <V> ObjectRecord<S, V> ofObject(V value) {
            return new ObjectBackedRecord<S, V>(this.stream, this.id, value);
        }

        public ByteRecord ofBytes(Map<byte[], byte[]> value) {
            return new ByteMapBackedRecord((byte[])this.stream, this.id, value);
        }

        public ByteBufferRecord ofBuffer(Map<ByteBuffer, ByteBuffer> value) {
            ByteBuffer streamKey;
            if (this.stream instanceof ByteBuffer) {
                streamKey = (ByteBuffer)this.stream;
            } else if (this.stream instanceof String) {
                streamKey = ByteUtils.getByteBuffer((String)this.stream);
            } else if (this.stream instanceof byte[]) {
                streamKey = ByteBuffer.wrap((byte[])this.stream);
            } else {
                throw new IllegalArgumentException(String.format("Stream key %s cannot be converted to byte buffer.", this.stream));
            }
            return new ByteBufferMapBackedRecord(streamKey, this.id, value);
        }
    }
}

