/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.core.BoundStreamOperations;
import org.springframework.data.redis.core.DefaultBoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.lang.Nullable;

class DefaultBoundStreamOperations<K, HK, HV>
extends DefaultBoundKeyOperations<K>
implements BoundStreamOperations<K, HK, HV> {
    private final StreamOperations<K, HK, HV> ops;

    DefaultBoundStreamOperations(K key, RedisOperations<K, ?> operations) {
        super(key, operations);
        this.ops = operations.opsForStream();
    }

    @Override
    @Nullable
    public Long acknowledge(String group, String ... recordIds) {
        return this.ops.acknowledge(this.getKey(), group, recordIds);
    }

    @Override
    @Nullable
    public RecordId add(Map<HK, HV> body2) {
        return this.ops.add(this.getKey(), body2);
    }

    @Override
    @Nullable
    public Long delete(String ... recordIds) {
        return this.ops.delete(this.getKey(), recordIds);
    }

    @Override
    @Nullable
    public String createGroup(ReadOffset readOffset, String group) {
        return this.ops.createGroup(this.getKey(), readOffset, group);
    }

    @Override
    @Nullable
    public Boolean deleteConsumer(Consumer consumer) {
        return this.ops.deleteConsumer(this.getKey(), consumer);
    }

    @Override
    @Nullable
    public Boolean destroyGroup(String group) {
        return this.ops.destroyGroup(this.getKey(), group);
    }

    @Override
    @Nullable
    public Long size() {
        return this.ops.size(this.getKey());
    }

    @Override
    @Nullable
    public List<MapRecord<K, HK, HV>> range(Range<String> range, RedisZSetCommands.Limit limit) {
        return this.ops.range(this.getKey(), range, limit);
    }

    @Override
    @Nullable
    public List<MapRecord<K, HK, HV>> read(StreamReadOptions readOptions, ReadOffset readOffset) {
        return this.ops.read(readOptions, StreamOffset.create(this.getKey(), readOffset));
    }

    @Override
    @Nullable
    public List<MapRecord<K, HK, HV>> read(Consumer consumer, StreamReadOptions readOptions, ReadOffset readOffset) {
        return this.ops.read(consumer, readOptions, StreamOffset.create(this.getKey(), readOffset));
    }

    @Override
    @Nullable
    public List<MapRecord<K, HK, HV>> reverseRange(Range<String> range, RedisZSetCommands.Limit limit) {
        return this.ops.reverseRange(this.getKey(), range, limit);
    }

    @Override
    @Nullable
    public Long trim(long count) {
        return this.trim(count, false);
    }

    @Override
    @Nullable
    public Long trim(long count, boolean approximateTrimming) {
        return this.ops.trim(this.getKey(), count, approximateTrimming);
    }

    @Override
    @Nullable
    public DataType getType() {
        return DataType.STREAM;
    }
}

