/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.HashMapperProvider;
import org.springframework.data.redis.core.StreamObjectMapper;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface StreamOperations<K, HK, HV>
extends HashMapperProvider<HK, HV> {
    @Nullable
    public Long acknowledge(K var1, String var2, String ... var3);

    @Nullable
    default public Long acknowledge(K key, String group, RecordId ... recordIds) {
        return this.acknowledge(key, group, (String[])Arrays.stream(recordIds).map(RecordId::getValue).toArray(String[]::new));
    }

    default public Long acknowledge(String group, Record<K, ?> record) {
        return this.acknowledge(record.getStream(), group, record.getId());
    }

    @Nullable
    default public RecordId add(K key, Map<? extends HK, ? extends HV> content) {
        return this.add(StreamRecords.newRecord().in(key).ofMap(content));
    }

    @Nullable
    default public RecordId add(MapRecord<K, ? extends HK, ? extends HV> record) {
        return this.add((Record<K, ?>)record);
    }

    @Nullable
    public RecordId add(Record<K, ?> var1);

    @Nullable
    default public Long delete(K key, String ... recordIds) {
        return this.delete(key, (RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
    }

    @Nullable
    default public Long delete(Record<K, ?> record) {
        return this.delete(record.getStream(), record.getId());
    }

    @Nullable
    public Long delete(K var1, RecordId ... var2);

    default public String createGroup(K key, String group) {
        return this.createGroup(key, ReadOffset.latest(), group);
    }

    @Nullable
    public String createGroup(K var1, ReadOffset var2, String var3);

    @Nullable
    public Boolean deleteConsumer(K var1, Consumer var2);

    @Nullable
    public Boolean destroyGroup(K var1, String var2);

    public StreamInfo.XInfoConsumers consumers(K var1, String var2);

    public StreamInfo.XInfoGroups groups(K var1);

    public StreamInfo.XInfoStream info(K var1);

    @Nullable
    public PendingMessagesSummary pending(K var1, String var2);

    default public PendingMessages pending(K key, Consumer consumer) {
        return this.pending(key, consumer, Range.unbounded(), -1L);
    }

    public PendingMessages pending(K var1, String var2, Range<?> var3, long var4);

    public PendingMessages pending(K var1, Consumer var2, Range<?> var3, long var4);

    @Nullable
    public Long size(K var1);

    @Nullable
    default public List<MapRecord<K, HK, HV>> range(K key, Range<String> range) {
        return this.range(key, range, RedisZSetCommands.Limit.unlimited());
    }

    @Nullable
    public List<MapRecord<K, HK, HV>> range(K var1, Range<String> var2, RedisZSetCommands.Limit var3);

    default public <V> List<ObjectRecord<K, V>> range(Class<V> targetType, K key, Range<String> range) {
        return this.range(targetType, key, range, RedisZSetCommands.Limit.unlimited());
    }

    default public <V> List<ObjectRecord<K, V>> range(Class<V> targetType, K key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(targetType, "Target type must not be null");
        return this.map(this.range(key, range, limit), targetType);
    }

    @Nullable
    default public List<MapRecord<K, HK, HV>> read(StreamOffset<K> ... streams) {
        return this.read(StreamReadOptions.empty(), streams);
    }

    default public <V> List<ObjectRecord<K, V>> read(Class<V> targetType, StreamOffset<K> ... streams) {
        return this.read(targetType, StreamReadOptions.empty(), streams);
    }

    @Nullable
    public List<MapRecord<K, HK, HV>> read(StreamReadOptions var1, StreamOffset<K> ... var2);

    @Nullable
    default public <V> List<ObjectRecord<K, V>> read(Class<V> targetType, StreamReadOptions readOptions, StreamOffset<K> ... streams) {
        Assert.notNull(targetType, "Target type must not be null");
        return this.map(this.read(readOptions, streams), targetType);
    }

    @Nullable
    default public List<MapRecord<K, HK, HV>> read(Consumer consumer, StreamOffset<K> ... streams) {
        return this.read(consumer, StreamReadOptions.empty(), streams);
    }

    @Nullable
    default public <V> List<ObjectRecord<K, V>> read(Class<V> targetType, Consumer consumer, StreamOffset<K> ... streams) {
        return this.read(targetType, consumer, StreamReadOptions.empty(), streams);
    }

    @Nullable
    public List<MapRecord<K, HK, HV>> read(Consumer var1, StreamReadOptions var2, StreamOffset<K> ... var3);

    @Nullable
    default public <V> List<ObjectRecord<K, V>> read(Class<V> targetType, Consumer consumer, StreamReadOptions readOptions, StreamOffset<K> ... streams) {
        Assert.notNull(targetType, "Target type must not be null");
        return this.map(this.read(consumer, readOptions, streams), targetType);
    }

    @Nullable
    default public List<MapRecord<K, HK, HV>> reverseRange(K key, Range<String> range) {
        return this.reverseRange(key, range, RedisZSetCommands.Limit.unlimited());
    }

    @Nullable
    public List<MapRecord<K, HK, HV>> reverseRange(K var1, Range<String> var2, RedisZSetCommands.Limit var3);

    default public <V> List<ObjectRecord<K, V>> reverseRange(Class<V> targetType, K key, Range<String> range) {
        return this.reverseRange(targetType, key, range, RedisZSetCommands.Limit.unlimited());
    }

    default public <V> List<ObjectRecord<K, V>> reverseRange(Class<V> targetType, K key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(targetType, "Target type must not be null");
        return this.map(this.reverseRange(key, range, limit), targetType);
    }

    @Nullable
    public Long trim(K var1, long var2);

    @Nullable
    public Long trim(K var1, long var2, boolean var4);

    @Override
    public <V> HashMapper<V, HK, HV> getHashMapper(Class<V> var1);

    default public <V> ObjectRecord<K, V> map(MapRecord<K, HK, HV> record, Class<V> targetType) {
        Assert.notNull(record, "Record must not be null");
        Assert.notNull(targetType, "Target type must not be null");
        return StreamObjectMapper.toObjectRecord(record, this, targetType);
    }

    @Nullable
    default public <V> List<ObjectRecord<K, V>> map(@Nullable List<MapRecord<K, HK, HV>> records, Class<V> targetType) {
        Assert.notNull(records, "Records must not be null");
        Assert.notNull(targetType, "Target type must not be null");
        return StreamObjectMapper.toObjectRecords(records, this, targetType);
    }

    public MapRecord<K, HK, HV> deserializeRecord(ByteRecord var1);
}

