package com.mugui.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.sql.DataSource;

import lombok.Getter;

 class SqlUtils {
	private DataSource dataSource;

	private Connection connection = null;
	@Getter
	private PreparedStatement preparedStatement = null;

	public SqlUtils() {
		this.dataSource = DBConf.getDefaultDBConf().getDataSource();
	}

	public SqlUtils(DBConf dbConf) {
		this.dataSource = dbConf.getDataSource();
	}

	private Connection getConnection() throws SQLException {
		if (connection == null) {
			connection = dataSource.getConnection();
			if (!autoCommit)
				connection.setAutoCommit(autoCommit);
			return connection;
		}
		return connection;
	}

	private boolean lock_of_update = false;

	public void setLockOfSelect(boolean lock_of_update) {
		this.lock_of_update = lock_of_update;
	}

	public ResultSet select(String sql, Object[] parvar) throws SQLException {
		if (sql == null)
			throw new NullPointerException("SQL is null");
		if (lock_of_update) {
			sql += " for update";
		}
		handerParameter(sql, parvar);
		return preparedStatement.executeQuery();
	}

	private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	private void handerParameter(String sql, Object[] parvar) throws SQLException {
		preparedStatement = getConnection().prepareStatement(sql);
		if (parvar != null && parvar.length > 0)
			for (int i = 0; i < parvar.length; ++i) {
				if (parvar[i] == null)
					continue;
				if (parvar[i].getClass() == Date.class) {
					parvar[i] = format.format((Date) parvar[i]);
//					preparedStatement.setString(i + 1, (String) parvar[i]);
				}
//				if (parvar[i].getClass() == Integer.class || parvar[i].getClass() == int.class) {
//					preparedStatement.setInt(i + 1, (int) parvar[i]);
//				}
//				else if (parvar[i].getClass() == BigInteger.class) {
//					preparedStatement.setLong(i + 1, ((BigInteger) parvar[i]).longValue());
//				}
//				else if (parvar[i].getClass() == Long.class || parvar[i].getClass() == long.class) {
//					preparedStatement.setLong(i + 1, ((Long) parvar[i]).longValue());
//				}
//				else
//					preparedStatement.setString(i + 1, String.valueOf(parvar[i]));
				preparedStatement.setObject(i + 1, parvar[i]);
			}

	}

	public int update(String sql, Object[] parvar) throws SQLException {
		if (sql == null)
			throw new NullPointerException("SQL is null");
		int k = 0;
		handerParameter(sql, parvar);
		k = preparedStatement.executeUpdate();
		return k;
	}

	public void Close() {
		if (connection != null) {
			try {
				connection.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
			connection = null;
		}
	}

	/**
	 * 不可靠的检测
	 * 
	 * @auther 木鬼
	 * @return
	 * @throws SQLException
	 */
	@Deprecated
	public boolean isClose() throws SQLException {
		return connection.isClosed();
	}

	/**
	 * 批量执行
	 * 
	 * @auther 木鬼
	 * @param sqls
	 * @throws SQLException
	 */
	public void batch(String[] sqls) throws SQLException {
		if (sqls == null)
			throw new NullPointerException("SQL is null");
		connection.setAutoCommit(false);
		Statement statement = connection.createStatement();
		for (String sql : sqls) {
			statement.addBatch(sql);
		}
		statement.executeBatch();
		connection.commit();
		connection.setAutoCommit(true);
		statement.close();
	}

	public void rollback() throws SQLException {
		if (connection != null && !connection.getAutoCommit()) {
			connection.rollback();
		}
	}

	public void commit() throws SQLException {
		if (connection != null&& !connection.getAutoCommit()) {
			connection.commit();
		}
	}

	private boolean autoCommit = true;

	public void setAutoCommit(boolean bool) throws SQLException {
		lock_of_update = false;
		autoCommit = bool;
		if (connection != null) {
			connection.setAutoCommit(autoCommit);
		}
	}

	public boolean getAutoCommit() throws SQLException {
		return autoCommit;
	}

	public void closePreparedStatement() {
		if (preparedStatement != null) {
			try {
				preparedStatement.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
			preparedStatement = null;
		}
	}

}