/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.sql;

import com.alibaba.fastjson.annotation.JSONField;
import com.mugui.bean.JsonBean;
import com.mugui.sql.datasource.DataSource;
import com.mugui.sql.datasource.HikariCPDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class DBConf
extends JsonBean {
    private static final String DEFAULT_CONFIG_URL = "default.sql";
    private static String DATA_SOURCE_CLASS_NAME = HikariCPDataSource.class.getName();
    private static final long serialVersionUID = -2184676836370105530L;
    private static DBConf instance = null;
    private static final ConcurrentHashMap<String, DBConf> DB_CONF_MAP = new ConcurrentHashMap();
    private String drive;
    private String url;
    private String user;
    private String pwd;
    private int maxPoolSize = 200;
    private int minimumldle = 10;
    @JSONField(serialize=false)
    private transient javax.sql.DataSource dataSource;
    private HashMap<String, String> map = null;

    public static final void setDATA_SOURCE_CLASS_NAME(String data_source_class_name) {
        DATA_SOURCE_CLASS_NAME = data_source_class_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final DBConf getDefaultDBConf() {
        if (instance != null) return instance;
        Class<DBConf> clazz = DBConf.class;
        synchronized (DBConf.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            instance = new DBConf();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static DBConf getDBConf(String url) {
        DBConf dbConf = DB_CONF_MAP.get(url);
        return dbConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public javax.sql.DataSource getDataSource() {
        if (this.dataSource != null) return this.dataSource;
        Class<DBConf> clazz = DBConf.class;
        synchronized (DBConf.class) {
            if (this.dataSource != null) return this.dataSource;
            try {
                Class<?> forName = Class.forName(DATA_SOURCE_CLASS_NAME);
                DataSource newInstance = (DataSource)forName.newInstance();
                this.dataSource = newInstance.getDataSource(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.dataSource;
        }
    }

    public DBConf() {
        this(new File(DEFAULT_CONFIG_URL));
        this.readSpringBoot();
        try {
            this.readConf(DBConf.class.getResourceAsStream(DEFAULT_CONFIG_URL));
        }
        catch (IOException e) {
            try {
                this.readConf(DBConf.class.getResourceAsStream("/default.sql"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void readSpringBoot() {
        try {
            Object object2 = System.getProperties().get("Application");
            if (object2 == null || object2.getClass().getName().equals("")) {
                return;
            }
            Class<?> forName = Class.forName("org.springframework.context.ApplicationContext");
            if (!forName.isInstance(object2)) {
                return;
            }
            Method method = object2.getClass().getMethod("getBean", Class.class);
            Object invoke = method.invoke(object2, Class.forName("org.springframework.core.env.Environment"));
            if (invoke == null) {
                return;
            }
            method = invoke.getClass().getMethod("getProperty", String.class, Class.class);
            String url = (String)method.invoke(invoke, "spring.datasource.url", String.class);
            String pwd = (String)method.invoke(invoke, "spring.datasource.password", String.class);
            String drive = (String)method.invoke(invoke, "spring.datasource.driver-class-name", String.class);
            String user = (String)method.invoke(invoke, "spring.datasource.username", String.class);
            if (pwd != null) {
                this.pwd = pwd;
            }
            if (drive != null) {
                this.drive = drive;
            }
            if (user != null) {
                this.user = user;
            }
            if (url != null) {
                this.url = url;
                DB_CONF_MAP.put(this.url, this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DBConf(File file) {
        this.readConf(file);
    }

    public DBConf(InputStream stream) throws IOException {
        this.readConf(stream);
    }

    public DBConf(String drive, String url, String user, String pwd) {
        this.readConf(drive, url, user, pwd);
    }

    @Deprecated
    public DBConf(String connection_url) {
        this.readConf(connection_url);
    }

    public void readConf(File file) {
        InputStream inputStream;
        if (file == null) {
            return;
        }
        try {
            inputStream = new FileInputStream(file);
            this.readConf(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file.getPath());
            this.readConf(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSQL(String sql_name) {
        String sql = null;
        if (this.map == null || (sql = this.map.get(sql_name)) == null || sql.equals("")) {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u7684sql\u8bed\u53e5");
        }
        return sql;
    }

    public void readConf(InputStream inputStream) throws IOException {
        String s;
        if (inputStream == null) {
            throw new IOException("io\u6d41\u9519\u8bef");
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
        String key = "";
        String value = "";
        while ((s = br.readLine()) != null) {
            if (s.trim().isEmpty()) continue;
            if (s.charAt(0) == '#' || s.trim().isEmpty()) {
                if (value.isEmpty() || key.trim().isEmpty()) continue;
                this.map.put(key.trim(), value.trim());
                continue;
            }
            int i = s.indexOf(":");
            if (i == -1) {
                if (key.equals("")) {
                    throw new IOException("\u6587\u4ef6\u89e3\u6790\u9519\u8bef");
                }
                value = value + " " + s + " ";
                continue;
            }
            if (!value.equals("")) {
                this.map.put(key.trim(), value.trim());
                key = "";
                value = "";
            }
            key = key + s.substring(0, i);
            value = value + " " + s.substring(i + 1, s.length()) + " ";
        }
        if (!value.equals("")) {
            this.map.put(key.trim(), value.trim());
        }
        this.initBaseConf();
    }

    public void write(String string, String sql) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(string, sql);
    }

    private void initBaseConf() {
        String url = this.map.get("url");
        String pwd = this.map.get("password");
        String drive = this.map.get("driver-class-name");
        String user = this.map.get("username");
        if (url != null) {
            this.url = url;
            DB_CONF_MAP.put(url, this);
        }
        if (pwd != null) {
            this.pwd = pwd;
        }
        if (drive != null) {
            this.drive = drive;
        }
        if (user != null) {
            this.user = user;
        }
    }

    public void readConf(String drive, String url, String user, String pwd) {
        try {
            this.readConf(DBConf.class.getResourceAsStream(DEFAULT_CONFIG_URL));
        }
        catch (IOException e) {
            try {
                this.readConf(DBConf.class.getResourceAsStream("/default.sql"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.drive = drive;
        this.url = url;
        this.user = user;
        this.pwd = pwd;
        DB_CONF_MAP.put(url, this);
    }

    @Deprecated
    public void readConf(String connection_url) {
    }

    @Deprecated
    public DBConf copy() {
        return DBConf.newBean(this);
    }

    public String getDrive() {
        return this.drive;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPwd() {
        return this.pwd;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMinimumldle() {
        return this.minimumldle;
    }

    public HashMap<String, String> getMap() {
        return this.map;
    }

    public DBConf setDrive(String drive) {
        this.drive = drive;
        return this;
    }

    public DBConf setUrl(String url) {
        this.url = url;
        return this;
    }

    public DBConf setUser(String user) {
        this.user = user;
        return this;
    }

    public DBConf setPwd(String pwd) {
        this.pwd = pwd;
        return this;
    }

    public DBConf setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public DBConf setMinimumldle(int minimumldle) {
        this.minimumldle = minimumldle;
        return this;
    }

    public DBConf setDataSource(javax.sql.DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public DBConf setMap(HashMap<String, String> map) {
        this.map = map;
        return this;
    }
}

