/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.sql;

import com.mugui.sql.DBConf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

class SqlUtils {
    private DataSource dataSource;
    private Connection connection = null;
    private PreparedStatement preparedStatement = null;
    private boolean lock_of_update = false;
    private boolean autoCommit = true;

    public SqlUtils() {
        this.dataSource = DBConf.getDefaultDBConf().getDataSource();
    }

    public SqlUtils(DBConf dbConf) {
        this.dataSource = dbConf.getDataSource();
    }

    private Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.dataSource.getConnection();
            if (!this.autoCommit) {
                this.connection.setAutoCommit(this.autoCommit);
            }
            return this.connection;
        }
        return this.connection;
    }

    public void setLockOfSelect(boolean lock_of_update) {
        this.lock_of_update = lock_of_update;
    }

    public ResultSet select(String sql, Object[] parvar) throws SQLException {
        if (sql == null) {
            throw new NullPointerException("SQL is null");
        }
        if (this.lock_of_update) {
            sql = sql + " for update";
        }
        this.handerParameter(sql, parvar);
        return this.preparedStatement.executeQuery();
    }

    private void handerParameter(String sql, Object[] parvar) throws SQLException {
        this.preparedStatement = this.getConnection().prepareStatement(sql);
        if (parvar != null && parvar.length > 0) {
            for (int i = 0; i < parvar.length; ++i) {
                if (parvar[i] == null) continue;
                this.preparedStatement.setObject(i + 1, parvar[i]);
            }
        }
    }

    public int update(String sql, Object[] parvar) throws SQLException {
        if (sql == null) {
            throw new NullPointerException("SQL is null");
        }
        int k = 0;
        this.handerParameter(sql, parvar);
        k = this.preparedStatement.executeUpdate();
        return k;
    }

    public void Close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.connection = null;
        }
    }

    @Deprecated
    public boolean isClose() throws SQLException {
        return this.connection.isClosed();
    }

    public void batch(String[] sqls) throws SQLException {
        if (sqls == null) {
            throw new NullPointerException("SQL is null");
        }
        this.connection.setAutoCommit(false);
        Statement statement = this.connection.createStatement();
        for (String sql : sqls) {
            statement.addBatch(sql);
        }
        statement.executeBatch();
        this.connection.commit();
        this.connection.setAutoCommit(true);
        statement.close();
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.connection.getAutoCommit()) {
            this.connection.rollback();
        }
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.connection.getAutoCommit()) {
            this.connection.commit();
        }
    }

    public void setAutoCommit(boolean bool) throws SQLException {
        this.lock_of_update = false;
        this.autoCommit = bool;
        if (this.connection != null) {
            this.connection.setAutoCommit(this.autoCommit);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void closePreparedStatement() {
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.preparedStatement = null;
        }
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }
}

