/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.sql.datasource;

import com.mugui.sql.DBConf;
import com.mugui.sql.datasource.DataSource;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;

public class HikariCPDataSource
implements DataSource {
    public final synchronized HikariDataSource getDataSource() {
        return HikariCPDataSource.init(DBConf.getDefaultDBConf());
    }

    public final synchronized HikariDataSource getDataSource(DBConf dbConf) {
        return HikariCPDataSource.init(dbConf);
    }

    public final synchronized HikariDataSource getDataSource(String url) {
        return HikariCPDataSource.init(DBConf.getDBConf(url));
    }

    static HikariDataSource init(DBConf dbConf) {
        try {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl(dbConf.getUrl());
            config.setUsername(dbConf.getUser());
            config.setPassword(dbConf.getPwd());
            config.setDriverClassName(dbConf.getDrive());
            config.setConnectionTimeout(30000L);
            config.setIdleTimeout(30000L);
            config.setMaxLifetime(1800000L);
            config.setMinimumIdle(50);
            config.setMaximumPoolSize(400);
            config.setConnectionInitSql("select 1");
            config.setValidationTimeout(5000L);
            config.setAutoCommit(true);
            config.setMaximumPoolSize(dbConf.getMaxPoolSize());
            config.setMinimumIdle(dbConf.getMinimumldle());
            config.addDataSourceProperty("characterEncoding", (Object)"utf-8");
            config.addDataSourceProperty("autoReconnect", (Object)"true");
            config.addDataSourceProperty("failOverReadOnly", (Object)"false");
            HikariDataSource hikariDataSource = new HikariDataSource(config);
            dbConf.setDataSource((javax.sql.DataSource)hikariDataSource);
            return hikariDataSource;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u65e0\u6cd5\u52a0\u8f7d\uff1a" + (Object)((Object)dbConf));
        }
    }
}

