/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.sql.loader;

import com.mugui.bean.JsonBean;
import com.mugui.sql.JsonBeanAttr;
import com.mugui.sql.loader.Parameter;
import com.mugui.sql.loader.Where;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class Update
extends Parameter {
    private static final long serialVersionUID = -7687091899204637392L;
    public static final int TYPE_BASE = 0;
    public static final int TYPE_INCREMENT = 1;
    public static final int TYPE_RECIPROCITY = 2;

    public Update(JsonBean bean, int type) {
        this.sql = new StringBuilder();
        switch (type) {
            case 0: {
                this.queryBase(bean);
                break;
            }
            case 1: {
                this.queryIncrement(bean);
                break;
            }
            case 2: {
                this.queryReciprocity(bean);
                break;
            }
        }
    }

    public Update(JsonBean bean, int type, Where where) {
        this.sql = new StringBuilder();
        switch (type) {
            case 0: {
                this.queryBase(bean, where);
                break;
            }
            case 1: {
                this.queryIncrement(bean, where);
                break;
            }
            case 2: {
                this.queryReciprocity(bean, where);
                break;
            }
        }
    }

    private Update queryReciprocity(JsonBean bean) {
        JsonBeanAttr attr = JsonBeanAttr.getAttr(bean);
        Where eq = Where.q();
        eq.sql.append(" `").append(attr.getKEY()).append("`=? ");
        eq.addParameter(bean.get(attr.getKEY()));
        return this.queryReciprocity(bean, eq);
    }

    private Update queryReciprocity(JsonBean bean, Where where) {
        Object value;
        JsonBeanAttr attr = JsonBeanAttr.getAttr(bean);
        this.sql.append("UPDATE `").append(attr.getTABLE()).append("` SET ");
        int i = 1;
        List<Field> fields = attr.getFields();
        try {
            value = fields.get(i).get(bean);
            if (value != null) {
                this.sql.append("`").append(fields.get(i).getName()).append("`=?");
                this.addParameter(value);
            } else {
                this.sql.append("`").append(fields.get(i).getName()).append("`=NULL");
            }
            ++i;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (i < fields.size()) {
            try {
                value = fields.get(i).get(bean);
                if (value != null) {
                    this.sql.append(",`").append(fields.get(i).getName()).append("`=?");
                    this.addParameter(value);
                } else {
                    this.sql.append("`").append(fields.get(i).getName()).append("`=NULL");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.sql.append(" WHERE ").append((CharSequence)where.sql);
        this.addParameter(where.parameter);
        return this;
    }

    private Update queryBase(JsonBean bean) {
        JsonBeanAttr attr = JsonBeanAttr.getAttr(bean);
        Where eq = Where.q();
        eq.sql.append(" `").append(attr.getKEY()).append("`=? ");
        eq.addParameter(bean.get(attr.getKEY()));
        return this.queryBase(bean, eq);
    }

    private Update queryBase(JsonBean bean, Where where) {
        Object value;
        int i;
        JsonBeanAttr attr = JsonBeanAttr.getAttr(bean);
        this.sql.append("UPDATE `").append(attr.getTABLE()).append("` SET ");
        List<Field> fields = attr.getFields();
        for (i = 1; i < fields.size(); ++i) {
            try {
                value = fields.get(i).get(bean);
                if (value == null) continue;
                this.sql.append("`").append(fields.get(i).getName()).append("`=?");
                ++i;
                this.addParameter(value);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (i < fields.size()) {
            try {
                value = fields.get(i).get(bean);
                if (value != null) {
                    this.sql.append(",`").append(fields.get(i).getName()).append("`=?");
                    this.addParameter(value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.sql.append(" WHERE ").append((CharSequence)where.sql);
        this.addParameter(where.parameter);
        return this;
    }

    private Update queryIncrement(JsonBean bean) {
        JsonBeanAttr attr = JsonBeanAttr.getAttr(bean);
        Where eq = Where.q();
        eq.sql.append(" `").append(attr.getKEY()).append("`=? ");
        eq.addParameter(bean.get(attr.getKEY()));
        return this.queryIncrement(bean, eq);
    }

    private Update queryIncrement(JsonBean bean, Where where) {
        String sql;
        Object value;
        int i;
        JsonBeanAttr attr = JsonBeanAttr.getAttr(bean);
        this.sql.append("UPDATE `").append(attr.getTABLE()).append("` SET ");
        Field[] fields = attr.getFields().toArray(new Field[0]);
        ArrayList<Object> list = new ArrayList<Object>();
        for (i = 1; i < fields.length; ++i) {
            try {
                value = fields[i].get(bean);
                if (value == null || (sql = this.handleFieldByIncrement(fields[i], bean, list)) == null) continue;
                this.sql.append(sql);
                ++i;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (i < fields.length) {
            try {
                value = fields[i].get(bean);
                if (value != null && (sql = this.handleFieldByIncrement(fields[i], bean, list)) != null) {
                    this.sql.append(",").append(sql);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.sql.append(" WHERE ").append((CharSequence)where.sql);
        this.addParameter(where.parameter);
        return this;
    }

    private String handleFieldByIncrement(Field fields, JsonBean bean, ArrayList<Object> list) throws IllegalArgumentException, IllegalAccessException {
        if (fields.getType() == Integer.TYPE || fields.getType() == Integer.class) {
            if ((Integer)fields.get(bean) == 0) {
                return null;
            }
            return "`" + fields.getName() + "`='" + fields.get(bean).toString() + "'+`" + fields.getName() + "`";
        }
        if (fields.getType() == BigDecimal.class) {
            if (((BigDecimal)fields.get(bean)).compareTo(BigDecimal.ZERO) == 0) {
                return null;
            }
            return "`" + fields.getName() + "`='" + ((BigDecimal)fields.get(bean)).setScale(8, 5) + "'+`" + fields.getName() + "`";
        }
        Object object = fields.get(bean);
        list.add(object);
        this.addParameter(object);
        return "`" + fields.getName() + "`=?";
    }

    public static Update q(JsonBean bean) {
        return new Update(bean, 0);
    }

    public static Update increment(JsonBean bean) {
        return new Update(bean, 1);
    }

    public static Update Reciprocity(JsonBean bean) {
        return new Update(bean, 2);
    }

    public static Update Reciprocity(JsonBean bean, Where where) {
        return new Update(bean, 2, where);
    }

    public static Update q(JsonBean bean, Where where) {
        return new Update(bean, 0, where);
    }

    public static Update increment(JsonBean bean, Where where) {
        return new Update(bean, 1, where);
    }
}

