/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.sql.util;

import com.alibaba.fastjson.JSONObject;
import com.mugui.sql.util.ArrayUtils;
import com.mugui.sql.util.CollectionUtils;
import com.mugui.sql.util.StringUtils;
import java.util.Collection;
import java.util.Map;

public final class Assert {
    public static void isTrue(boolean expression, String message, Object ... params) {
        if (!expression) {
            throw new RuntimeException("expression:" + expression + " message:" + message + " " + JSONObject.toJSONString((Object)params));
        }
    }

    public static void isFalse(boolean expression, String message, Object ... params) {
        Assert.isTrue(!expression, message, params);
    }

    public static void isNull(Object object, String message, Object ... params) {
        Assert.isTrue(object == null, message, params);
    }

    public static void notNull(Object object, String message, Object ... params) {
        Assert.isTrue(object != null, message, params);
    }

    public static void notEmpty(String value, String message, Object ... params) {
        Assert.isTrue(StringUtils.isNotBlank(value), message, params);
    }

    public static void notEmpty(Collection<?> collection, String message, Object ... params) {
        Assert.isTrue(CollectionUtils.isNotEmpty(collection), message, params);
    }

    public static void notEmpty(Map<?, ?> map, String message, Object ... params) {
        Assert.isTrue(CollectionUtils.isNotEmpty(map), message, params);
    }

    public static void notEmpty(Object[] array, String message, Object ... params) {
        Assert.isTrue(ArrayUtils.isNotEmpty(array), message, params);
    }
}

