/*
 * Decompiled with CFR 0.152.
 */
package cn.net.pap.common.bitmap;

import cn.net.pap.common.bitmap.exception.Roaring64NavigableMapException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class Roaring64NavigableMapUtil {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String serialize(Roaring64NavigableMap bitmap) {
        if (bitmap == null) {
            throw new Roaring64NavigableMapException("Bitmap cannot be null");
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                bitmap.serialize((DataOutput)dos);
                string = Base64.getEncoder().encodeToString(bos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new Roaring64NavigableMapException("Error occurred during serialization: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Roaring64NavigableMap deserialize(String encrypt) {
        if (encrypt == null) {
            throw new Roaring64NavigableMapException("Serialized string cannot be null");
        }
        Roaring64NavigableMap bitmap = new Roaring64NavigableMap();
        try (ByteArrayInputStream bis = new ByteArrayInputStream(Base64.getDecoder().decode(encrypt));){
            Roaring64NavigableMap roaring64NavigableMap;
            try (DataInputStream dis = new DataInputStream(bis);){
                bitmap.deserialize((DataInput)dis);
                roaring64NavigableMap = bitmap;
            }
            return roaring64NavigableMap;
        }
        catch (IOException e) {
            throw new Roaring64NavigableMapException("Error occurred during deserialization: " + e.getMessage());
        }
    }
}

