/*
 * Decompiled with CFR 0.152.
 */
package cn.net.pap.common.pdf.sign;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public class SignatureInterfaceImpl
implements SignatureInterface {
    private final PrivateKey privateKey;
    private final Certificate[] certificateChain;

    public SignatureInterfaceImpl(PrivateKey privateKey, Certificate[] certificateChain) {
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
    }

    public byte[] sign(InputStream content) throws IOException {
        try {
            byte[] contentBytes = IOUtils.toByteArray((InputStream)content);
            return SignatureInterfaceImpl.signContent(contentBytes, this.privateKey, this.certificateChain);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static byte[] signContent(byte[] content, PrivateKey privateKey, Certificate[] certificateChain) throws Exception {
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSA").build(privateKey);
        generator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(signer, (X509Certificate)certificateChain[0]));
        JcaCertStore certStore = new JcaCertStore(Arrays.asList(certificateChain));
        generator.addCertificates((Store)certStore);
        CMSProcessableByteArray contentBytes = new CMSProcessableByteArray(content);
        CMSSignedData signedData = generator.generate((CMSTypedData)contentBytes, false);
        return signedData.getEncoded();
    }
}

