/*
 * Decompiled with CFR 0.152.
 */
package cn.net.sichen.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static final int HTTP_STATUS_OK = 200;

    public static String sendPostMethod(String url, Map<String, Object> params, String encoding) throws Exception {
        String result = "";
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(url);
        if (null != params && !params.isEmpty()) {
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue().toString();
                BasicNameValuePair pair = new BasicNameValuePair(name, value);
                parameters.add(pair);
            }
            try {
                UrlEncodedFormEntity encodedFormEntity = new UrlEncodedFormEntity(parameters, encoding);
                post.setEntity((HttpEntity)encodedFormEntity);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        try {
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new Exception("Invalide response from API" + response.toString());
            }
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)encoding);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String sendGetMethod(String url, String params, String encoding) throws Exception {
        String result = "";
        url = url + (-1 == url.indexOf("?") ? "?" : "&") + params;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet get = new HttpGet(url);
        get.setHeader("charset", encoding);
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new Exception("Invalide response from Api!" + response.toString());
            }
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)encoding);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostMethod(String url, String params, String encoding) {
        String result = "";
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            out = new PrintWriter(conn.getOutputStream());
            out.print(params);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), encoding));
            String line = "";
            while (null != (line = in.readLine())) {
                result = result + line;
            }
        }
        catch (IOException e) {
            System.out.println("Send post Exection!");
            e.printStackTrace();
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
                if (null != in) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGetRequest(String url, String params, String encoding) {
        String result = "";
        BufferedReader in = null;
        url = url + (-1 == url.indexOf("?") ? "?" : "&") + params;
        try {
            String line;
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (comptibal; MSIE 6.0; Windows NT 5.1;SV1 )");
            conn.setUseCaches(false);
            conn.connect();
            Map<String, List<String>> headers = conn.getHeaderFields();
            for (String key : headers.keySet()) {
                List<String> list = headers.get(key);
            }
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while (null != (line = in.readLine())) {
                result = result + line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static void setProxy(String ip, String port) {
        System.getProperties().setProperty("http.proxyHost", ip);
        System.getProperties().setProperty("http.proxyPort", port);
    }

    public static InputStream getInputStreamByGet(String url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setReadTimeout(5000);
            conn.setConnectTimeout(5000);
            conn.setRequestMethod("GET");
            if (conn.getResponseCode() == 200) {
                InputStream inputStream = conn.getInputStream();
                return inputStream;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveData(InputStream is, File file) {
        try (BufferedInputStream bis = new BufferedInputStream(is);
             BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
                bos.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

