package cn.net.vidyo.framework.data.jdbc.dao;


import cn.net.vidyo.framework.data.jdbc.utils.EntityUtils;
import org.springframework.data.jdbc.core.JdbcAggregateTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import java.util.List;
import java.util.Map;

public class JdbcDao {
    JdbcTemplate jdbcTemplate;
    JdbcAggregateTemplate jdbcAggregateTemplate;

    public JdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcAggregateTemplate getJdbcAggregateTemplate() {
        return jdbcAggregateTemplate;
    }

    public void setJdbcAggregateTemplate(JdbcAggregateTemplate jdbcAggregateTemplate) {
        this.jdbcAggregateTemplate = jdbcAggregateTemplate;
    }

    public int insert(String sql, Object... params) {
        return jdbcTemplate.update(sql, params);
    }

    public int update(String sql, Object... params) {
        return jdbcTemplate.update(sql, params);
    }

    public int delete(String sql, Object... params) {
        return jdbcTemplate.update(sql, params);
    }

    public <T> T select(String sql, RowMapper<T> rowMapper, Object... params) {
        return jdbcTemplate.queryForObject(sql, rowMapper, params);
    }

    public List<Map<String, Object>> selectFieldsByWhere(String tableName,List<String> fields, String whereClause, Object... params) {
        return selectFieldsByWhere(tableName,String.join(", ", fields),whereClause,params);
    }
    public List<Map<String, Object>> selectFieldsByWhere(String tableName,String select, String whereClause, Object... params) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT ").append(select).append(" FROM ").append(tableName);
        if(whereClause!=null && !whereClause.trim().isEmpty()) {
            sqlBuilder.append(" WHERE ").append(whereClause);
        }
        return jdbcTemplate.queryForList(sqlBuilder.toString(), params);
    }

    public Map<String, Object> getFieldsByWhere(String tableName,List<String> fields, String whereClause, Object... params) {
        List<Map<String, Object>> list = selectFieldsByWhere(tableName, fields, whereClause, params);
        if(!list.isEmpty()) {
            return list.getFirst();
        }
        return null;
    }
    public Map<String, Object> getFieldsByWhere(String tableName,String select, String whereClause, Object... params) {
        List<Map<String, Object>> list = selectFieldsByWhere(tableName, select, whereClause, params);
        if(!list.isEmpty()) {
            return list.getFirst();
        }
        return null;
    }
//    public  <T> T getResultByWhere(String tableName,Class<T> rClass,String select, String whereClause, Object... params) {
//        StringBuilder sqlBuilder = new StringBuilder("SELECT ").append(select).append(" FROM ").append(tableName);
//        if(whereClause!=null && !whereClause.trim().isEmpty()) {
//            sqlBuilder.append(" WHERE ").append(whereClause);
//        }
//        return jdbcTemplate.queryForObject(sqlBuilder.toString(),rClass, params);
//    }
//    public  <T> T getResultByWhere(String tableName,Class<T> rClass,String select, String whereClause, Object... params) {
//        StringBuilder sqlBuilder = new StringBuilder("SELECT ").append(select).append(" FROM ").append(tableName);
//        if(whereClause!=null && !whereClause.trim().isEmpty()) {
//            sqlBuilder.append(" WHERE ").append(whereClause);
//        }
//        return jdbcTemplate.queryForObject(sqlBuilder.toString(),rClass, params);
//    }
//    public  <T> T getResultByWhere(String tableName,Class<T> rClass,String select, String whereClause, Object... params) {
//        StringBuilder sqlBuilder = new StringBuilder("SELECT ").append(select).append(" FROM ").append(tableName);
//        if(whereClause!=null && !whereClause.trim().isEmpty()) {
//            sqlBuilder.append(" WHERE ").append(whereClause);
//        }
//        return jdbcTemplate.queryForObject(sqlBuilder.toString(),rClass, params);
//    }

    public void createTable(String tableName, Map<String, String> columnDefinitions) {
        StringBuilder sqlBuilder = new StringBuilder("CREATE TABLE ");
        sqlBuilder.append(tableName).append(" (");
        for (Map.Entry<String, String> entry : columnDefinitions.entrySet()) {
            sqlBuilder.append(entry.getKey()).append(" ").append(entry.getValue()).append(", ");
        }
        sqlBuilder.setLength(sqlBuilder.length() - 2);
        sqlBuilder.append(")");
        jdbcTemplate.execute(sqlBuilder.toString());
    }

    public void updateTableSchema(String tableName, Map<String, String> columnDefinitions) {
        StringBuilder sqlBuilder = new StringBuilder("ALTER TABLE ");
        sqlBuilder.append(tableName).append(" ");
        for (Map.Entry<String, String> entry : columnDefinitions.entrySet()) {
            sqlBuilder.append("ADD COLUMN ").append(entry.getKey()).append(" ").append(entry.getValue()).append(", ");
        }
        sqlBuilder.setLength(sqlBuilder.length() - 2);
        jdbcTemplate.execute(sqlBuilder.toString());
    }

    public void truncateTable(String tableName) {
        String sql = "TRUNCATE TABLE " + tableName;
        jdbcTemplate.execute(sql);
    }
}
