package cn.net.vidyo.framework.data.jdbc.utils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class EntityUtils {
    public static String getTableName(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    public static <T> Map<String, Object> getFieldMap(T entity) {
        Map<String, Object> fieldMap = new HashMap<>();
        Field[] fields = entity.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                fieldMap.put(field.getName(), field.get(entity));
            } catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access field: " + field.getName(), e);
            }
        }
        return fieldMap;
    }

    public static <T> Object getIdValue(T entity) {
        try {
            Field idField = entity.getClass().getDeclaredField("id");
            idField.setAccessible(true);
            return idField.get(entity);
        } catch (Exception e) {
            throw new RuntimeException("Failed to get ID value", e);
        }
    }
}