/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.data.jpa.dao;

import cn.net.vidyo.framework.common.util.ObjectUtil;
import cn.net.vidyo.framework.data.jpa.dao.CommonJpaRepository;
import cn.net.vidyo.framework.data.jpa.dao.ConditionCompose;
import cn.net.vidyo.framework.data.jpa.dao.EntityEventCallback;
import cn.net.vidyo.framework.data.jpa.dao.Event;
import cn.net.vidyo.framework.data.jpa.dao.sql.QueryWhere;
import cn.net.vidyo.framework.data.jpa.dao.support.ColumnToBean;
import cn.net.vidyo.framework.data.jpa.dao.support.DefaultEntityEventCallback;
import cn.net.vidyo.framework.data.jpa.domain.Condition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Table;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.query.spi.NativeQueryImplementor;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;

public class CommonJpaRepositoryImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements EntityEventCallback,
CommonJpaRepository<T, ID> {
    static int BATCH_SIZE = 10000;
    private final EntityManager entityManager;
    JpaEntityInformation<T, ?> entityInformation;
    Class<T> entityClass;
    EntityEventCallback defaultEntityEventCallback;

    public CommonJpaRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
        this.entityInformation = entityInformation;
        this.entityClass = entityInformation.getJavaType();
        this.defaultEntityEventCallback = new DefaultEntityEventCallback();
    }

    @Override
    public int updateStatusById(ID id, Object value) {
        return this.updateColumnById(id, "status", value);
    }

    @Override
    public int updateHiddenById(ID id, Object value) {
        return this.updateColumnById(id, "hidden", value);
    }

    @Override
    public int updateColumnById(ID id, String fieldName, Object value) {
        return this.updateColumn(fieldName, value, new QueryWhere().addIdWhere(id));
    }

    @Override
    public int increaseColumnValueById(ID id, String fieldName, int delta) {
        return this.increaseColumn(fieldName, delta, "id=?", id);
    }

    @Override
    public int deleteByIds(Iterable<ID> ids) {
        return this.deleteByWhere(new QueryWhere().addInWhere("id", ids));
    }

    @Override
    public int deleteByIds(ID ... ids) {
        if (ids.length == 1) {
            return this.deleteByWhere(new QueryWhere().addWhere("id", ids[0]));
        }
        return this.deleteByWhere(new QueryWhere().addInWhere("id", ids));
    }

    public void deleteAll() {
        this.deleteByWhere(new QueryWhere());
    }

    public void deleteAll(Iterable<? extends T> entities) {
        ArrayList<ID> ids = new ArrayList<ID>();
        for (T entity : entities) {
            ID id = this.getIdByEntity(entity);
            ids.add(id);
        }
        this.deleteByWhere(new QueryWhere().addInWhere("id", ids));
    }

    @Override
    public T getById(ID id) {
        Optional optional = this.findById(id);
        if (!optional.isPresent()) {
            return null;
        }
        Object t = optional.get();
        this.invokeEvent(t, Event.PostLoad);
        return t;
    }

    @Override
    public ID getIdByEntity(T t) {
        return (ID)((Serializable)ObjectUtil.getFieldValueByFieldName(t, (String)"id"));
    }

    @Override
    public T getByEntityId(T t) {
        ID id = this.getIdByEntity(t);
        return this.getById(id);
    }

    @Override
    public Object getColumnById(ID id, String fieldName) {
        return this.getColumn(fieldName, new QueryWhere().addIdWhere(id));
    }

    @Override
    public String getStringColumnById(ID id, String fieldName) {
        Object value = this.getColumnById(id, fieldName);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public String getNameById(ID id) {
        return this.getStringColumnById(id, "name");
    }

    @Override
    public String getIdKeyById(ID id) {
        return this.getStringColumnById(id, "idkey");
    }

    @Override
    public String getCodeById(ID id) {
        return this.getStringColumnById(id, "code");
    }

    @Override
    public List<T> findByIds(List<ID> ids) {
        return this.findAllById(ids);
    }

    @Override
    public List<T> findByIds(ID[] ids) {
        List<ID> list = Arrays.asList(ids);
        return this.findByIds(list);
    }

    public Page<T> pageAll(int pageNumber, int pageSize) {
        return this.pageAll((Pageable)PageRequest.of((int)pageNumber, (int)pageSize));
    }

    public Page<T> pageAll() {
        return this.pageAll(1, 100000);
    }

    public Page<T> pageAll(Pageable pageable) {
        return this.pageQuery(pageable, new QueryWhere());
    }

    public List<T> findAll() {
        return this.query(new QueryWhere());
    }

    @Override
    public int increaseColumn(String columName, int delta, String where, Object ... params) {
        StringBuilder sql = new StringBuilder();
        sql.append(columName);
        sql.append("=");
        sql.append(columName);
        sql.append("+ ?");
        String sql1 = this.buildUpdateSql(sql.toString(), where);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(delta);
        for (Object param : params) {
            list.add(param);
        }
        return this.executeUpdate(sql1, list.toArray());
    }

    @Override
    public int increaseColumn(String columName, int delta, QueryWhere where) {
        return this.increaseColumn(columName, delta, where.getWhere(), where.getParams().toArray());
    }

    @Override
    public int updateColumn(String columName, Object value, String where, Object ... params) {
        return this.updateColumn(columName, value, new QueryWhere(where, params));
    }

    @Override
    public int updateColumn(String columName, Object value, QueryWhere where) {
        HashMap<String, Object> columnNameValues = new HashMap<String, Object>();
        columnNameValues.put(columName, value);
        return this.updateColumns(columnNameValues, where);
    }

    @Override
    public int updateColumns(Map columnNameValues, String where, Object ... params) {
        return this.updateColumns(columnNameValues, new QueryWhere(where, params));
    }

    @Override
    public int updateColumns(Map columnNameValues, QueryWhere where) {
        String sql = this.buildUpdateSql(columnNameValues, where.getWhere());
        return this.executeUpdate(sql, where.getParams().toArray());
    }

    @Override
    public <S extends T> Iterable<S> batchUpdate(Iterable<S> var1) {
        Iterator<S> iterator = var1.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            S entity = iterator.next();
            this.invokeEvent(entity, Event.PreUpdate);
            this.entityManager.merge(entity);
            this.invokeEvent(entity, Event.PostUpdate);
            if (++index % BATCH_SIZE != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (index % BATCH_SIZE != 0) {
            this.entityManager.flush();
            this.entityManager.clear();
        }
        return var1;
    }

    @Override
    public <S extends T> S save(S entity) {
        if (this.entityInformation.isNew(entity)) {
            this.invokeEvent(entity, Event.PrePersist);
            this.entityManager.persist(entity);
            this.invokeEvent(entity, Event.PostPersist);
            return entity;
        }
        this.invokeEvent(entity, Event.PreUpdate);
        Object merge = this.entityManager.merge(entity);
        this.invokeEvent(merge, Event.PostUpdate);
        return (S)merge;
    }

    @Override
    public <S extends T> S saveAndFlush(S entity) {
        S result = this.save(entity);
        this.flush();
        return result;
    }

    @Override
    public <S extends T> Iterable<S> batchSave(Iterable<S> var1) {
        Iterator<S> iterator = var1.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            S entity = iterator.next();
            this.invokeEvent(entity, Event.PrePersist);
            this.entityManager.persist(entity);
            this.invokeEvent(entity, Event.PostPersist);
            if (++index % BATCH_SIZE != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (index % BATCH_SIZE != 0) {
            this.entityManager.flush();
            this.entityManager.clear();
        }
        return var1;
    }

    public <S extends T> S insert(S entity) {
        this.invokeEvent(entity, Event.PrePersist);
        this.entityManager.persist(entity);
        this.invokeEvent(entity, Event.PostPersist);
        return entity;
    }

    public <S extends T> S update(S entity) {
        this.invokeEvent(entity, Event.PreUpdate);
        Object merge = this.entityManager.merge(entity);
        this.invokeEvent(merge, Event.PostUpdate);
        return (S)merge;
    }

    @Override
    public int deleteByWhere(String where, Object ... params) {
        String sql = this.buildDeleteSql(where);
        return this.executeUpdate(sql, params);
    }

    @Override
    public int deleteByWhere(QueryWhere where) {
        String sql = this.buildDeleteSql(where.getWhere());
        return this.executeUpdate(sql, where.getParams().toArray());
    }

    @Override
    public Object getColumn(String columnName, String where, Object ... params) {
        return this.getColumn(columnName, new QueryWhere(where, params));
    }

    @Override
    public Object getColumn(String columnName, QueryWhere where) {
        Map map;
        if (where.getSelect().length() == 1) {
            where.setSelect(columnName);
        }
        if ((map = this.getMap(where)) == null) {
            return null;
        }
        if (map.containsKey(columnName)) {
            return map.get(columnName);
        }
        return null;
    }

    @Override
    public T getModel(String where, Object ... params) {
        return this.getModel(new QueryWhere(where, params));
    }

    @Override
    public T getModel(QueryWhere where) {
        String sql = this.buildQuerySql(where);
        return this.getEntityBySql(sql, where.getParams().toArray());
    }

    @Override
    public <C> C getColumn(Class<C> cClass, String select, String where, Object ... params) {
        QueryWhere queryWhere = new QueryWhere(where, params);
        queryWhere.setSelect(select);
        return this.getColumn(cClass, queryWhere);
    }

    @Override
    public <C> C getColumn(Class<C> cClass, QueryWhere where) {
        String sql = this.buildQuerySql(where);
        return this.getObjectBySql(cClass, sql, where.getParams().toArray());
    }

    @Override
    public Map getMap(String where, Object ... params) {
        return this.getMap(new QueryWhere(where, params));
    }

    @Override
    public Map getMap(QueryWhere where) {
        String sql = this.buildQuerySql(where);
        return this.getMapBySql(sql, where.getParams().toArray());
    }

    @Override
    public List<T> query(String where, Object ... params) {
        return this.query(new QueryWhere(where, params));
    }

    @Override
    public List<T> query(QueryWhere where) {
        String sql = this.buildQuerySql(where);
        return this.executeEntityQueryBySql(this.entityClass, sql, where.getParams().toArray());
    }

    @Override
    public <C> List<C> queryColumn(Class<C> cClass, String select, String where, Object ... params) {
        QueryWhere selectWhere = new QueryWhere(where, params);
        selectWhere.setSelect(select);
        return this.queryColumn(cClass, selectWhere);
    }

    @Override
    public <C> List<C> queryColumn(Class<C> cClass, QueryWhere selectWhere) {
        String sql = this.buildQuerySql(selectWhere);
        return this.executeValueQueryBySql(cClass, sql, selectWhere.getParams().toArray());
    }

    @Override
    public List<Map> queryMap(String where, Object ... params) {
        return this.queryMap(new QueryWhere(where, params));
    }

    @Override
    public List<Map> queryMap(QueryWhere where) {
        String sql = this.buildQuerySql(where);
        return this.executeMapQueryBySql(sql, where.getParams().toArray());
    }

    @Override
    public Page<T> pageQuery(int pageNumber, int pageSize, String where, Object ... params) {
        return this.pageSelectQuery(pageNumber, pageSize, "*", where, params);
    }

    @Override
    public Page<T> pageQuery(int pageNumber, int pageSize, QueryWhere where) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        return this.pageSelectQuery((Pageable)pageable, where.getSelect(), where.getWhere(), where.getParams().toArray());
    }

    @Override
    public Page<T> pageSelectQuery(int pageNumber, int pageSize, String select, String where, Object ... params) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        return this.pageSelectQuery((Pageable)pageable, select, where, params);
    }

    @Override
    public Page<T> pageQuery(Pageable pageable, String where, Object ... params) {
        return this.pageSelectQuery(pageable, "*", where, params);
    }

    @Override
    public Page<T> pageQuery(Pageable pageable, QueryWhere where) {
        String sql = this.buildQuerySql(where.getSelect(), where.getWhere());
        return this.executePageEntityQueryBySql(pageable, this.entityClass, sql, where.getParams().toArray());
    }

    @Override
    public Page<T> pageSelectQuery(Pageable pageable, String select, String where, Object ... params) {
        String sql = this.buildQuerySql(select, where);
        return this.executePageEntityQueryBySql(pageable, this.entityClass, sql, params);
    }

    @Override
    public Page<Map> pageQueryMap(Pageable pageable, String where, Object ... params) {
        return this.pageQueryMap(pageable, new QueryWhere(where, params));
    }

    @Override
    public Page<Map> pageQueryMap(Pageable pageable, QueryWhere where) {
        String sql = this.buildQuerySql(where.getSelect(), where.getWhere());
        return this.pageQueryMap(pageable, sql, where.getParams().toArray());
    }

    @Override
    public Page<Map> pageSelectQueryMap(Pageable pageable, String select, String where, Object ... params) {
        String sql = this.buildQuerySql(select, where);
        return this.executePageMapQueryBySql(pageable, sql, params);
    }

    @Override
    public <C> Page<C> pageQueryColumn(Class<C> cClass, Pageable pageable, String select, String where, Object ... params) {
        QueryWhere where1 = new QueryWhere(where, params);
        where1.setSelect(select);
        return this.pageQueryColumn(cClass, pageable, where1);
    }

    @Override
    public <C> Page<C> pageQueryColumn(Class<C> cClass, Pageable pageable, QueryWhere where) {
        return this.pageSelectQueryColumn(cClass, pageable, where.getSelect(), where.getWhere(), where.getParams().toArray());
    }

    @Override
    public <C> Page<C> pageSelectQueryColumn(Class<C> cClass, Pageable pageable, String select, String where, Object ... params) {
        String sql = this.buildQuerySql(select, where);
        return this.executePageValuQueryBySql(pageable, cClass, sql, params);
    }

    @Override
    public Object getColumn(String columnName, Condition condition, ConditionCompose iConditionCompose) {
        QueryWhere queryWhere = iConditionCompose.buildWhere(condition);
        return this.getColumn(columnName, queryWhere);
    }

    @Override
    public <C> C getColumn(Class<C> cClass, String columnName, Condition condition, ConditionCompose iConditionCompose) {
        QueryWhere queryWhere = iConditionCompose.buildWhere(condition);
        queryWhere.setSelect(columnName);
        return this.getColumn(cClass, queryWhere);
    }

    @Override
    public T getModel(Condition condition, ConditionCompose iConditionCompose) {
        QueryWhere queryWhere = iConditionCompose.buildWhere(condition);
        return this.getModel(queryWhere);
    }

    @Override
    public Map getMap(Condition condition, ConditionCompose iConditionCompose) {
        QueryWhere queryWhere = iConditionCompose.buildWhere(condition);
        return this.getMap(queryWhere);
    }

    @Override
    public List<T> query(Condition condition, ConditionCompose iConditionCompose) {
        QueryWhere queryWhere = iConditionCompose.buildWhere(condition);
        return this.query(queryWhere);
    }

    @Override
    public <C> List<C> queryColumn(Class<C> cClass, Condition condition, ConditionCompose iConditionCompose) {
        QueryWhere selectWhere = iConditionCompose.buildWhere(condition);
        return this.queryColumn(cClass, selectWhere);
    }

    @Override
    public List<Map> queryMap(Condition condition, ConditionCompose iConditionCompose) {
        QueryWhere queryWhere = iConditionCompose.buildWhere(condition);
        return this.queryMap(queryWhere);
    }

    @Override
    public Page<T> pageQuery(Pageable pageable, Condition condition, ConditionCompose iConditionCompose) {
        QueryWhere queryWhere = iConditionCompose.buildWhere(condition);
        return this.pageQuery(pageable, queryWhere);
    }

    @Override
    public Page<T> pageQuery(int pageNumber, int pageSize, Condition condition, ConditionCompose iConditionCompose) {
        QueryWhere queryWhere = iConditionCompose.buildWhere(condition);
        return this.pageQuery((Pageable)PageRequest.of((int)pageNumber, (int)pageSize), queryWhere);
    }

    @Override
    public <C> Page<C> pageQueryColumn(Class<C> cClass, Pageable pageable, Condition condition, ConditionCompose iConditionCompose) {
        QueryWhere queryWhere = iConditionCompose.buildWhere(condition);
        return this.pageQueryColumn(cClass, pageable, queryWhere);
    }

    @Override
    public <C> Page<C> pageQueryColumn(Class<C> cClass, int pageNumber, int pageSize, Condition condition, ConditionCompose iConditionCompose) {
        QueryWhere queryWhere = iConditionCompose.buildWhere(condition);
        return this.pageQueryColumn(cClass, (Pageable)PageRequest.of((int)pageNumber, (int)pageSize), queryWhere);
    }

    @Override
    public Page<Map> pageQueryMap(Pageable pageable, Condition condition, ConditionCompose iConditionCompose) {
        QueryWhere queryWhere = iConditionCompose.buildWhere(condition);
        return this.pageQueryMap(pageable, queryWhere);
    }

    @Override
    public Page<Map> pageQueryMap(int pageNumber, int pageSize, Condition condition, ConditionCompose iConditionCompose) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        QueryWhere queryWhere = iConditionCompose.buildWhere(condition);
        return this.pageQueryMap((Pageable)pageable, queryWhere);
    }

    public T getEntityBySql(String sql, Object ... params) {
        List<T> list = this.executeEntityQueryBySql(this.entityClass, sql, params);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public <C> C getObjectBySql(Class<C> cClass, String sql, Object ... params) {
        return this.executeGetEntityBySql(cClass, sql, params);
    }

    public Map getMapBySql(String sql, Object ... params) {
        List<Map> maps = this.executeMapQueryBySql(sql, params);
        if (maps == null || maps.size() == 0) {
            return null;
        }
        return maps.get(0);
    }

    @Override
    public int truncateParmeryKey(Class entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("TRUNCATE TABLE ");
        sql.append(this.getTableName(entityClass));
        return this.executeUpdate(sql.toString(), new Object[0]);
    }

    @Override
    public int dropTable(Class entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("DROP TABLE ");
        sql.append(this.getTableName(entityClass));
        return this.executeUpdate(sql.toString(), new Object[0]);
    }

    @Override
    @Transactional(readOnly=false)
    public int executeUpdate(String sql, Object ... params) {
        Query query = this.entityManager.createNativeQuery(sql);
        if (params != null) {
            int index = 1;
            for (Object param : params) {
                query.setParameter(index, param);
                ++index;
            }
        }
        return query.executeUpdate();
    }

    @Transactional(readOnly=true)
    public <E> E executeGetEntityBySql(Class<E> resultClass, String sql, Object ... params) {
        List<E> list = this.executeEntityQueryBySql(resultClass, sql, params);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Transactional(readOnly=true)
    public <E> E executeGetValueBySql(Class<E> resultClass, String sql, Object ... params) {
        List<E> list = this.executeValueQueryBySql(resultClass, sql, params);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Transactional(readOnly=true)
    public Map executeGetMapBySql(String sql, Object ... params) {
        List<Map> list = this.executeMapQueryBySql(sql, params);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @Transactional(readOnly=true)
    public <E> List<E> executeValueQueryBySql(Class<E> resultClass, String sql, Object ... params) {
        Query query = this.entityManager.createNativeQuery(sql);
        if (params != null) {
            int index = 1;
            for (Object param : params) {
                query.setParameter(index, param);
                ++index;
            }
        }
        NativeQueryImplementor nativeQueryImplementor = (NativeQueryImplementor)query.unwrap(NativeQueryImpl.class);
        List resultList = nativeQueryImplementor.getResultList();
        return resultList;
    }

    @Transactional(readOnly=true)
    public <E> List<E> executeEntityQueryBySql(Class<E> resultClass, String sql, Object ... params) {
        Query query = this.entityManager.createNativeQuery(sql, resultClass);
        if (params != null) {
            int index = 1;
            for (Object param : params) {
                query.setParameter(index, param);
                ++index;
            }
        }
        return query.getResultList();
    }

    @Override
    @Transactional(readOnly=true)
    public List<Map> executeMapQueryBySql(String sql, Object ... params) {
        Query query = this.entityManager.createNativeQuery(sql);
        if (params != null) {
            int index = 1;
            for (Object param : params) {
                query.setParameter(index, param);
                ++index;
            }
        }
        List result = ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public <E> Page<E> executePageEntityQueryBySql(Pageable page, Class<E> resultClass, String sql, Object ... params) {
        long totalRecord;
        Query countQuery = this.entityManager.createNativeQuery("select count(*) from (" + sql + ") as p", resultClass);
        Query pageQuery = this.entityManager.createNativeQuery(sql);
        if (params != null) {
            int index = 1;
            for (Object param : params) {
                countQuery.setParameter(index, param);
                pageQuery.setParameter(index, param);
                ++index;
            }
        }
        ArrayList result = (totalRecord = ((Number)countQuery.getSingleResult()).longValue()) == 0L ? new ArrayList(0) : ((SQLQuery)pageQuery.setFirstResult((int)page.getOffset()).setMaxResults(page.getPageSize()).unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)new ColumnToBean(resultClass)).list();
        return new PageImpl(result, page, totalRecord);
    }

    @Transactional(readOnly=true)
    public <C> Page<C> executePageValuQueryBySql(Pageable page, Class<C> resultClass, String sql, Object ... params) {
        long totalRecord;
        Query countQuery = this.entityManager.createNativeQuery("select count(*) from (" + sql + ") as p");
        Query pageQuery = this.entityManager.createNativeQuery(sql);
        if (params != null) {
            int index = 1;
            for (Object param : params) {
                countQuery.setParameter(index, param);
                pageQuery.setParameter(index, param);
                ++index;
            }
        }
        ArrayList result = (totalRecord = ((Number)countQuery.getSingleResult()).longValue()) == 0L ? new ArrayList(0) : ((SQLQuery)pageQuery.setFirstResult((int)page.getOffset()).setMaxResults(page.getPageSize()).unwrap(SQLQuery.class)).list();
        return new PageImpl(result, page, totalRecord);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Map> executePageMapQueryBySql(Pageable page, String sql, Object ... params) {
        long totalRecord;
        Query countQuery = this.entityManager.createNativeQuery("select count(*) from (" + sql + ") as p");
        Query pageQuery = this.entityManager.createNativeQuery(sql);
        if (params != null) {
            int index = 1;
            for (Object param : params) {
                countQuery.setParameter(index, param);
                pageQuery.setParameter(index, param);
                ++index;
            }
        }
        ArrayList result = (totalRecord = ((Number)countQuery.getSingleResult()).longValue()) == 0L ? new ArrayList(0) : ((SQLQuery)pageQuery.setFirstResult((int)page.getOffset()).setMaxResults(page.getPageSize()).unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
        return new PageImpl(result, page, totalRecord);
    }

    String buildQuerySql(QueryWhere where) {
        return this.buildQuerySql(where.getSelect(), where.getWhere());
    }

    String buildQuerySql(String select, String where) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(select);
        sql.append(" FROM ");
        sql.append(this.getTableName());
        if (where != null && !where.isEmpty()) {
            sql.append(" WHERE ");
            sql.append(where);
        }
        return sql.toString();
    }

    String buildDeleteSql(String where) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE ");
        sql.append(" FROM ");
        sql.append(this.getTableName());
        if (where != null && !where.isEmpty()) {
            sql.append(" WHERE ");
            sql.append(where);
        }
        return sql.toString();
    }

    String buildUpdateSql(Map columnNameValues, String where) {
        StringBuilder kvs = new StringBuilder();
        int index = 1;
        for (Object key : columnNameValues.keySet()) {
            if (kvs.length() > 0) {
                kvs.append(",");
            }
            kvs.append(key);
            kvs.append(" =?");
            kvs.append(" ");
            ++index;
        }
        return this.buildUpdateSql(kvs.toString(), where);
    }

    String buildUpdateSql(String setString, String where) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(" FROM ");
        sql.append(this.getTableName());
        if (setString.length() > 0) {
            sql.append(" SET ");
            sql.append(setString);
        }
        if (where != null && !where.isEmpty()) {
            sql.append(" WHERE ");
            sql.append(where);
        }
        return sql.toString();
    }

    String converToParamIndex(String sql) {
        return sql;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public void batchInvokeEvent(Collection targets, Event event) {
        this.defaultEntityEventCallback.batchInvokeEvent(targets, event);
    }

    @Override
    public void invokeEvent(Object target, Event event) {
        this.defaultEntityEventCallback.invokeEvent(target, event);
    }

    protected String getTableName() {
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)this.entityManager.getEntityManagerFactory().unwrap(SessionFactory.class);
        SingleTableEntityPersister entityPersister = (SingleTableEntityPersister)sessionFactory.getEntityPersister(this.entityClass.getName());
        if (entityPersister != null) {
            return entityPersister.getTableName();
        }
        String name = "";
        Table tableAnnotation = this.entityClass.getAnnotation(Table.class);
        if (tableAnnotation != null) {
            name = tableAnnotation.name();
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        Entity entityAnnotation = this.entityClass.getAnnotation(Entity.class);
        if (entityAnnotation != null) {
            name = entityAnnotation.name();
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        String simpleName = this.entityClass.getSimpleName();
        return simpleName;
    }

    protected String getTableName(Class entityClass) {
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)this.entityManager.getEntityManagerFactory().unwrap(SessionFactory.class);
        SingleTableEntityPersister entityPersister = (SingleTableEntityPersister)sessionFactory.getEntityPersister(entityClass.getName());
        if (entityPersister != null) {
            return entityPersister.getTableName();
        }
        String name = "";
        Table tableAnnotation = entityClass.getAnnotation(Table.class);
        if (tableAnnotation != null) {
            name = tableAnnotation.name();
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        Entity entityAnnotation = entityClass.getAnnotation(Entity.class);
        if (entityAnnotation != null) {
            name = entityAnnotation.name();
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        String simpleName = entityClass.getSimpleName();
        return simpleName;
    }
}

