/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.data.jpa.dao.sql;

import cn.net.vidyo.framework.data.jpa.dao.sql.SqlLike;
import cn.net.vidyo.framework.data.jpa.dao.sql.SqlLogic;
import cn.net.vidyo.framework.data.jpa.dao.sql.SqlSelect;
import cn.net.vidyo.framework.data.jpa.dao.sql.SqlThan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QueryWhere {
    String select = "*";
    String where = "";
    List<Object> params = new ArrayList<Object>();

    public QueryWhere() {
    }

    public QueryWhere(String where, Object ... params) {
        this.where = where;
        this.setParams(params);
    }

    public QueryWhere addSelect(String select, String alias, SqlSelect pattern) {
        StringBuilder sql = new StringBuilder();
        if (select.length() > 1) {
            sql.append(this.select);
            sql.append(",");
        }
        switch (pattern) {
            case TEAM: {
                sql.append(select);
                break;
            }
            case COUNT: {
                sql.append(" COUNT( ").append(select).append(")");
                break;
            }
            case SUM: {
                sql.append(" SUM( ").append(select).append(")");
                break;
            }
            case MIN: {
                sql.append(" MIN( ").append(select).append(")");
                break;
            }
            case MAX: {
                sql.append(" MAX( ").append(select).append(")");
                break;
            }
            case LEN: {
                sql.append(" LEN( ").append(select).append(")");
                break;
            }
            case AVG: {
                sql.append(" AVG( ").append(select).append(")");
                break;
            }
            case FIRST: {
                sql.append(" FIRST( ").append(select).append(")");
                break;
            }
            case LAST: {
                sql.append(" LAST( ").append(select).append(")");
                break;
            }
            case ALL: {
                sql.append(" * ");
                break;
            }
            default: {
                throw new RuntimeException("pattern value is fail");
            }
        }
        if (alias != null && alias.length() > 0) {
            sql.append(" as ");
            sql.append(alias);
        }
        this.select = sql.toString();
        return this;
    }

    public void setParams(Object ... params) {
        if (params == null) {
            return;
        }
        for (Object param : params) {
            this.params.add(param);
        }
    }

    public QueryWhere addIdWhere(Object id) {
        return this.addIdWhere(SqlLogic.And, id);
    }

    public QueryWhere addWhere(String columnName, Object value) {
        return this.addWhere(SqlLogic.And, columnName, value);
    }

    public QueryWhere addThanWhere(String columnName, Object value, SqlThan pattern) {
        return this.addThanWhere(SqlLogic.And, columnName, value, pattern);
    }

    public QueryWhere addInWhere(String columnName, Collection values) {
        return this.addInWhere(SqlLogic.And, columnName, values);
    }

    public QueryWhere addInWhere(String columnName, Object ... values) {
        return this.addInWhere(SqlLogic.And, columnName, values);
    }

    public QueryWhere addLikeWhere(String columnName, Object value, SqlLike pattern) {
        return this.addLikeWhere(SqlLogic.And, columnName, value, pattern);
    }

    public QueryWhere addEqualWhere(String columnName, Object value) {
        return this.linkWhere(SqlLogic.And, columnName, value);
    }

    public QueryWhere addOrderGroupBy(String sql, Object ... params) {
        if (sql == null || sql.length() == 0 || this.where.length() == 0) {
            return this;
        }
        StringBuilder builder = new StringBuilder(this.where);
        builder.append(" ");
        builder.append(sql);
        this.where = builder.toString();
        if (params != null) {
            for (Object param : params) {
                this.params.add(param);
            }
        }
        return this;
    }

    public QueryWhere addIdWhere(SqlLogic logic, Object id) {
        return this.addWhere(logic, "id", id);
    }

    public QueryWhere addWhere(SqlLogic logic, String columnName, Object value) {
        return this.linkWhere(logic, columnName + "=?", value);
    }

    public QueryWhere addThanWhere(SqlLogic logic, String columnName, Object value, SqlThan pattern) {
        StringBuilder sql = new StringBuilder();
        sql.append(columnName);
        switch (pattern) {
            case THAN_GREATER: {
                sql.append(" > ?");
                break;
            }
            case THAN_LESS: {
                sql.append(" < ?");
                break;
            }
            case THAN_EQUAL: {
                sql.append(" = ?");
                break;
            }
            case THAN_NOT: {
                sql.append(" <> ?");
                break;
            }
            case THAN_GREATER_EQUAL: {
                sql.append(" >= ?");
                break;
            }
            case THAN_LESS_EQUAL: {
                sql.append(" <= ?");
                break;
            }
            default: {
                throw new UnsupportedOperationException("pattern fail.");
            }
        }
        return this.linkWhere(logic, sql.toString(), value);
    }

    public QueryWhere addInWhere(SqlLogic logic, String columnName, Collection values) {
        StringBuilder sql = new StringBuilder();
        for (Object value : values) {
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.insert(0, " IN (");
        sql.insert(0, columnName);
        sql.append(")");
        return this.linkWhere(logic, sql.toString(), values.toArray());
    }

    public QueryWhere addInWhere(SqlLogic logic, String columnName, Object ... values) {
        StringBuilder sql = new StringBuilder();
        for (Object value : values) {
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.insert(0, " IN (");
        sql.insert(0, columnName);
        sql.append(")");
        return this.linkWhere(logic, sql.toString(), values);
    }

    public QueryWhere addLikeWhere(SqlLogic logic, String columnName, Object value, SqlLike pattern) {
        StringBuilder sql = new StringBuilder();
        sql.append(columnName);
        sql.append(" LIKE ? ");
        switch (pattern) {
            case LIKE_PREFIX: {
                value = "%" + value;
                break;
            }
            case LIKE_POSTFIX: {
                value = value + "%";
                break;
            }
            case LIKE_KEYWORD: {
                value = "%" + value + "%";
            }
        }
        return this.linkWhere(logic, sql.toString(), value);
    }

    public QueryWhere linkWhere(SqlLogic logic, String where, Object ... params) {
        return this.linkWhere(logic, new QueryWhere(where, params));
    }

    public QueryWhere linkWhere(SqlLogic logic, QueryWhere where) {
        if (where.where.length() == 0) {
            return this;
        }
        if (this.where.length() == 0) {
            this.where = where.getWhere();
            this.params = where.getParams();
            return this;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(this.where);
        switch (logic) {
            case And: {
                sql.append(" AND ");
                break;
            }
            case Or: {
                sql.append(" OR ");
                break;
            }
            case Not: {
                sql.append(" NOT ");
            }
        }
        sql.append(where.where);
        this.where = sql.toString();
        if (where.params.size() > 0) {
            for (Object param : where.params) {
                this.params.add(param);
            }
        }
        return this;
    }

    public QueryWhere combileWhere(SqlLogic logic, String where, Object ... params) {
        return this.combileWhere(logic, new QueryWhere(where, params));
    }

    public QueryWhere combileWhere(SqlLogic logic, QueryWhere where) {
        if (where.where.length() == 0) {
            return this;
        }
        if (this.where.length() == 0) {
            this.where = where.getWhere();
            this.params = where.getParams();
            return this;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" ( ");
        sql.append(this.where);
        sql.append(" ) ");
        switch (logic) {
            case And: {
                sql.append(" AND (");
                break;
            }
            case Or: {
                sql.append(" OR (");
                break;
            }
            case Not: {
                sql.append(" NOT (");
            }
        }
        sql.append(where.where);
        sql.append(" )");
        this.where = sql.toString();
        if (where.params.size() > 0) {
            for (Object param : where.params) {
                this.params.add(param);
            }
        }
        return this;
    }

    public void addParam(Object value) {
        this.params.add(value);
    }

    public void addParam(Object ... values) {
        for (Object value : values) {
            this.addParam(value);
        }
    }

    public void addParam(Collection values) {
        for (Object value : values) {
            this.addParam(value);
        }
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public List<Object> getParams() {
        return this.params;
    }

    public void setParams(List<Object> params) {
        this.params = params;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }
}

