/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.data.jpa.dao;

import cn.net.vidyo.framework.common.util.ObjectUtil;
import cn.net.vidyo.framework.common.util.StringUtils;
import cn.net.vidyo.framework.data.jpa.dao.CommonJpaRepository;
import cn.net.vidyo.framework.data.jpa.dao.EntityEventCallback;
import cn.net.vidyo.framework.data.jpa.dao.Event;
import cn.net.vidyo.framework.data.jpa.dao.sql.DeleteWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.QueryWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.UpdateWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.WhereWrapper;
import cn.net.vidyo.framework.data.jpa.dao.support.DefaultEntityEventCallback;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Table;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;

public class CommonJpaRepositoryImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements EntityEventCallback,
CommonJpaRepository<T, ID> {
    static int BATCH_SIZE = 10000;
    private final EntityManager entityManager;
    JpaEntityInformation<T, ?> entityInformation;
    Class<T> entityClass;
    EntityEventCallback defaultEntityEventCallback;

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public CommonJpaRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
        this.entityInformation = entityInformation;
        this.entityClass = entityInformation.getJavaType();
        this.defaultEntityEventCallback = new DefaultEntityEventCallback();
    }

    @Override
    public int updateStatusById(ID id, Object value) {
        return this.updateColumnById(id, "status", value);
    }

    @Override
    public int updateHiddenById(ID id, Object value) {
        return this.updateColumnById(id, "hidden", value);
    }

    @Override
    public int updateColumnById(ID id, String fieldName, Object value) {
        return this.updateColumn(fieldName, value, new QueryWrapper().inId(id));
    }

    @Override
    public int increaseColumnValueById(ID id, String fieldName, int delta) {
        return this.increaseColumn(fieldName, delta, "id=?", id);
    }

    @Override
    public int deleteByIds(Iterable<ID> ids) {
        if (ids == null) {
            return 0;
        }
        WhereWrapper wrapper = new WhereWrapper();
        wrapper.in("id", ids);
        return this.delete(wrapper);
    }

    @Override
    public int deleteByIds(ID ... ids) {
        if (ids == null) {
            return 0;
        }
        WhereWrapper wrapper = new WhereWrapper();
        wrapper.eq(ids.length == 1, "id", ids[0]);
        wrapper.in(ids.length > 0, "id", (Object[])ids);
        return this.delete(wrapper);
    }

    public void deleteAll() {
        this.deleteByWhere(new QueryWrapper());
    }

    public void deleteAll(Iterable<? extends T> entities) {
        ArrayList<ID> ids = new ArrayList<ID>();
        for (T entity : entities) {
            ID id = this.getIdByEntity(entity);
            ids.add(id);
        }
        this.deleteByWhere(new QueryWrapper().in("id", ids));
    }

    @Override
    public T getById(ID id) {
        Optional optional = this.findById(id);
        if (!optional.isPresent()) {
            return null;
        }
        Object t = optional.get();
        this.invokeEvent(t, Event.PostLoad);
        return t;
    }

    @Override
    public ID getIdByEntity(T t) {
        return (ID)((Serializable)ObjectUtil.getFieldValueByFieldName(t, (String)"id"));
    }

    @Override
    public T getByEntityId(T t) {
        ID id = this.getIdByEntity(t);
        return this.getById(id);
    }

    @Override
    public int truncateParmeryKey(Class entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("TRUNCATE TABLE ");
        sql.append(this.getTableName(entityClass));
        return this.execUpdate(sql.toString(), new Object[0]);
    }

    @Override
    public int dropTable(Class entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("DROP TABLE ");
        sql.append(this.getTableName(entityClass));
        return this.execUpdate(sql.toString(), new Object[0]);
    }

    @Override
    public Object getColumnByWhere(String fieldName, WhereWrapper wrapper) {
        QueryWrapper queryWrapper = new QueryWrapper(this.getTableName(), wrapper);
        queryWrapper.setSelectSql(fieldName);
        Map map = this.getMap(queryWrapper);
        if (map != null && map.containsKey(fieldName)) {
            return map.get(fieldName);
        }
        return null;
    }

    @Override
    public Object getColumnById(ID id, String fieldName) {
        WhereWrapper whereWrapper = new WhereWrapper("id", id);
        return this.getColumnByWhere(fieldName, whereWrapper);
    }

    @Override
    public String getStringColumnById(ID id, String fieldName) {
        Object value = this.getColumnById(id, fieldName);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public String getNameById(ID id) {
        return this.getStringColumnById(id, "name");
    }

    @Override
    public String getIdKeyById(ID id) {
        return this.getStringColumnById(id, "idkey");
    }

    @Override
    public String getCodeById(ID id) {
        return this.getStringColumnById(id, "code");
    }

    @Override
    public List<T> findByIds(List<ID> ids) {
        return this.findAllById(ids);
    }

    @Override
    public List<T> findByIds(ID[] ids) {
        List<ID> list = Arrays.asList(ids);
        return this.findByIds(list);
    }

    public Page<T> pageAll(int pageNumber, int pageSize) {
        return this.pageAll((Pageable)PageRequest.of((int)pageNumber, (int)pageSize));
    }

    public Page<T> pageAll() {
        return this.pageAll(1, 100000);
    }

    public Page<T> pageAll(Pageable pageable) {
        return this.pageQueryModels(pageable, new QueryWrapper());
    }

    public List<T> findAll() {
        return this.queryModels(new QueryWrapper());
    }

    @Override
    public int increaseColumn(String columName, int delta, String where, Object ... params) {
        UpdateWrapper wrapper = new UpdateWrapper(this.getTableName(), where, params);
        wrapper.set(true, columName, columName + "+?", delta);
        return this.execUpdate(wrapper);
    }

    @Override
    public int increaseColumn(String columName, int delta, WhereWrapper where) {
        UpdateWrapper wrapper = new UpdateWrapper(this.getTableName(), where);
        wrapper.set(true, columName, columName + "+?", delta);
        return this.execUpdate(wrapper);
    }

    @Override
    public int updateColumn(String columName, Object value, String where, Object ... params) {
        UpdateWrapper wrapper = new UpdateWrapper(this.getTableName(), where, params);
        wrapper.set(columName, value);
        return this.execUpdate(wrapper);
    }

    @Override
    public int updateColumn(String columName, Object value, WhereWrapper where) {
        UpdateWrapper wrapper = new UpdateWrapper(this.getTableName(), where);
        wrapper.set(columName, value);
        return this.execUpdate(wrapper);
    }

    @Override
    public int updateColumns(Map<String, Object> columnNameValues, WhereWrapper where) {
        UpdateWrapper wrapper = new UpdateWrapper(this.getTableName(), where);
        wrapper.set(true, columnNameValues);
        return this.execUpdate(wrapper);
    }

    public int updateColumn(String columName, Object value, QueryWrapper where) {
        UpdateWrapper wrapper = new UpdateWrapper(this.getTableName(), where);
        wrapper.set(columName, value);
        return this.execUpdate(wrapper);
    }

    @Override
    public int updateColumns(Map columnNameValues, String where, Object ... params) {
        UpdateWrapper wrapper = new UpdateWrapper(this.getTableName(), where, params);
        wrapper.set(true, columnNameValues);
        return this.execUpdate(wrapper);
    }

    public int updateColumns(Map columnNameValues, QueryWrapper where) {
        UpdateWrapper wrapper = new UpdateWrapper(this.getTableName(), where);
        wrapper.set(true, columnNameValues);
        return this.execUpdate(wrapper);
    }

    @Override
    public <S extends T> Iterable<S> batchUpdate(Iterable<S> var1) {
        Iterator<S> iterator = var1.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            S entity = iterator.next();
            this.invokeEvent(entity, Event.PreUpdate);
            this.entityManager.merge(entity);
            this.invokeEvent(entity, Event.PostUpdate);
            if (++index % BATCH_SIZE != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (index % BATCH_SIZE != 0) {
            this.entityManager.flush();
            this.entityManager.clear();
        }
        return var1;
    }

    @Override
    public <S extends T> S save(S entity) {
        if (this.entityInformation.isNew(entity)) {
            this.invokeEvent(entity, Event.PrePersist);
            this.entityManager.persist(entity);
            this.invokeEvent(entity, Event.PostPersist);
            return entity;
        }
        this.invokeEvent(entity, Event.PreUpdate);
        Object merge = this.entityManager.merge(entity);
        this.invokeEvent(merge, Event.PostUpdate);
        return (S)merge;
    }

    @Override
    public <S extends T> S saveAndFlush(S entity) {
        S result = this.save(entity);
        this.flush();
        return result;
    }

    @Override
    public <S extends T> Iterable<S> batchSave(Iterable<S> var1) {
        Iterator<S> iterator = var1.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            S entity = iterator.next();
            this.invokeEvent(entity, Event.PrePersist);
            this.entityManager.persist(entity);
            this.invokeEvent(entity, Event.PostPersist);
            if (++index % BATCH_SIZE != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (index % BATCH_SIZE != 0) {
            this.entityManager.flush();
            this.entityManager.clear();
        }
        return var1;
    }

    public <S extends T> S insert(S entity) {
        this.invokeEvent(entity, Event.PrePersist);
        this.entityManager.persist(entity);
        this.invokeEvent(entity, Event.PostPersist);
        return entity;
    }

    public <S extends T> S update(S entity) {
        this.invokeEvent(entity, Event.PreUpdate);
        Object merge = this.entityManager.merge(entity);
        this.invokeEvent(merge, Event.PostUpdate);
        return (S)merge;
    }

    @Override
    public int deleteByWhere(String where, Object ... params) {
        DeleteWrapper wrapper = new DeleteWrapper(this.getTableName(), where, params);
        return this.execDelete(wrapper);
    }

    @Override
    public int deleteByWhere(WhereWrapper where) {
        DeleteWrapper wrapper = new DeleteWrapper(this.getTableName(), where);
        return this.execDelete(wrapper);
    }

    public int deleteByWhere(QueryWrapper where) {
        DeleteWrapper wrapper = new DeleteWrapper(this.getTableName(), where);
        return this.execDelete(wrapper);
    }

    @Override
    public Object getObject(String columnName, String where, Object ... params) {
        return this.getObject(columnName, new QueryWrapper(where, params));
    }

    @Override
    public Object getObject(String columnName, WhereWrapper where) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where);
        wrapper.setSelectSql(columnName);
        return this.execObjectQuery(wrapper);
    }

    @Override
    public T getModel(String where, Object ... params) {
        return this.getModel(new QueryWrapper(where, params));
    }

    @Override
    public <C> C getColumn(Class<C> cClass, String select, String where, Object ... params) {
        QueryWrapper queryWhere = new QueryWrapper(where, params);
        queryWhere.setSelectSql(select);
        return this.getColumn(cClass, queryWhere);
    }

    @Override
    public <C> C getColumn(Class<C> cClass, String select, WhereWrapper where) {
        QueryWrapper queryWhere = new QueryWrapper(this.getTableName(), where);
        queryWhere.setSelectSql(select);
        return this.getColumn(cClass, queryWhere);
    }

    @Override
    public Map getMap(String where, Object ... params) {
        return this.execMapQuery(new QueryWrapper(this.getTableName(), where, params));
    }

    @Override
    public List<T> queryModels(String where, Object ... params) {
        return this.queryModels(new WhereWrapper(where, params));
    }

    @Override
    public List<T> queryModels(WhereWrapper where) {
        QueryWrapper selectWhere = new QueryWrapper(this.getTableName(), where);
        return this.queryModels(selectWhere);
    }

    @Override
    public <C> List<C> queryColumns(Class<C> cClass, String select, String where, Object ... params) {
        QueryWrapper selectWhere = new QueryWrapper(where, params);
        selectWhere.setSelectSql(select);
        return this.queryColumns(cClass, selectWhere);
    }

    @Override
    public <C> List<C> queryColumns(Class<C> cClass, QueryWrapper where) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where);
        wrapper.setSelectSql(where.getSelectSql());
        return this.execListColumnQuery(cClass, wrapper);
    }

    @Override
    public List queryObjects(String select, String where, Object ... params) {
        QueryWrapper selectWhere = new QueryWrapper(where, params);
        selectWhere.setSelectSql(select);
        return this.queryObjects(selectWhere);
    }

    @Override
    public List queryObjects(QueryWrapper where) {
        return this.execListObjectQuery(where);
    }

    @Override
    public List<Map> queryMaps(String select, String where, Object ... params) {
        return null;
    }

    public List<Map> queryMaps(String where, Object ... params) {
        return this.queryMaps(new QueryWrapper(where, params));
    }

    @Override
    public List<Map> queryMaps(QueryWrapper where) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where);
        return this.execListMapQuery(wrapper);
    }

    @Override
    public Page<T> pageQueryModels(int pageNumber, int pageSize, String where, Object ... params) {
        return this.pageQueryModels(pageNumber, pageSize, where, params);
    }

    public Page<T> pageQueryModels(int pageNumber, int pageSize, QueryWrapper where) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        return this.pageQueryModels((Pageable)pageable, where);
    }

    @Override
    public Page<T> pageQueryModels(int pageNumber, int pageSize, WhereWrapper where) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where);
        wrapper.setPageNumber(pageNumber);
        wrapper.setPageSize(pageSize);
        return this.execPageQuery(wrapper);
    }

    @Override
    public Page<T> pageQueryModels(int pageNumber, int pageSize, String select, String where, Object ... params) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        return this.pageQueryModels((Pageable)pageable, select, where, params);
    }

    @Override
    public Page<T> pageQueryModels(Pageable pageable, String where, Object ... params) {
        return this.pageQueryModels(pageable, "*", where, params);
    }

    @Override
    public Page<T> pageQueryModels(Pageable pageable, WhereWrapper where) {
        QueryWrapper queryWrapper = new QueryWrapper(this.getTableName(), where);
        queryWrapper.setPageable(pageable);
        return this.execPageQuery(queryWrapper);
    }

    @Override
    public Page<T> pageQueryModels(QueryWrapper wrapper) {
        return this.execPageQuery(wrapper);
    }

    @Override
    public Page<T> pageQueryModels(Pageable pageable, String select, String where, Object ... params) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where, params);
        wrapper.setSelectSql(select);
        wrapper.setPageable(pageable);
        return this.execPageQuery(wrapper);
    }

    @Override
    public Page<Map> pageQueryMaps(Pageable pageable, String select, String where, Object ... params) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where, new Object[0]);
        wrapper.setSelectSql(select);
        wrapper.setPageable(pageable);
        return this.execMapPageQuery(wrapper);
    }

    @Override
    public Page<Map> pageQueryMaps(Pageable pageable, QueryWrapper where) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where);
        wrapper.setSelectSql(where.getSelectSql());
        wrapper.setPageable(pageable);
        return this.execMapPageQuery(wrapper);
    }

    @Override
    public Page<Map> pageQueryMaps(QueryWrapper where) {
        return this.execMapPageQuery(where);
    }

    @Override
    public Page<Map> pageSelectQueryMap(Pageable pageable, String select, String where, Object ... params) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where, new Object[0]);
        wrapper.setSelectSql(select);
        wrapper.setPageable(pageable);
        return this.execMapPageQuery(wrapper);
    }

    @Override
    public Page pageQueryObjects(Pageable pageable, QueryWrapper where) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where);
        wrapper.setSelectSql(where.getSelectSql());
        wrapper.setPageable(pageable);
        return this.execObjectPageQuery(wrapper);
    }

    @Override
    public Page pageQueryObjects(QueryWrapper where) {
        return this.execObjectPageQuery(where);
    }

    @Override
    public Page pageQueryObjects(Pageable pageable, String select, String where, Object ... params) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where, params);
        wrapper.setSelectSql(select);
        wrapper.setPageable(pageable);
        return this.execObjectPageQuery(wrapper);
    }

    @Override
    public <C> Page<C> pageQueryColumns(Class<C> cClass, Pageable pageable, QueryWrapper where) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where);
        wrapper.setSelectSql(where.getSelectSql());
        wrapper.setPageable(pageable);
        return this.execColumnPageQuery(cClass, wrapper);
    }

    @Override
    public <C> Page<C> pageQueryColumns(Class<C> cClass, QueryWrapper where) {
        return this.execColumnPageQuery(cClass, where);
    }

    @Override
    public <C> Page<C> pageQueryColumns(Class<C> cClass, Pageable pageable, String select, String where, Object ... params) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where, params);
        wrapper.setSelectSql(select);
        wrapper.setPageable(pageable);
        return this.execColumnPageQuery(cClass, wrapper);
    }

    @Override
    public int update(UpdateWrapper wrapper) {
        return this.execUpdate(wrapper);
    }

    @Override
    public int delete(WhereWrapper wrapper) {
        DeleteWrapper deleteWrapper = new DeleteWrapper(this.getTableName(), wrapper);
        return this.execDelete(deleteWrapper);
    }

    @Override
    public T getModel(WhereWrapper wrapper) {
        QueryWrapper queryWrapper = new QueryWrapper(this.getTableName(), wrapper);
        return this.execModelQuery(queryWrapper);
    }

    @Override
    public List<T> findModels(WhereWrapper wrapper) {
        QueryWrapper queryWrapper = new QueryWrapper(this.getTableName(), wrapper);
        return this.execListModelQuery(queryWrapper);
    }

    @Override
    public Page<T> pageModels(WhereWrapper wrapper) {
        QueryWrapper queryWrapper = new QueryWrapper(this.getTableName(), wrapper);
        return this.execPageQuery(queryWrapper);
    }

    @Override
    public <C> C getColumn(Class<C> cClass, QueryWrapper wrapper) {
        if (StringUtils.isBlank((CharSequence)wrapper.getTableName())) {
            wrapper.setTableName(this.getTableName());
        }
        return this.execColumnQuery(cClass, wrapper);
    }

    @Override
    public <C> List<C> findColumns(Class<C> cClass, QueryWrapper wrapper) {
        if (StringUtils.isBlank((CharSequence)wrapper.getTableName())) {
            wrapper.setTableName(this.getTableName());
        }
        return this.execListColumnQuery(cClass, wrapper);
    }

    @Override
    public <C> Page<C> pageColumns(Class<C> cClass, QueryWrapper wrapper) {
        return this.execColumnPageQuery(cClass, wrapper);
    }

    @Override
    public Map getMap(QueryWrapper wrapper) {
        return this.execMapQuery(wrapper);
    }

    @Override
    public List<Map> findMaps(QueryWrapper wrapper) {
        return this.execListMapQuery(wrapper);
    }

    @Override
    public Page<Map> pageMaps(QueryWrapper wrapper) {
        return this.execMapPageQuery(wrapper);
    }

    @Override
    public Page execObjectPageQuery(QueryWrapper wrapper) {
        return this.execObjectPageQuery(wrapper.getPageNumber(), wrapper.getPageSize(), wrapper.getSelectSql(), wrapper.getWhereSql(), wrapper.getSqlParams());
    }

    @Override
    public Page execObjectPageQuery(int pageNumber, int pageSize, String select, String where, Object ... params) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where, params);
        wrapper.setPageNumber(pageNumber);
        wrapper.setPageSize(pageSize);
        wrapper.setSelectSql(select);
        Long totalRecord = this.execColumnQuery(Long.class, wrapper.getCountSql(), wrapper.getSqlParams());
        List list = this.execListObjectQuery(wrapper.getPageSql(), wrapper.getSqlParams());
        PageRequest page = PageRequest.of((int)pageNumber, (int)pageSize);
        return new PageImpl(list, (Pageable)page, totalRecord.longValue());
    }

    @Override
    public Page<T> execPageQuery(int pageNumber, int pageSize, String where, Object ... params) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where, params);
        wrapper.setPageNumber(pageNumber);
        wrapper.setPageSize(pageSize);
        Long totalRecord = this.execColumnQuery(Long.class, wrapper.getCountSql(), wrapper.getSqlParams());
        List<T> list = this.execListModelQuery(wrapper.getPageSql(), wrapper.getSqlParams());
        PageRequest page = PageRequest.of((int)pageNumber, (int)pageSize);
        return new PageImpl(list, (Pageable)page, totalRecord.longValue());
    }

    @Override
    public <C> Page<C> execColumnPageQuery(int pageNumber, int pageSize, Class<C> tClass, String select, String where, Object ... params) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where, params);
        wrapper.setPageNumber(pageNumber);
        wrapper.setPageSize(pageSize);
        wrapper.setSelectSql(select);
        Long totalRecord = this.execColumnQuery(Long.class, wrapper.getCountSql(), wrapper.getSqlParams());
        List<C> list = this.execListColumnQuery(tClass, wrapper.getPageSql(), wrapper.getSqlParams());
        PageRequest page = PageRequest.of((int)pageNumber, (int)pageSize);
        return new PageImpl(list, (Pageable)page, totalRecord.longValue());
    }

    @Override
    public Page<Map> execMapPageQuery(int pageNumber, int pageSize, String select, String where, Object ... params) {
        QueryWrapper wrapper = new QueryWrapper(this.getTableName(), where, params);
        wrapper.setSelectSql(select);
        wrapper.setPageNumber(pageNumber);
        wrapper.setPageSize(pageSize);
        wrapper.setSelectSql(select);
        Long totalRecord = this.execColumnQuery(Long.class, wrapper.getCountSql(), wrapper.getSqlParams());
        List<Map> list = this.execListMapQuery(wrapper.getPageSql(), wrapper.getSqlParams());
        PageRequest page = PageRequest.of((int)pageNumber, (int)pageSize);
        return new PageImpl(list, (Pageable)page, totalRecord.longValue());
    }

    @Override
    public Page<T> execPageQuery(QueryWrapper wrapper) {
        return this.execPageQuery(wrapper.getPageNumber(), wrapper.getPageSize(), wrapper.getSelectSql(), wrapper.getWhereSql(), wrapper.getSqlParams());
    }

    @Override
    public <C> Page<C> execColumnPageQuery(Class<C> tClass, QueryWrapper wrapper) {
        return this.execColumnPageQuery(wrapper.getPageNumber(), wrapper.getPageSize(), tClass, wrapper.getSelectSql(), wrapper.getWhereSql(), wrapper.getSqlParams());
    }

    @Override
    public Page<Map> execMapPageQuery(QueryWrapper wrapper) {
        return this.execMapPageQuery(wrapper.getPageNumber(), wrapper.getPageSize(), wrapper.getSelectSql(), wrapper.getWhereSql(), wrapper.getSqlParams());
    }

    @Override
    public int execUpdate(UpdateWrapper wrapper) {
        if (StringUtils.isBlank((CharSequence)wrapper.getTableName())) {
            wrapper.setTableName(this.getTableName());
        }
        return this.execUpdate(wrapper.getSql(), wrapper.getSqlParams());
    }

    @Override
    public int execDelete(DeleteWrapper wrapper) {
        if (StringUtils.isBlank((CharSequence)wrapper.getTableName())) {
            wrapper.setTableName(this.getTableName());
        }
        return this.execUpdate(wrapper.getSql(), wrapper.getSqlParams());
    }

    @Override
    public Object execObjectQuery(QueryWrapper wrapper) {
        if (StringUtils.isBlank((CharSequence)wrapper.getTableName())) {
            wrapper.setTableName(this.getTableName());
        }
        return this.execObjectQuery(wrapper.getSql(), wrapper.getSqlParams());
    }

    @Override
    public List execListObjectQuery(QueryWrapper wrapper) {
        if (StringUtils.isBlank((CharSequence)wrapper.getTableName())) {
            wrapper.setTableName(this.getTableName());
        }
        return this.execListObjectQuery(wrapper.getSql(), wrapper.getSqlParams());
    }

    @Override
    public <C> C execColumnQuery(Class<C> tClass, QueryWrapper wrapper) {
        if (StringUtils.isBlank((CharSequence)wrapper.getTableName())) {
            wrapper.setTableName(this.getTableName());
        }
        return this.execColumnQuery(tClass, wrapper.getSql(), wrapper.getSqlParams());
    }

    @Override
    public <C> List<C> execListColumnQuery(Class<C> tClass, QueryWrapper wrapper) {
        if (StringUtils.isBlank((CharSequence)wrapper.getTableName())) {
            wrapper.setTableName(this.getTableName());
        }
        return this.execListColumnQuery(tClass, wrapper.getSql(), wrapper.getSqlParams());
    }

    @Override
    public Map execMapQuery(QueryWrapper wrapper) {
        if (StringUtils.isBlank((CharSequence)wrapper.getTableName())) {
            wrapper.setTableName(this.getTableName());
        }
        return this.execMapQuery(wrapper.getSql(), wrapper.getSqlParams());
    }

    @Override
    public List<Map> execListMapQuery(QueryWrapper wrapper) {
        if (StringUtils.isBlank((CharSequence)wrapper.getTableName())) {
            wrapper.setTableName(this.getTableName());
        }
        return this.execListMapQuery(wrapper.getSql(), wrapper.getSqlParams());
    }

    @Override
    public T execModelQuery(QueryWrapper wrapper) {
        if (StringUtils.isBlank((CharSequence)wrapper.getTableName())) {
            wrapper.setTableName(this.getTableName());
        }
        return this.execModelQuery(wrapper.getSql(), wrapper.getSqlParams());
    }

    @Override
    public List<T> execListModelQuery(QueryWrapper wrapper) {
        if (StringUtils.isBlank((CharSequence)wrapper.getTableName())) {
            wrapper.setTableName(this.getTableName());
        }
        return this.execListModelQuery(wrapper.getSql(), wrapper.getSqlParams());
    }

    @Override
    public int execUpdate(String sql, Object ... params) {
        Query query = this.entityManager.createNativeQuery(sql);
        if (params != null) {
            int index = 1;
            for (Object param : params) {
                query.setParameter(index, param);
                ++index;
            }
        }
        return query.executeUpdate();
    }

    @Override
    public Object execObjectQuery(String sql, Object ... params) {
        List list = this.execListObjectQuery(sql, params);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List execListObjectQuery(String sql, Object ... params) {
        Query query = this.entityManager.createNativeQuery(sql);
        if (params != null) {
            int index = 1;
            for (Object param : params) {
                query.setParameter(index, param);
                ++index;
            }
        }
        return query.getResultList();
    }

    @Override
    public <C> C execColumnQuery(Class<C> tClass, String sql, Object ... params) {
        List<C> list = this.execListColumnQuery(tClass, sql, params);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <C> List<C> execListColumnQuery(Class<C> tClass, String sql, Object ... params) {
        Query query = this.entityManager.createNativeQuery(sql, tClass);
        if (params != null) {
            int index = 1;
            for (Object param : params) {
                query.setParameter(index, param);
                ++index;
            }
        }
        return query.getResultList();
    }

    @Override
    public Map execMapQuery(String sql, Object ... params) {
        List<Map> list = this.execListMapQuery(sql, params);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<Map> execListMapQuery(String sql, Object ... params) {
        Query query = this.entityManager.createNativeQuery(sql);
        if (params != null) {
            int index = 1;
            for (Object param : params) {
                query.setParameter(index, param);
                ++index;
            }
        }
        List result = ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
        return result;
    }

    @Override
    public T execModelQuery(String sql, Object ... params) {
        List<T> list = this.execListModelQuery(sql, params);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<T> execListModelQuery(String sql, Object ... params) {
        Query query = this.entityManager.createNativeQuery(sql, this.entityClass);
        if (params != null) {
            int index = 1;
            for (Object param : params) {
                query.setParameter(index, param);
                ++index;
            }
        }
        return query.getResultList();
    }

    @Override
    public void batchInvokeEvent(Collection targets, Event event) {
    }

    @Override
    public void invokeEvent(Object target, Event event) {
    }

    protected String getTableName() {
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)this.entityManager.getEntityManagerFactory().unwrap(SessionFactory.class);
        SingleTableEntityPersister entityPersister = (SingleTableEntityPersister)sessionFactory.getEntityPersister(this.entityClass.getName());
        if (entityPersister != null) {
            return entityPersister.getTableName();
        }
        String name = "";
        Table tableAnnotation = this.entityClass.getAnnotation(Table.class);
        if (tableAnnotation != null) {
            name = tableAnnotation.name();
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        Entity entityAnnotation = this.entityClass.getAnnotation(Entity.class);
        if (entityAnnotation != null) {
            name = entityAnnotation.name();
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        String simpleName = this.entityClass.getSimpleName();
        return simpleName;
    }

    protected String getTableName(Class entityClass) {
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)this.entityManager.getEntityManagerFactory().unwrap(SessionFactory.class);
        SingleTableEntityPersister entityPersister = (SingleTableEntityPersister)sessionFactory.getEntityPersister(entityClass.getName());
        if (entityPersister != null) {
            return entityPersister.getTableName();
        }
        String name = "";
        Table tableAnnotation = entityClass.getAnnotation(Table.class);
        if (tableAnnotation != null) {
            name = tableAnnotation.name();
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        Entity entityAnnotation = entityClass.getAnnotation(Entity.class);
        if (entityAnnotation != null) {
            name = entityAnnotation.name();
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        String simpleName = entityClass.getSimpleName();
        return simpleName;
    }
}

