package cn.net.vidyo.framework.data.jpa.service;

import cn.net.vidyo.framework.data.jpa.dao.sql.DeleteWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.QueryWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.UpdateWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.WhereWrapper;
import cn.net.vidyo.framework.data.jpa.domain.Condition;
import cn.net.vidyo.framework.data.jpa.dao.CommonJpaRepository;
import org.springframework.data.domain.Page;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

public abstract class EntityConditionServiceImpl<
        CONDITION extends Condition,
        DAO extends CommonJpaRepository<T, ID>,
        T, ID extends Serializable>
        extends EntityServiceImpl<DAO,T,ID>
        implements EntityConditionService<CONDITION,DAO,T,ID> {

    //<editor-fold desc="query condition">

    //<editor-fold desc="query object">

    @Override
    public Page pageQueryObjects(String select, CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        queryWhere.setSelectSql(select);
        return getEntityDao().pageQueryObjects(queryWhere);
    }

    public Object getColumn(String columnName, CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        queryWhere.setSelectSql(columnName);
        return getEntityDao().getObject(columnName, queryWhere);
    }
    public <C> C getColumn(Class<C> cClass, String columnName, CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        queryWhere.setSelectSql(columnName);
        return getEntityDao().getColumn(cClass, columnName, queryWhere);
    }

    public T getModel(CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        return getEntityDao().getModel(queryWhere);
    }

    public Map getMap(CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        return getEntityDao().getMap(queryWhere);
    }
    public Object getObject(String select, CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        queryWhere.setSelectSql(select);
        return getEntityDao().getObject(select,queryWhere);
    }

    //</editor-fold>
    //<editor-fold desc="query object list">
    public List<T> queryModels(CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        return getEntityDao().queryModels(queryWhere);
    }

    public <C> List<C> queryColumns(Class<C> cClass, CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        return getEntityDao().queryColumns(cClass, queryWhere);
    }
    public List<Map> queryMaps(CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        return getEntityDao().queryMaps( queryWhere);
    }
    public List queryObjects(String select,CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        queryWhere.setSelectSql(select);
        return getEntityDao().queryObjects( queryWhere);
    }

    //</editor-fold>
    //<editor-fold desc="query object page">
    public Page<T> pageQueryModels(CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        queryWhere.setPageable(condition);
        return getEntityDao().pageQueryModels( queryWhere);
    }

    public <C> Page<C> pageQueryColumns(Class<C> cClass, CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        queryWhere.setPageable(condition);
        return getEntityDao().pageQueryColumns(cClass, queryWhere);
    }

    public Page<Map> pageQueryMaps(CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        queryWhere.setPageable(condition);
        return getEntityDao().pageQueryMaps( queryWhere);
    }

    public Page<Map> pageQueryMap(int pageNumber, int pageSize, CONDITION condition) {
        QueryWrapper queryWhere = buildQueryCondition(condition);
        queryWhere.setPageNumber(pageNumber);
        queryWhere.setPageSize(pageSize);
        return getEntityDao().pageQueryMaps( queryWhere);
    }

    //</editor-fold>
    //</editor-fold>

    //<editor-fold desc="buildConditon">
    public QueryWrapper buildQueryCondition(CONDITION condition) {
        QueryWrapper wrapper = new QueryWrapper();
        return buildQueryCondition(condition, wrapper);
    }

    public QueryWrapper buildQueryCondition(CONDITION condition, QueryWrapper wrapper) {
        if (wrapper == null) {
            wrapper = new QueryWrapper();
        }
        return (QueryWrapper) buildWhereCondition(condition, wrapper);
    }

    public UpdateWrapper buildUpdateCondition(CONDITION condition, UpdateWrapper wrapper) {
        return (UpdateWrapper) buildWhereCondition(condition, wrapper);
    }
    public DeleteWrapper buildDeleteCondition(CONDITION condition, DeleteWrapper wrapper) {
        return (DeleteWrapper) buildWhereCondition(condition, wrapper);
    }

    public abstract WhereWrapper buildWhereCondition(CONDITION condition, WhereWrapper wrapper) ;
    //</editor-fold>
}
