package cn.net.vidyo.framework.data.jpa.dao;

import cn.net.vidyo.framework.data.jpa.dao.sql.DeleteWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.UpdateWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.WhereWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.QueryWrapper;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.NoRepositoryBean;

import java.io.Serializable;
import java.util.*;

@NoRepositoryBean
public interface CommonJpaRepository<T, ID extends Serializable> extends JpaRepository<T, ID>, JpaSpecificationExecutor<T> {

    Class<T> getEntityClass();
    //<editor-fold desc="Extent">
    //<editor-fold desc="update">

    //    <S extends T> S insert(S entity);
//    <S extends T> S update(S entity);
    int updateStatusById(ID id, Object value);


    int updateHiddenById(ID id, Object value);


    int updateColumnById(ID id, String fieldName, Object value);

    int increaseColumnValueById(ID id, String fieldName, int delta);

    //</editor-fold>
    //<editor-fold desc="delete">

    int deleteByIds(Iterable<ID> ids);

    int deleteByIds(ID ... ids);

    //</editor-fold>
    //<editor-fold desc="Query">


    //<editor-fold desc="get entity">

    T getById(ID id);

    ID getIdByEntity(T t);

    T getByEntityId(T t);

    int truncateParmeryKey(Class entityClass);

    int dropTable(Class entityClass);


    //</editor-fold>
    //<editor-fold desc="get column">
    Object getColumnByWhere(String fieldName,WhereWrapper wrapper);

    Object getColumnById(ID id, String fieldName);
    String getStringColumnById(ID id, String fieldName) ;


    String getNameById(ID id);
    String getIdKeyById(ID id);
    String getCodeById(ID id);

    //</editor-fold>
    //<editor-fold desc="find list">

    List<T> findByIds(List<ID> ids);


    List<T> findByIds(ID[] ids);

    //</editor-fold>
    //</editor-fold>
    //</editor-fold>
    //<editor-fold desc="Base">
    //<editor-fold desc="update">
    int increaseColumn(String columName,int delta,String where,Object... params);
    int increaseColumn(String columName, int delta, WhereWrapper where);
    int updateColumn(String columName,Object value,String where,Object... params);
    int updateColumn(String columName, Object value, WhereWrapper where);
    int updateColumns(Map<String,Object> columnNameValues,String where,Object... params);
    int updateColumns(Map<String,Object> columnNameValues, WhereWrapper where);
    <S extends T> Iterable<S> batchUpdate(Iterable<S> var1);
    //</editor-fold>
    //<editor-fold desc="insert">
    <S extends T> S save(S entity);
    <S extends T> S saveAndFlush(S entity);
    <S extends T> Iterable<S> batchSave(Iterable<S> var1);
    //</editor-fold>
    //<editor-fold desc="delete">
    int deleteByWhere(String where,Object... params);
    int deleteByWhere(WhereWrapper where);
    //</editor-fold>
    //<editor-fold desc="query">

    //<editor-fold desc="query object">
    Object getObject(String columnName, String where, Object... params);
    Object getObject(String columnName, WhereWrapper wrapper);
    T getModel( String where, Object... params);
    <C> C getColumn(Class<C> cClass,String columnName, String where, Object... params);
    <C> C getColumn(Class<C> cClass,String columnName, WhereWrapper wrapper);
    Map getMap(String where, Object... params);

    //</editor-fold>
    //<editor-fold desc="query object list">
    List<T> queryModels(String where, Object... params);
    List<T> queryModels(WhereWrapper where);
    List queryObjects( String select, String where, Object... params);
    List queryObjects(QueryWrapper wrapper);
    <C> List<C> queryColumns(Class<C> cClass, String select, String where, Object... params);
    <C> List<C> queryColumns(Class<C> cClass, QueryWrapper wrapper);
    List<Map> queryMaps(String select, String where, Object... params);
    List<Map> queryMaps(QueryWrapper wrapper);

    //</editor-fold>
    //<editor-fold desc="query object page">
    Page<T> pageQueryModels(Pageable pageable, String where, Object... params) ;
    Page<T> pageQueryModels(Pageable pageable, WhereWrapper wrapper);
    Page<T> pageQueryModels(QueryWrapper wrapper);
    Page<T> pageQueryModels(Pageable pageable, String select, String where, Object... params);

    Page<T> pageQueryModels(int pageNumber, int pageSize, String where, Object... params);
    Page<T> pageQueryModels(int pageNumber, int pageSize, WhereWrapper wrapper);
    Page<T> pageQueryModels(int pageNumber, int pageSize, String select, String where, Object... params);

    Page<Map> pageQueryMaps(Pageable pageable, String select, String where, Object... params) ;
    Page<Map> pageQueryMaps(Pageable pageable, QueryWrapper wrapper) ;
    Page<Map> pageQueryMaps(QueryWrapper wrapper) ;
    Page<Map> pageSelectQueryMap(Pageable pageable,String select, String where, Object... params) ;

    <C>  Page<C> pageQueryColumns(Class<C> cClass, Pageable pageable, String select, String where, Object... params);
    <C>  Page<C> pageQueryColumns(Class<C> cClass, QueryWrapper wrapper);
    <C>  Page<C> pageQueryColumns(Class<C> cClass, Pageable pageable, QueryWrapper wrapper);


    Page pageQueryObjects(Pageable pageable, String select, String where, Object... params);
    Page pageQueryObjects(QueryWrapper wrapper);
    Page pageQueryObjects(Pageable pageable, QueryWrapper wrapper);

    //</editor-fold>
    //</editor-fold>
    //</editor-fold>

    //<editor-fold desc="wrapper update">
    int update(UpdateWrapper wrapper);
    //</editor-fold>
    //<editor-fold desc="wrapper delete">
    int delete(WhereWrapper wrapper);
    //</editor-fold>
    //<editor-fold desc="wrapper query">
    T getModel(WhereWrapper wrapper);
    List<T> findModels(WhereWrapper wrapper);
    Page<T> pageModels(WhereWrapper wrapper);
    <C> C getColumn(Class<C> cClass, QueryWrapper wrapper);
    <C> List<C> findColumns(Class<C> cClass, QueryWrapper wrapper);
    <C> Page<C> pageColumns(Class<C> cClass, QueryWrapper wrapper);
    Map getMap(QueryWrapper wrapper);
    List<Map> findMaps(QueryWrapper wrapper);
    Page<Map> pageMaps(QueryWrapper wrapper);
    //</editor-fold>

    //<editor-fold desc="exec page query">
    Page execObjectPageQuery(int pageNumber, int pageSize,String select, String where, Object... params);
    Page execObjectPageQuery( QueryWrapper wrapper);
    <C> Page<C> execColumnPageQuery(int pageNumber, int pageSize, Class<C> tClass, String select, String where, Object... params);
    <C> Page<C> execColumnPageQuery(Class<C> tClass, QueryWrapper wrapper);
    Page<Map> execMapPageQuery(int pageNumber,int pageSize,String select,String where, Object... params);
    Page<Map> execMapPageQuery(QueryWrapper wrapper);
    Page<T> execPageQuery(int pageNumber,int pageSize,String where, Object... params);
    Page<T> execPageQuery(QueryWrapper wrapper);
    //</editor-fold>
    //<editor-fold desc="exec wrapper">
    int execUpdate(UpdateWrapper wrapper);
    int execDelete(DeleteWrapper wrapper);
    Object execObjectQuery(QueryWrapper wrapper);
    List execListObjectQuery(QueryWrapper wrapper);
    <C> C execColumnQuery(Class<C> tClass, QueryWrapper wrapper);
    <C> List<C> execListColumnQuery(Class<C> tClass, QueryWrapper wrapper);
    Map execMapQuery(QueryWrapper wrapper);
    List<Map> execListMapQuery(QueryWrapper wrapper);
    T execModelQuery(QueryWrapper wrapper);
    List<T> execListModelQuery(QueryWrapper wrapper);
    //</editor-fold>
    //<editor-fold desc="exec sql">
    int execUpdate(String sql,Object... params);
    <C> C execColumnQuery(Class<C> tClass, String sql, Object... params);
    <C> List<C> execListColumnQuery(Class<C> tClass, String sql, Object... params);
    Object execObjectQuery(String sql, Object... params);
    List execListObjectQuery(String sql, Object... params);
    Map execMapQuery(String sql,Object... params);
    List<Map> execListMapQuery(String sql,Object... params);
    T execModelQuery(String sql, Object... params);
    List<T> execListModelQuery(String sql, Object... params);
    //</editor-fold>

}
