package cn.net.vidyo.framework.data.jpa.dao;

import cn.net.vidyo.framework.data.jpa.dao.sql.DeleteWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.QueryWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.UpdateWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.WhereWrapper;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.NoRepositoryBean;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@NoRepositoryBean
public interface CommonJpaRepository2<T, ID extends Serializable> extends JpaRepository<T, ID>, JpaSpecificationExecutor<T> {

    //<editor-fold desc="Extent">
    //<editor-fold desc="update">

//    <S extends T> S insert(S entity);
//    <S extends T> S update(S entity);
    int updateStatusById(ID id, Object value);


    int updateHiddenById(ID id, Object value);


    int updateColumnById(ID id, String fieldName, Object value);

    int increaseColumnValueById(ID id, String fieldName, int delta);

    //</editor-fold>
    //<editor-fold desc="delete">

    int deleteByIds(Iterable<ID> ids);

    int deleteByIds(ID ... ids);

    //</editor-fold>
    //<editor-fold desc="Query">


    //<editor-fold desc="get entity">

    T getById(ID id);

    ID getIdByEntity(T t);

    T getByEntityId(T t);

    int truncateParmeryKey(Class entityClass);

    int dropTable(Class entityClass);


    //</editor-fold>
    //<editor-fold desc="get column">

    Object getColumnById(ID id, String fieldName);
    String getStringColumnById(ID id, String fieldName) ;


    String getNameById(ID id);
    String getIdKeyById(ID id);
    String getCodeById(ID id);

    //</editor-fold>
    //<editor-fold desc="find list">

    List<T> findByIds(List<ID> ids);


    List<T> findByIds(ID[] ids);

    //</editor-fold>
    //</editor-fold>
    //</editor-fold>
    //<editor-fold desc="Base">
    //<editor-fold desc="update">
    int increaseColumn(String columName,int delta,String where,Object... params);
    int increaseColumn(String columName, int delta, WhereWrapper where);
    int updateColumn(String columName,Object value,String where,Object... params);
    int updateColumn(String columName, Object value, WhereWrapper where);
    int updateColumns(Map<String,Object> columnNameValues,String where,Object... params);
    int updateColumns(Map<String,Object> columnNameValues, WhereWrapper where);

    int update(UpdateWrapper wrapper);
    <S extends T> Iterable<S> batchUpdate(Iterable<S> var1);
    //</editor-fold>
    //<editor-fold desc="insert">
    <S extends T> S save(S entity);
    <S extends T> S saveAndFlush(S entity);
    <S extends T> Iterable<S> batchSave(Iterable<S> var1);
    //</editor-fold>
    //<editor-fold desc="delete">
    int deleteByWhere(String where,Object... params);
    int deleteByWhere(DeleteWrapper wrapper);
    int deleteByWhere(WhereWrapper where);
    //</editor-fold>
    //<editor-fold desc="query">

    //<editor-fold desc="query object">
    Object getColumn(String columnName, String where, Object... params);
    Object getColumn(String columnName, QueryWrapper wrapper);
    T getModel( String where, Object... params);
    T getModel(QueryWrapper wrapper);
    T getModel(WhereWrapper where);
    <C> C getColumn(Class<C> cClass,String columnName, String where, Object... params);
    <C> C getColumn(Class<C> cClass, QueryWrapper wrapper);
    Map getMap(String where, Object... params);
    Map getMap(QueryWrapper wrapper);
    Map getMap(WhereWrapper where);

    //</editor-fold>
    //<editor-fold desc="query object list">
    List<T> query(String where, Object... params);
    List<T> query(QueryWrapper wrapper);
    List<T> query(WhereWrapper where);
    <C> List<C> queryColumn(Class<C> cClass,String select,String where, Object... params);
    <C> List<C> queryColumn(Class<C> cClass, QueryWrapper wrapper);
    List<Map> queryMap(String where, Object... params);
    List<Map> queryMap(QueryWrapper wrapper);
    List<Map> queryMap(WhereWrapper where);

    //</editor-fold>
    //<editor-fold desc="query object page">
    Page<T> pageQuery(Pageable pageable, String where, Object... params) ;
    Page<T> pageQuery(Pageable pageable, QueryWrapper wrapper);
    Page<T> pageQuery(Pageable pageable, WhereWrapper wrapper);
    Page<T> pageSelectQuery(Pageable pageable, String select, String where, Object... params);

    Page<Map> pageQueryMap(Pageable pageable, String where, Object... params) ;
    Page<Map> pageQueryMap(Pageable pageable, QueryWrapper wrapper) ;
    Page<Map> pageQueryMap(Pageable pageable, WhereWrapper wrapper) ;
    Page<Map> pageSelectQueryMap(Pageable pageable,String select, String where, Object... params) ;

    <C>  Page<C> pageQueryColumn(Class<C> cClass, Pageable pageable,String select, String where, Object... params);
    <C>  Page<C> pageQueryColumn(Class<C> cClass, Pageable pageable, QueryWrapper wrapper);
    <C>  Page<C> pageSelectQueryColumn(Class<C> cClass, Pageable pageable, String select, String where, Object... params);

    Page<T> pageQuery(int pageNumber, int pageSize, String where, Object... params);
    Page<T> pageQuery(int pageNumber, int pageSize, QueryWrapper wrapper);
    Page<T> pageQuery(int pageNumber, int pageSize,WhereWrapper wrapper);
    Page<T> pageSelectQuery(int pageNumber, int pageSize,String select, String where, Object... params);
    //</editor-fold>
    //</editor-fold>
    //</editor-fold>

    /**
     * 获取数据类型
     *
     * @return d
     */
    Class<T> getEntityClass();

    /**
     * 执行ql语句
     *
     * @param qlString 基于jpa标准的jpql语句
     * @param values   jpql中的?参数值,单个参数值或者多个参数值
     * @return 返回执行后受影响的数据个数
     */
    int executeUpdate(String qlString, Object... values);

    <E> List<E> executeValueQueryBySql(
            Class<E> resultClass,
            String sql,
            Object ... params);

    <E> Page<E> executePageEntityQueryBySql(
            Pageable page,
            Class<E> resultClass,
            String sql,
            Object... params);

    List<Map> executeMapQueryBySql(
            String sql,
            Object... params);

    Page<Map> executePageMapQueryBySql(
            Pageable page,
            String sql,
            Object... params);
//
//    /**
//     * 执行ql语句
//     *
//     * @param qlString 基于jpa标准的jpql语句
//     * @param params   key表示jpql中参数变量名，value表示该参数变量值
//     * @return 返回执行后受影响的数据个数
//     */
//    int executeUpdate(String qlString, Map params);
//
//    /**
//     * 执行ql语句，可以是更新或者删除操作
//     *
//     * @param qlString 基于jpa标准的jpql语句
//     * @param values   jpql中的?参数值
//     * @return 返回执行后受影响的数据个数
//     * @throws Exception
//     */
//    int executeUpdate(String qlString, List<Object> values);
//
//    /**
//     * 执行原生SQL语句，可以是更新或者删除操作
//     *
//     * @param sql 标准的sql语句
//     * @return 返回执行后受影响的数据个数
//     * @throws Exception
//     */
//    int executeBySQL(String sql);
//
//    int executeBySQL(String sql, Object... values);
//
//    /**
//     * jpql查询语句
//     *
//     * @param qlString 基于jpa标准的jpql语句
//     * @param values   jpql中的?参数值,单个参数值或者多个参数值
//     * @return 返回查询的数据集合
//     */
//    List<T> findAll(String qlString, Object... values);
//
//    List<T> findAll(String qlString, Map params);
//
//    List<T> findAll(@Nullable List<Condition> conditions);
//
//    boolean support(String modelType);
    //<editor-fold desc="Description">
}
