package cn.net.vidyo.framework.data.jpa.dao.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class WhereWrapper implements Wrapper {
    String whereSql ="";
    List<Object> whereParams =new ArrayList<>();

    public WhereWrapper() {
    }

    public WhereWrapper(String where, Object... params) {
        this.whereSql = where;
        setWhereParams( params);
    }
    public void setWhereParams(Object... whereParams){
        if(whereParams ==null) return;
        for (Object param : whereParams) {
            this.whereParams.add(param);
        }
    }


    //<editor-fold desc="where">
    //<editor-fold desc="where default and">
    public WhereWrapper addIdWhere(Object id){
        return addIdWhere(SqlLogic.And,id);
    }
    public WhereWrapper addWhere(String columnName, Object value){
        return addWhere(SqlLogic.And,columnName,value);
    }
    public WhereWrapper addThanWhere(String columnName, Object value, SqlThan pattern) {
        return addThanWhere(SqlLogic.And,columnName,value,pattern);
    }

    public WhereWrapper addInWhere(String columnName, Collection values) {
        return addInWhere(SqlLogic.And,columnName,values);
    }

    public WhereWrapper addInWhere(String columnName, Object... values) {
        return addInWhere(SqlLogic.And,columnName,values);
    }

    public WhereWrapper addLikeWhere(String columnName, Object value, SqlLike pattern) {
        return addLikeWhere(SqlLogic.And,columnName,value,pattern);
    }

    //</editor-fold>
    //<editor-fold desc="where method">
    public WhereWrapper addEqualWhere(String columnName , Object value){
        return this.linkWhere(SqlLogic.And,columnName,value);
    }
    public WhereWrapper addOrderGroupBy(String sql, Object... params){
        if(sql==null || sql.length()==0 || this.whereSql.length()==0){
            return this;
        }
        StringBuilder builder= new StringBuilder(this.whereSql);
        builder.append(" ");
        builder.append(sql);
        this.whereSql =builder.toString();
        if(params!=null){
            for (Object param : params) {
                this.whereParams.add(param);
            }
        }
        return this;
    }
    public WhereWrapper addIdWhere(SqlLogic logic, Object id){
        return addWhere(logic,"id",id);
    }
    public WhereWrapper addWhere(SqlLogic logic, String columnName, Object value){
        return linkWhere(logic,columnName+"=?",value);
    }
    public WhereWrapper addThanWhere(SqlLogic logic, String columnName, Object value, SqlThan pattern) {
        StringBuilder sql;
        sql = new StringBuilder();
        sql.append(columnName);
        switch (pattern) {
            case THAN_GREATER:
                sql.append(" > ?");
                break;
            case THAN_LESS:
                sql.append(" < ?");
                break;
            case THAN_EQUAL:
                sql.append(" = ?");
                break;
            case THAN_NOT:
                sql.append(" <> ?");
                break;
            case THAN_GREATER_EQUAL:
                sql.append(" >= ?");
                break;
            case THAN_LESS_EQUAL:
                sql.append(" <= ?");
                break;
            default:
                throw new UnsupportedOperationException("pattern fail.");
        }
        return linkWhere(logic,sql.toString(),value);
    }

    public WhereWrapper addInWhere(SqlLogic logic, String columnName, Collection values) {
        StringBuilder sql = new StringBuilder();
        for (Object value : values) {
            if(sql.length()>0){
                sql.append(",");
            }
            sql.append("?");
        }
        sql.insert(0," IN (");
        sql.insert(0,columnName);
        sql.append(")");
        return linkWhere(logic, sql.toString(),values.toArray());
    }

    public WhereWrapper addInWhere(SqlLogic logic, String columnName, Object... values) {
        StringBuilder sql = new StringBuilder();
        for (Object value : values) {
            if(sql.length()>0){
                sql.append(",");
            }
            sql.append("?");
        }
        sql.insert(0," IN (");
        sql.insert(0,columnName);
        sql.append(")");
        return linkWhere(logic, sql.toString(),values);
    }

    public WhereWrapper addLikeWhere(SqlLogic logic, String columnName, Object value, SqlLike pattern) {
        StringBuilder sql = new StringBuilder();
        sql.append(columnName);
        sql.append(" LIKE ? ");
        switch (pattern){
            case LIKE_PREFIX:
                value="%"+value;
                break;
            case LIKE_POSTFIX:
                value=value+"%";
                break;
            case LIKE_KEYWORD:
                value="%"+value+"%";
                break;
        }
        return linkWhere(logic, sql.toString(),value);
    }

    //</editor-fold>
    //<editor-fold desc="where base method">
    public WhereWrapper linkWhere(SqlLogic logic, String where, Object... params){
        return linkWhere(logic,new WhereWrapper(where,params));
    }
    public WhereWrapper linkWhere(SqlLogic logic, WhereWrapper where){
        if(where.whereSql.length()==0){
            return this;
        }
        if(this.whereSql.length()==0){
            this.whereSql =where.getWhereSql();
            this.whereParams =where.getWhereParams();
            return this;
        }
        StringBuilder sql= new StringBuilder();
        sql.append(this.whereSql);
        switch (logic){
            case And:
                sql.append(" AND ");
                break;
            case Or:
                sql.append(" OR ");
                break;
            case Not:
                sql.append(" NOT ");
                break;
        }
        sql.append(where.whereSql);
        this.whereSql =sql.toString();
        if(where.whereParams.size()>0){
            for (Object param : where.whereParams) {
                this.whereParams.add(param);
            }
        }
        return this;
    }
    public WhereWrapper combileWhere(SqlLogic logic, String where, Object... params){
        return combileWhere(logic,new WhereWrapper(where,params));
    }
    public WhereWrapper combileWhere(SqlLogic logic, WhereWrapper where){
        if(where.whereSql.length()==0){
            return this;
        }
        if(this.whereSql.length()==0){
            this.whereSql =where.getWhereSql();
            this.whereParams =where.getWhereParams();
            return this;
        }
        StringBuilder sql= new StringBuilder();
        sql.append(" ( ");
        sql.append(this.whereSql);
        sql.append(" ) ");
        switch (logic){
            case And:
                sql.append(" AND (");
                break;
            case Or:
                sql.append(" OR (");
                break;
            case Not:
                sql.append(" NOT (");
                break;
        }
        sql.append(where.whereSql);
        sql.append(" )");
        this.whereSql =sql.toString();
        if(where.whereParams.size()>0){
            for (Object param : where.whereParams) {
                this.whereParams.add(param);
            }
        }
        return this;
    }
    //</editor-fold>
    //</editor-fold>
    //<editor-fold desc="where">
    //<editor-fold desc="where default and">
    public WhereWrapper edId(Object id){
        return eqId(true,SqlLogic.And,id);
    }
    public WhereWrapper eqAll(Map<String,Object> params){
        return eqAll(true,SqlLogic.And,params);
    }
    public WhereWrapper eq(String columnName, Object value){
        return eq(true,SqlLogic.And,columnName,value);
    }
    public WhereWrapper ne(String columnName, Object value) {
        return ne(true,SqlLogic.And,columnName,value);
    }
    public WhereWrapper gt(String columnName, Object value) {
        return gt(true,SqlLogic.And,columnName,value);
    }
    public WhereWrapper ge(String columnName, Object value) {
        return ge(true,SqlLogic.And,columnName,value);
    }
    public WhereWrapper lt(String columnName, Object value) {
        return lt(true,SqlLogic.And,columnName,value);
    }
    public WhereWrapper le(String columnName, Object value) {
        return le(true,SqlLogic.And,columnName,value);
    }
    public WhereWrapper than(String columnName, Object value, SqlThan pattern) {
        return than(true,SqlLogic.And,columnName,value,pattern);
    }
    public WhereWrapper inId(Collection values) {
        return inId(true,values);
    }
    public WhereWrapper inId(Object... values) {
        return inId(true,values);
    }
    public WhereWrapper in(String columnName, Collection values) {
        return in(true,SqlLogic.And,columnName,values);
    }
    public WhereWrapper in(String columnName, Object... values) {
        return in(true,SqlLogic.And,columnName,values);
    }
    public WhereWrapper like(String columnName, Object value, SqlLike pattern) {
        return like(true,SqlLogic.And,columnName,value,pattern);
    }
    public WhereWrapper likeLeft(String columnName, Object value){
        return likeLeft(true,SqlLogic.And,columnName,value);
    }
    public WhereWrapper likeRight(String columnName, Object value){
        return likeRight(true,SqlLogic.And,columnName,value);
    }
    public WhereWrapper notLike(String columnName, Object value, SqlLike pattern) {
        return notLike(true,SqlLogic.And,columnName,value,pattern);
    }
    //</editor-fold>
    //<editor-fold desc="where method">
    public WhereWrapper eqId(SqlLogic logic, Object id){
        return eq(true,logic,"id",id);
    }
    public WhereWrapper eqAll(SqlLogic logic, Map<String,Object> params){
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            eq(true,logic,entry.getKey(),entry.getValue());
        }
        return this;
    }
    public WhereWrapper eq(SqlLogic logic, String columnName, Object value){
        return linkWhere(true,logic,columnName+"=?",value);
    }
    public WhereWrapper ne(SqlLogic logic, String columnName, Object value){
        return than(true,logic,columnName,value,SqlThan.THAN_NOT);
    }
    public WhereWrapper gt(SqlLogic logic, String columnName, Object value){
        return than(true,logic,columnName,value,SqlThan.THAN_GREATER);
    }
    public WhereWrapper ge(SqlLogic logic, String columnName, Object value){
        return than(true,logic,columnName,value,SqlThan.THAN_GREATER_EQUAL);
    }
    public WhereWrapper lt(SqlLogic logic, String columnName, Object value){
        return than(true,logic,columnName,value,SqlThan.THAN_LESS);
    }
    public WhereWrapper le(SqlLogic logic, String columnName, Object value){
        return than(true,logic,columnName,value,SqlThan.THAN_LESS_EQUAL);
    }
    public WhereWrapper than(SqlLogic logic, String columnName, Object value, SqlThan pattern) {
        StringBuilder sql;
        sql = new StringBuilder();
        sql.append(columnName);
        switch (pattern) {
            case THAN_GREATER:
                sql.append(" > ?");
                break;
            case THAN_LESS:
                sql.append(" < ?");
                break;
            case THAN_EQUAL:
                sql.append(" = ?");
                break;
            case THAN_NOT:
                sql.append(" <> ?");
                break;
            case THAN_GREATER_EQUAL:
                sql.append(" >= ?");
                break;
            case THAN_LESS_EQUAL:
                sql.append(" <= ?");
                break;
            default:
                throw new UnsupportedOperationException("pattern fail.");
        }
        return linkWhere(true,logic,sql.toString(),value);
    }

    public WhereWrapper in(SqlLogic logic, String columnName, Collection values) {
        StringBuilder sql = new StringBuilder();
        for (Object value : values) {
            if(sql.length()>0){
                sql.append(",");
            }
            sql.append("?");
        }
        sql.insert(0," IN (");
        sql.insert(0,columnName);
        sql.append(")");
        return linkWhere(true,logic, sql.toString(),values.toArray());
    }
    public WhereWrapper in(SqlLogic logic, String columnName, Object... values) {
        StringBuilder sql = new StringBuilder();
        for (Object value : values) {
            if(sql.length()>0){
                sql.append(",");
            }
            sql.append("?");
        }
        sql.insert(0," IN (");
        sql.insert(0,columnName);
        sql.append(")");
        return linkWhere(true,logic, sql.toString(),values);
    }
    public WhereWrapper likeLeft(SqlLogic logic, String columnName, Object value){
        return like(true,logic,columnName,value,SqlLike.LIKE_PREFIX);
    }
    public WhereWrapper likeRight(SqlLogic logic, String columnName, Object value){
        return like(true,logic,columnName,value,SqlLike.LIKE_POSTFIX);
    }
    public WhereWrapper like(SqlLogic logic, String columnName, Object value, SqlLike pattern) {
        StringBuilder sql = new StringBuilder();
        sql.append(columnName);
        sql.append(" LIKE ? ");
        switch (pattern){
            case LIKE_PREFIX:
                value="%"+value;
                break;
            case LIKE_POSTFIX:
                value=value+"%";
                break;
            case LIKE_KEYWORD:
                value="%"+value+"%";
                break;
        }
        return linkWhere(true,logic, sql.toString(),value);
    }
    public WhereWrapper notLike(SqlLogic logic, String columnName, Object value, SqlLike pattern) {
        StringBuilder sql = new StringBuilder();
        sql.append(columnName);
        sql.append(" NOT LIKE ? ");
        switch (pattern){
            case LIKE_PREFIX:
                value="%"+value;
                break;
            case LIKE_POSTFIX:
                value=value+"%";
                break;
            case LIKE_KEYWORD:
                value="%"+value+"%";
                break;
        }
        return linkWhere(true,logic, sql.toString(),value);
    }

    //</editor-fold>
    //</editor-fold>
    //<editor-fold desc="where condition">
    //<editor-fold desc="where default and">
    public WhereWrapper edId(boolean condition, Object id){
        return eqId(condition,SqlLogic.And,id);
    }
    public WhereWrapper eqAll(boolean condition, Map<String,Object> params){
        return eqAll(condition,SqlLogic.And,params);
    }
    public WhereWrapper eq(boolean condition, String columnName, Object value){
        return eq(condition,SqlLogic.And,columnName,value);
    }
    public WhereWrapper ne(boolean condition, String columnName, Object value) {
        return ne(condition,SqlLogic.And,columnName,value);
    }
    public WhereWrapper gt(boolean condition, String columnName, Object value) {
        return gt(condition,SqlLogic.And,columnName,value);
    }
    public WhereWrapper ge(boolean condition, String columnName, Object value) {
        return ge(condition,SqlLogic.And,columnName,value);
    }
    public WhereWrapper lt(boolean condition, String columnName, Object value) {
        return lt(condition,SqlLogic.And,columnName,value);
    }
    public WhereWrapper le(boolean condition, String columnName, Object value) {
        return le(condition,SqlLogic.And,columnName,value);
    }
    public WhereWrapper than(boolean condition, String columnName, Object value, SqlThan pattern) {
        return than(condition,SqlLogic.And,columnName,value,pattern);
    }
    public WhereWrapper in(boolean condition, String columnName, Collection values) {
        return in(condition,SqlLogic.And,columnName,values);
    }
    public WhereWrapper inId(boolean condition, Collection values) {
        return in(condition,SqlLogic.And,"id",values);
    }
    public WhereWrapper inId(boolean condition, Object... values) {
        return in(condition,SqlLogic.And,"id",values);
    }
    public WhereWrapper in(boolean condition, String columnName, Object... values) {
        return in(condition,SqlLogic.And,columnName,values);
    }
    public WhereWrapper like(boolean condition, String columnName, Object value, SqlLike pattern) {
        return like(condition,SqlLogic.And,columnName,value,pattern);
    }
    public WhereWrapper likeLeft(boolean condition, String columnName, Object value){
        return likeLeft(condition,SqlLogic.And,columnName,value);
    }
    public WhereWrapper likeRight(boolean condition, String columnName, Object value){
        return likeRight(condition,SqlLogic.And,columnName,value);
    }
    public WhereWrapper notLike(boolean condition, String columnName, Object value, SqlLike pattern) {
        return notLike(condition,SqlLogic.And,columnName,value,pattern);
    }
    //</editor-fold>
    //<editor-fold desc="where method">
    public WhereWrapper eqId(boolean condition, SqlLogic logic, Object id){
        return eq(condition,logic,"id",id);
    }
    public WhereWrapper eqAll(boolean condition, SqlLogic logic, Map<String,Object> params){
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            eq(condition,logic,entry.getKey(),entry.getValue());
        }
        return this;
    }
    public WhereWrapper eq(boolean condition, SqlLogic logic, String columnName, Object value){
        return linkWhere(condition,logic,columnName+"=?",value);
    }
    public WhereWrapper ne(boolean condition, SqlLogic logic, String columnName, Object value){
        return than(condition,logic,columnName,value,SqlThan.THAN_NOT);
    }
    public WhereWrapper gt(boolean condition, SqlLogic logic, String columnName, Object value){
        return than(condition,logic,columnName,value,SqlThan.THAN_GREATER);
    }
    public WhereWrapper ge(boolean condition, SqlLogic logic, String columnName, Object value){
        return than(condition,logic,columnName,value,SqlThan.THAN_GREATER_EQUAL);
    }
    public WhereWrapper lt(boolean condition, SqlLogic logic, String columnName, Object value){
        return than(condition,logic,columnName,value,SqlThan.THAN_LESS);
    }
    public WhereWrapper le(boolean condition, SqlLogic logic, String columnName, Object value){
        return than(condition,logic,columnName,value,SqlThan.THAN_LESS_EQUAL);
    }
    public WhereWrapper than(boolean condition, SqlLogic logic, String columnName, Object value, SqlThan pattern) {
        StringBuilder sql;
        sql = new StringBuilder();
        sql.append(columnName);
        switch (pattern) {
            case THAN_GREATER:
                sql.append(" > ?");
                break;
            case THAN_LESS:
                sql.append(" < ?");
                break;
            case THAN_EQUAL:
                sql.append(" = ?");
                break;
            case THAN_NOT:
                sql.append(" <> ?");
                break;
            case THAN_GREATER_EQUAL:
                sql.append(" >= ?");
                break;
            case THAN_LESS_EQUAL:
                sql.append(" <= ?");
                break;
            default:
                throw new UnsupportedOperationException("pattern fail.");
        }
        return linkWhere(condition,logic,sql.toString(),value);
    }

    public WhereWrapper in(boolean condition, SqlLogic logic, String columnName, Collection values) {
        StringBuilder sql = new StringBuilder();
        for (Object value : values) {
            if(sql.length()>0){
                sql.append(",");
            }
            sql.append("?");
        }
        sql.insert(0," IN (");
        sql.insert(0,columnName);
        sql.append(")");
        return linkWhere(condition,logic, sql.toString(),values.toArray());
    }
    public WhereWrapper in(boolean condition, SqlLogic logic, String columnName, Object... values) {
        StringBuilder sql = new StringBuilder();
        for (Object value : values) {
            if(sql.length()>0){
                sql.append(",");
            }
            sql.append("?");
        }
        sql.insert(0," IN (");
        sql.insert(0,columnName);
        sql.append(")");
        return linkWhere(condition,logic, sql.toString(),values);
    }
    public WhereWrapper likeLeft(boolean condition, SqlLogic logic, String columnName, Object value){
        return like(condition,logic,columnName,value,SqlLike.LIKE_PREFIX);
    }
    public WhereWrapper likeRight(boolean condition, SqlLogic logic, String columnName, Object value){
        return like(condition,logic,columnName,value,SqlLike.LIKE_POSTFIX);
    }
    public WhereWrapper like(boolean condition, SqlLogic logic, String columnName, Object value, SqlLike pattern) {
        StringBuilder sql = new StringBuilder();
        sql.append(columnName);
        sql.append(" LIKE ? ");
        switch (pattern){
            case LIKE_PREFIX:
                value="%"+value;
                break;
            case LIKE_POSTFIX:
                value=value+"%";
                break;
            case LIKE_KEYWORD:
                value="%"+value+"%";
                break;
        }
        return linkWhere(condition,logic, sql.toString(),value);
    }
    public WhereWrapper notLike(boolean condition, SqlLogic logic, String columnName, Object value, SqlLike pattern) {
        StringBuilder sql = new StringBuilder();
        sql.append(columnName);
        sql.append(" NOT LIKE ? ");
        switch (pattern){
            case LIKE_PREFIX:
                value="%"+value;
                break;
            case LIKE_POSTFIX:
                value=value+"%";
                break;
            case LIKE_KEYWORD:
                value="%"+value+"%";
                break;
        }
        return linkWhere(condition,logic, sql.toString(),value);
    }

    //</editor-fold>
    //<editor-fold desc="where base method">
    public WhereWrapper groupBy(String sql, Object... params){
        if(sql==null || sql.length()==0 || this.whereSql.length()==0){
            return this;
        }
        StringBuilder builder= new StringBuilder(this.whereSql);
        builder.append(" ");
        builder.append(sql);
        this.whereSql =builder.toString();
        if(params!=null){
            for (Object param : params) {
                this.whereParams.add(param);
            }
        }
        return this;
    }
    public WhereWrapper linkWhere(boolean condition, SqlLogic logic, String where, Object... params){
        return linkWhere(condition,logic,new WhereWrapper(where,params));
    }
    public WhereWrapper linkWhere(boolean condition, SqlLogic logic, WhereWrapper where){
        if(!condition) return this;
        if(where.whereSql.length()==0){
            return this;
        }
        if(this.whereSql.length()==0){
            this.whereSql =where.getWhereSql();
            this.whereParams =where.getWhereParams();
            return this;
        }
        StringBuilder sql= new StringBuilder();
        sql.append(this.whereSql);
        switch (logic){
            case And:
                sql.append(" AND ");
                break;
            case Or:
                sql.append(" OR ");
                break;
            case Not:
                sql.append(" NOT ");
                break;
        }
        sql.append(where.whereSql);
        this.whereSql =sql.toString();
        if(where.whereParams.size()>0){
            for (Object param : where.whereParams) {
                this.whereParams.add(param);
            }
        }
        return this;
    }
    public WhereWrapper combileWhere(boolean condition, SqlLogic logic, String where, Object... params){
        return combileWhere(condition,logic,new WhereWrapper(where,params));
    }
    public WhereWrapper combileWhere(boolean condition, SqlLogic logic, WhereWrapper where){
        if(!condition) return this;
        if(where.getWhereSql().length()==0){
            return this;
        }
        if(this.whereSql.length()==0){
            this.whereSql =where.getWhereSql();
            this.whereParams =where.getWhereParams();
            return this;
        }
        StringBuilder sql= new StringBuilder();
        sql.append(" ( ");
        sql.append(this.whereSql);
        sql.append(" ) ");
        switch (logic){
            case And:
                sql.append(" AND (");
                break;
            case Or:
                sql.append(" OR (");
                break;
            case Not:
                sql.append(" NOT (");
                break;
        }
        sql.append(where.whereSql);
        sql.append(" )");
        this.whereSql =sql.toString();
        if(where.whereParams.size()>0){
            for (Object param : where.whereParams) {
                this.whereParams.add(param);
            }
        }
        return this;
    }
    //</editor-fold>
    //</editor-fold>

    public void addParam(Object value){
        this.whereParams.add(value);
    }
    public void addParam(Object... values){
        for (Object value : values) {
            addParam(value);
        }
    }
    public void addParam(Collection values){
        for (Object value : values) {
            addParam(value);
        }
    }

    public String getWhereSql() {
        return whereSql;
    }

    public void setWhereSql(String whereSql) {
        this.whereSql = whereSql;
    }

    public List<Object> getWhereParams() {
        return whereParams;
    }

    public void setParams(List<Object> params) {
        this.whereParams = params;
    }

    @Override
    public String getSql() {
        return getWhereSql();
    }

    @Override
    public List getSqlParams() {
        return getWhereParams();
    }
}
