/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.data.jpa.dao.support;

import cn.net.vidyo.framework.common.util.ValueUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyChainedImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyFieldImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnToBean
extends AliasedTupleSubsetResultTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ColumnToBean.class);
    private static final String STR_UNDERLINE = "_";
    private static final String STR_EMPTY = "";
    private final Class resultClass;
    private boolean isInitialized;
    private String[] aliases;
    private Setter[] setters;

    public ColumnToBean(Class resultClass) {
        if (resultClass == null) {
            throw new IllegalArgumentException("resultClass cannot be null");
        }
        this.isInitialized = false;
        this.resultClass = resultClass;
    }

    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        Object result;
        try {
            if (!this.isInitialized) {
                this.initialize(aliases);
            } else {
                this.check(aliases);
            }
            result = this.resultClass.newInstance();
            for (int i = 0; i < aliases.length; ++i) {
                Class<?> tupleClass;
                if (this.setters[i] == null || tuple[i] == null) continue;
                Method method = this.setters[i].getMethod();
                if (method == null) {
                    throw new RuntimeException("Could not find DB Column:" + aliases[i] + " Setter Method!");
                }
                Class<?> param = method.getParameterTypes()[0];
                if (!param.equals(tupleClass = tuple[i].getClass())) {
                    if (param.isEnum()) {
                        ?[] enumConstants = param.getEnumConstants();
                        Enum v = null;
                        if (Integer.class.isAssignableFrom(tupleClass)) {
                            int iv = (Integer)tuple[i];
                            v = (Enum)enumConstants[iv];
                        } else {
                            for (Object enumConstant : enumConstants) {
                                Enum e = (Enum)enumConstant;
                                if (!e.name().equals(tuple[i].toString())) continue;
                                v = e;
                                break;
                            }
                        }
                        this.setters[i].set(result, v, null);
                        continue;
                    }
                    if (Number.class.isAssignableFrom(tupleClass)) {
                        Number num = (Number)tuple[i];
                        if (Long.class.equals(param) || Long.TYPE.equals(param)) {
                            this.setters[i].set(result, (Object)num.longValue(), null);
                            continue;
                        }
                        if (Integer.class.equals(param) || Integer.TYPE.equals(param)) {
                            this.setters[i].set(result, (Object)num.intValue(), null);
                            continue;
                        }
                        if (Boolean.class.equals(param) || Boolean.TYPE.equals(param)) {
                            this.setters[i].set(result, (Object)(num.intValue() == 1 ? 1 : 0), null);
                            continue;
                        }
                        if (Float.class.equals(param) || Float.TYPE.equals(param)) {
                            this.setters[i].set(result, (Object)Float.valueOf(num.floatValue()), null);
                            continue;
                        }
                        if (Double.class.equals(param) || Double.TYPE.equals(param)) {
                            this.setters[i].set(result, (Object)num.doubleValue(), null);
                            continue;
                        }
                        if (Short.class.equals(param) || Short.TYPE.equals(param)) {
                            this.setters[i].set(result, (Object)num.shortValue(), null);
                            continue;
                        }
                        if (BigDecimal.class.equals(param)) {
                            this.setters[i].set(result, (Object)num, null);
                            continue;
                        }
                        throw new RuntimeException("Unsupported type conversion \uff1a" + tuple[i].getClass());
                    }
                    if (param.isAssignableFrom(tupleClass)) {
                        this.setters[i].set(result, tuple[i], null);
                        continue;
                    }
                    if (Boolean.class.isAssignableFrom(tupleClass)) {
                        this.setters[i].set(result, (Object)ValueUtil.toBoolean((Object)tuple[i]), null);
                        continue;
                    }
                    if (Character.class.isAssignableFrom(tupleClass)) {
                        this.setters[i].set(result, (Object)Character.valueOf(ValueUtil.toChar((Object)tuple[i])), null);
                        continue;
                    }
                    if (tuple[i] instanceof Clob) {
                        Clob clob = (Clob)tuple[i];
                        this.setters[i].set(result, (Object)ColumnToBean.clobToString(clob), null);
                        continue;
                    }
                    throw new RuntimeException("Unsupported type conversion \uff1a" + tuple[i].getClass());
                }
                this.setters[i].set(result, tuple[i], null);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("\u4e0d\u80fd\u5b9e\u4f8b\u5316\u7c7b\uff1a" + this.resultClass.getName(), (Throwable)e);
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        return result;
    }

    private void initialize(String[] aliases) {
        PropertyAccessStrategyChainedImpl propertyAccessStrategy = new PropertyAccessStrategyChainedImpl(new PropertyAccessStrategy[]{PropertyAccessStrategyBasicImpl.INSTANCE, PropertyAccessStrategyFieldImpl.INSTANCE, PropertyAccessStrategyMapImpl.INSTANCE});
        this.aliases = new String[aliases.length];
        this.setters = new Setter[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (alias == null) continue;
            this.aliases[i] = alias;
            this.setters[i] = this.getSetterByColumnName(alias, propertyAccessStrategy);
        }
        this.isInitialized = true;
    }

    private Setter getSetterByColumnName(String alias, PropertyAccessStrategyChainedImpl propertyAccessStrategy) {
        List<Field> fields = this.getClassDeclaredFields(this.resultClass, true);
        if (fields == null || fields.size() == 0) {
            throw new RuntimeException("POJO [" + this.resultClass.getName() + "] does not contain any attributes.");
        }
        String proName = alias.replaceAll(STR_UNDERLINE, STR_EMPTY).toLowerCase();
        String lowerAlias = alias.toLowerCase();
        for (Field field : fields) {
            String fieldName = field.getName().toLowerCase();
            boolean match = fieldName.equals(lowerAlias) || fieldName.equals(proName);
            if (!match) continue;
            return propertyAccessStrategy.buildPropertyAccess(this.resultClass, field.getName()).getSetter();
        }
        throw new RuntimeException("Could not find DB Column[" + alias + "] Java POJO property!");
    }

    List<Field> getClassDeclaredFields(Class cClass, boolean includeSuper) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        if (cClass == null) {
            return list;
        }
        if (cClass == Object.class) {
            return list;
        }
        for (Field field : fields = cClass.getDeclaredFields()) {
            list.add(field);
        }
        if (includeSuper) {
            List<Field> list1 = this.getClassDeclaredFields(cClass.getSuperclass(), includeSuper);
            list.addAll(list1);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String clobToString(Clob clob) {
        String reString = STR_EMPTY;
        Reader is = null;
        try {
            String s;
            is = clob.getCharacterStream();
            BufferedReader br = new BufferedReader(is);
            StringBuilder sb = new StringBuilder();
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
            reString = sb.toString();
        }
        catch (IOException | SQLException e) {
            logger.error("Get Clob Content Failed", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("I/O Exception", (Throwable)e);
                }
            }
        }
        return reString;
    }

    private void check(String[] aliases) {
        if (!Arrays.equals(aliases, this.aliases)) {
            throw new IllegalStateException("aliases are different from what is cached; aliases=" + Arrays.asList(aliases) + " cached=" + Arrays.asList(this.aliases));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ColumnToBean that = (ColumnToBean)((Object)o);
        return this.resultClass.equals(that.resultClass) && Arrays.equals(this.aliases, that.aliases);
    }

    public int hashCode() {
        int result = this.resultClass.hashCode();
        result = 31 * result + (this.aliases != null ? Arrays.hashCode(this.aliases) : 0);
        return result;
    }
}

