/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.dylink.mongdb.dao;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class MongodbEntityDao<MODEL> {
    @Autowired
    private MongoTemplate mongoTemplate;

    public Object save(Object model) {
        return this.mongoTemplate.save(model);
    }

    public Object insert(Object model) {
        return this.mongoTemplate.insert(model);
    }

    public Object update(Object model) {
        return this.mongoTemplate.save(model);
    }

    public <MODEL> List<MODEL> findAll(Class<MODEL> modelClass) {
        return this.mongoTemplate.findAll(modelClass);
    }

    public <MODEL> MODEL getByQuery(Query query, Class<MODEL> modelClass) {
        return (MODEL)this.mongoTemplate.findOne(query, modelClass);
    }

    public <MODEL> List<MODEL> findByQuery(Query query, Class<MODEL> modelClass) {
        return this.mongoTemplate.find(query, modelClass);
    }

    public <MODEL> MODEL getByQuery(Query query, Class<MODEL> modelClass, boolean exclude, List<String> fields) {
        Field findFields = query.fields();
        if (fields != null && fields.size() > 0) {
            if (exclude) {
                fields.forEach(arg_0 -> ((Field)findFields).exclude(arg_0));
            } else {
                fields.forEach(arg_0 -> ((Field)findFields).include(arg_0));
            }
        }
        return (MODEL)this.mongoTemplate.findOne(query, modelClass);
    }

    public <MODEL> List<MODEL> findByQuery(Query query, Class<MODEL> modelClass, boolean exclude, List<String> fields) {
        Field findFields = query.fields();
        if (fields != null && fields.size() > 0) {
            if (exclude) {
                fields.forEach(arg_0 -> ((Field)findFields).exclude(arg_0));
            } else {
                fields.forEach(arg_0 -> ((Field)findFields).include(arg_0));
            }
        }
        return this.mongoTemplate.find(query, modelClass);
    }

    public <COLUMN> List<COLUMN> findColumnByQuery(Query query, Class<COLUMN> modelClass) {
        Field findFields = query.fields();
        return this.mongoTemplate.find(query, modelClass);
    }

    public <COLUMN> List<COLUMN> findColumnByQuery(Query query, Class<COLUMN> columnClass, String columName) {
        Field findFields = query.fields();
        findFields.include(columName);
        return this.mongoTemplate.find(query, columnClass);
    }

    public <RESULT> List<RESULT> findColumnByQuery(Query query, Class<RESULT> modelClass, boolean exclude, List<String> fields) {
        Field findFields = query.fields();
        if (fields != null && fields.size() > 0) {
            if (exclude) {
                fields.forEach(arg_0 -> ((Field)findFields).exclude(arg_0));
            } else {
                fields.forEach(arg_0 -> ((Field)findFields).include(arg_0));
            }
        }
        return this.mongoTemplate.find(query, modelClass);
    }

    public <MODEL> Page<MODEL> pageByQuery(Query query, Class<MODEL> modelClass, int pageNumber, int pageSize) {
        long count = this.mongoTemplate.count(query, modelClass);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        int skip = (pageNumber - 1) * pageSize;
        query.skip((long)skip);
        query.limit(pageSize);
        List models = this.mongoTemplate.find(query, modelClass);
        return new PageImpl(models, (Pageable)pageable, count);
    }

    public <MODEL> Page<MODEL> pageByQuery(Query query, Class<MODEL> modelClass, boolean exclude, List<String> fields, int pageNumber, int pageSize) {
        long count = this.mongoTemplate.count(query, modelClass);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        int skip = (pageNumber - 1) * pageSize;
        query.skip((long)skip);
        query.limit(pageSize);
        Field findFields = query.fields();
        if (fields != null && fields.size() > 0) {
            if (exclude) {
                fields.forEach(arg_0 -> ((Field)findFields).exclude(arg_0));
            } else {
                fields.forEach(arg_0 -> ((Field)findFields).include(arg_0));
            }
        }
        List models = this.mongoTemplate.find(query, modelClass);
        return new PageImpl(models, (Pageable)pageable, count);
    }

    public <COLUMN> Page<COLUMN> pageColumnByQuery(Query query, Class<COLUMN> columnClass, String columnName, int pageNumber, int pageSize) {
        long count = this.mongoTemplate.count(query, columnClass);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        int skip = (pageNumber - 1) * pageSize;
        query.skip((long)skip);
        query.limit(pageSize);
        Field findFields = query.fields();
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(columnName);
        fields.forEach(arg_0 -> ((Field)findFields).include(arg_0));
        List models = this.mongoTemplate.find(query, columnClass);
        return new PageImpl(models, (Pageable)pageable, count);
    }

    public <RESULT> Page<RESULT> pageColumnByQuery(Query query, Class<RESULT> resultClass, boolean exclude, List<String> fields, int pageNumber, int pageSize) {
        long count = this.mongoTemplate.count(query, resultClass);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        int skip = (pageNumber - 1) * pageSize;
        query.skip((long)skip);
        query.limit(pageSize);
        Field findFields = query.fields();
        if (fields != null && fields.size() > 0) {
            if (exclude) {
                fields.forEach(arg_0 -> ((Field)findFields).exclude(arg_0));
            } else {
                fields.forEach(arg_0 -> ((Field)findFields).include(arg_0));
            }
        }
        List models = this.mongoTemplate.find(query, resultClass);
        return new PageImpl(models, (Pageable)pageable, count);
    }

    public long updateByQuery(Query query, Update update, Class modelClass) {
        UpdateResult updateResult = this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, modelClass);
        return updateResult.getMatchedCount();
    }

    public long deleteByQuery(Query query, Class modelClass) {
        DeleteResult remove = this.mongoTemplate.remove(query, modelClass);
        return remove.getDeletedCount();
    }
}

