/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.dylink.mongdb.service;

import cn.hutool.core.bean.BeanUtil;
import cn.net.vidyo.dylink.mongdb.dao.MongodbEntityDao;
import cn.net.vidyo.dylink.mongdb.service.IMongodbEntityService;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class MongodbEntityService<MODEL>
implements IMongodbEntityService<MODEL> {
    @Autowired
    protected MongodbEntityDao entityDao;
    protected Class<MODEL> modelClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @Override
    public MODEL getById(Serializable id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        return this.getByQuery(query);
    }

    @Override
    public MODEL save(MODEL model) {
        return (MODEL)this.entityDao.save(model);
    }

    public MODEL insert(MODEL model) {
        return (MODEL)this.entityDao.insert(model);
    }

    @Override
    public MODEL update(MODEL model) {
        return this.updateById(model);
    }

    @Override
    public MODEL updateById(MODEL model) {
        Object value = BeanUtil.getFieldValue(model, (String)"id");
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"id").is(value));
        return (MODEL)this.entityDao.update(model);
    }

    @Override
    public long deleteById(Serializable id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        return this.deleteByQuery(query);
    }

    @Override
    public List<MODEL> findAll() {
        return this.entityDao.findAll(this.modelClass);
    }

    @Override
    public List<MODEL> findByIds(List ids) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"id").in((Collection)ids));
        return this.findByQuery(query);
    }

    protected MODEL getByQuery(Query query, boolean exclude, List<String> fields) {
        return this.entityDao.getByQuery(query, this.modelClass, exclude, fields);
    }

    protected List<MODEL> findByQuery(Query query, boolean exclude, List<String> fields) {
        return this.entityDao.findByQuery(query, this.modelClass, exclude, fields);
    }

    protected <COLUMN> List<COLUMN> findColumnByQuery(Query query, Class<COLUMN> columnClass, String columName) {
        return this.entityDao.findColumnByQuery(query, this.modelClass, columName);
    }

    protected <RESULT> List<RESULT> findColumnByQuery(Query query, Class<RESULT> modelClass, boolean exclude, List<String> fields) {
        return this.entityDao.findColumnByQuery(query, modelClass, exclude, fields);
    }

    protected Page<MODEL> pageByQuery(Query query, boolean exclude, List<String> fields, int pageNumber, int pageSize) {
        return this.entityDao.pageByQuery(query, this.modelClass, exclude, fields, pageNumber, pageSize);
    }

    protected <COLUMN> Page<COLUMN> pageColumnByQuery(Query query, Class<COLUMN> columnClass, String columnName, int pageNumber, int pageSize) {
        return this.entityDao.pageColumnByQuery(query, columnClass, columnName, pageNumber, pageSize);
    }

    protected <RESULT> Page<RESULT> pageColumnByQuery(Query query, Class<RESULT> resultClass, boolean exclude, List<String> fields, int pageNumber, int pageSize) {
        return this.entityDao.pageColumnByQuery(query, resultClass, exclude, fields, pageNumber, pageSize);
    }

    protected MODEL getByQuery(Query query) {
        return this.entityDao.getByQuery(query, this.modelClass);
    }

    protected List<MODEL> findByQuery(Query query) {
        return this.entityDao.findByQuery(query, this.modelClass);
    }

    protected <MODEL> Page<MODEL> pageByQuery(Query query, int pageNumber, int pageSize) {
        return this.entityDao.pageByQuery(query, this.modelClass, pageNumber, pageSize);
    }

    protected long updateByQuery(Query query, Update update) {
        return this.entityDao.updateByQuery(query, update, this.modelClass);
    }

    protected long deleteByQuery(Query query) {
        return this.entityDao.deleteByQuery(query, this.modelClass);
    }
}

