/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.dylink.mybatis.plus.config;

import cn.net.vidyo.dylink.mybatis.plus.enums.BusinessExceptionEnum;
import cn.net.vidyo.dylink.mybatis.plus.exception.BusinessException;
import cn.net.vidyo.dylink.mybatis.plus.util.ErrorUtil;
import cn.net.vidyo.framework.common.domain.IErrorEnum;
import cn.net.vidyo.framework.common.domain.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ExceptionHandlerConfig {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlerConfig.class);

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    public Result exceptionHandler(BusinessException e) {
        log.error(ErrorUtil.errorInfoToString(e));
        return Result.Fail((IErrorEnum)e.getExceptionEnum());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Result exceptionHandler(Exception e) {
        log.error(ErrorUtil.errorInfoToString(e));
        return Result.Fail((IErrorEnum)BusinessExceptionEnum.UNKNOWN);
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseBody
    public Result exceptionHandler(NullPointerException e) {
        log.error(ErrorUtil.errorInfoToString(e));
        return Result.Fail((IErrorEnum)BusinessExceptionEnum.INTERNAL_SERVER_ERROR);
    }
}

