/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.dylink.mybatis.plus.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.net.vidyo.dylink.mybatis.plus.dao.EntityDao;
import cn.net.vidyo.dylink.mybatis.plus.service.EntityService;
import cn.net.vidyo.framework.common.data.domain.Model;
import cn.net.vidyo.framework.common.util.ReflectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class EntityServiceImpl<DAO extends EntityDao<MODEL>, MODEL, KEY extends Serializable>
extends ServiceImpl<DAO, MODEL>
implements EntityService<DAO, MODEL, KEY> {
    Class<KEY> keyClass;

    public EntityServiceImpl() {
        this.parseClass();
    }

    protected void parseClass() {
        Class entityClass = super.getEntityClass();
        Field field = ReflectUtil.getAllDeclaredFields((Class)entityClass, (String)"id", (boolean)true);
        if (field != null) {
            if (field.getType() == Integer.class) {
                this.keyClass = Integer.class;
            }
            if (field.getType() == Long.class) {
                this.keyClass = Long.class;
            }
            if (field.getType() == String.class) {
                this.keyClass = String.class;
            }
        }
    }

    @Override
    public DAO getEntityDao() {
        return (DAO)((EntityDao)this.baseMapper);
    }

    @Override
    public void setEntityDao(DAO entityDao) {
        this.baseMapper = entityDao;
    }

    @Override
    public int truncate() {
        return ((EntityDao)this.baseMapper).truncate();
    }

    @Override
    public int drop() {
        return ((EntityDao)this.baseMapper).drop();
    }

    @Override
    public int insert(MODEL entity) {
        return ((EntityDao)this.baseMapper).insert(entity);
    }

    @Override
    public int deleteById(Serializable id) {
        return ((EntityDao)this.baseMapper).deleteById(id);
    }

    @Override
    public int deleteByMap(Map<String, Object> columnMap) {
        return ((EntityDao)this.baseMapper).deleteByMap(columnMap);
    }

    protected int deleteByWhere(Wrapper<MODEL> wrapper) {
        return ((EntityDao)this.baseMapper).delete(wrapper);
    }

    @Override
    public int deleteBatchIds(Collection<? extends Serializable> idList) {
        return ((EntityDao)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public MODEL selectById(Serializable id) {
        return (MODEL)((EntityDao)this.baseMapper).selectById(id);
    }

    @Override
    public List<MODEL> selectBatchIds(Collection<? extends Serializable> idList) {
        return ((EntityDao)this.baseMapper).selectBatchIds(idList);
    }

    @Override
    public List<MODEL> selectByMap(Map<String, Object> columnMap) {
        return ((EntityDao)this.baseMapper).selectByMap(columnMap);
    }

    protected MODEL selectOneByWhere(Wrapper<MODEL> queryWrapper) {
        return (MODEL)((EntityDao)this.baseMapper).selectOne(queryWrapper);
    }

    protected long selectCountByWhere(Wrapper<MODEL> queryWrapper) {
        return ((EntityDao)this.baseMapper).selectCount(queryWrapper);
    }

    protected List<MODEL> selectListByWhere(Wrapper<MODEL> queryWrapper) {
        return ((EntityDao)this.baseMapper).selectList(queryWrapper);
    }

    protected List<Map<String, Object>> selectMapsByWhere(Wrapper<MODEL> queryWrapper) {
        return ((EntityDao)this.baseMapper).selectMaps(queryWrapper);
    }

    protected List<Object> selectObjsByWhere(Wrapper<MODEL> queryWrapper) {
        return ((EntityDao)this.baseMapper).selectObjs(queryWrapper);
    }

    protected <E extends IPage<MODEL>> E selectPageByWhere(E page, Wrapper<MODEL> queryWrapper) {
        return (E)((EntityDao)this.baseMapper).selectPage(page, queryWrapper);
    }

    protected <E extends IPage<Map<String, Object>>> E selectMapsPageByWhere(E page, Wrapper<MODEL> queryWrapper) {
        return (E)((EntityDao)this.baseMapper).selectMapsPage(page, queryWrapper);
    }

    @Override
    public List<MODEL> findByIds(Collection<KEY> ids) {
        if (ids == null || ids.size() == 0) {
            return new ArrayList();
        }
        return ((EntityDao)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"hidden", (Object)false)).in((Object)"id", ids));
    }

    @Override
    public MODEL getByName(String name) {
        List entities = ((EntityDao)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"hidden", (Object)false)).eq(StringUtils.isNotBlank((CharSequence)name), (Object)"name", (Object)name));
        if (entities.size() == 0) {
            return null;
        }
        return (MODEL)entities.get(0);
    }

    @Override
    public boolean logicDeleteByIds(boolean hidden, Collection<KEY> ids) {
        return this.updateHiddenByIds(hidden, ids);
    }

    @Override
    public List<MODEL> findAll() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"hidden", (Object)false);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public <E extends IPage<MODEL>> E findAll(E page) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"hidden", (Object)false);
        return (E)this.page(page, (Wrapper)wrapper);
    }

    @Override
    public String getNameById(KEY id) {
        Object entity = this.getById((Serializable)id);
        if (entity == null) {
            return "";
        }
        Object value = BeanUtil.getFieldValue((Object)entity, (String)"name");
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public <C> C getColumnById(Class<C> cClass, KEY id, String fileName) {
        Object entity = this.getById((Serializable)id);
        if (entity == null) {
            return null;
        }
        Object value = BeanUtil.getFieldValue((Object)entity, (String)fileName);
        return (C)value;
    }

    @Deprecated
    protected List<KEY> findIdsByWhere(String columName, QueryWrapper<MODEL> where) {
        return this.findColumnsByWhere("id", this.getKeyClass(), where);
    }

    protected List<KEY> findIdsByWhere(QueryWrapper<MODEL> where) {
        return this.findColumnsByWhere("id", this.getKeyClass(), where);
    }

    public Class<KEY> getKeyClass() {
        return null;
    }

    public Class<MODEL> getEntityClass() {
        return null;
    }

    protected <C> List<C> findColumnsByWhere(String columName, Class<C> cClass, QueryWrapper<MODEL> where) {
        where.select(new String[]{columName});
        return ((EntityDao)this.baseMapper).selectObjs((Wrapper)where).stream().map(o -> o).collect(Collectors.toList());
    }

    protected <C> C getColumnsByWhere(String columName, Class<C> cClass, QueryWrapper<MODEL> where) {
        List<C> columns = this.findColumnsByWhere(columName, cClass, where);
        if (columns == null || columns.size() == 0) {
            return null;
        }
        return columns.get(0);
    }

    public boolean save(MODEL entity) {
        if (!((Model)entity).isModify()) {
            ((Model)entity).preInsert();
        } else {
            ((Model)entity).preUpdate();
        }
        return super.save(entity);
    }

    public boolean saveBatch(Collection<MODEL> entityList) {
        for (MODEL model : entityList) {
            if (!((Model)model).isModify()) {
                ((Model)model).preInsert();
                continue;
            }
            ((Model)model).preUpdate();
        }
        return super.saveBatch(entityList);
    }

    public boolean saveOrUpdateBatch(Collection<MODEL> entityList) {
        for (MODEL model : entityList) {
            if (!((Model)model).isModify()) {
                ((Model)model).preInsert();
                continue;
            }
            ((Model)model).preUpdate();
        }
        return super.saveOrUpdateBatch(entityList);
    }

    public boolean saveBatch(Collection<MODEL> entityList, int batchSize) {
        for (MODEL model : entityList) {
            if (!((Model)model).isModify()) {
                ((Model)model).preInsert();
                continue;
            }
            ((Model)model).preUpdate();
        }
        return super.saveBatch(entityList, batchSize);
    }

    public boolean saveOrUpdate(MODEL entity) {
        if (!((Model)entity).isModify()) {
            ((Model)entity).preInsert();
        } else {
            ((Model)entity).preUpdate();
        }
        return super.saveOrUpdate(entity);
    }

    public boolean saveOrUpdateBatch(Collection<MODEL> entityList, int batchSize) {
        for (MODEL model : entityList) {
            if (!((Model)model).isModify()) {
                ((Model)model).preInsert();
                continue;
            }
            ((Model)model).preUpdate();
        }
        return super.saveOrUpdateBatch(entityList, batchSize);
    }

    @Override
    public boolean delete(MODEL entity) {
        return this.removeById(entity);
    }

    @Override
    public boolean update(MODEL entity) {
        return this.updateById(entity);
    }

    public boolean updateById(MODEL entity) {
        if (!((Model)entity).isModify()) {
            ((Model)entity).preInsert();
        } else {
            ((Model)entity).preUpdate();
        }
        return super.updateById(entity);
    }

    public boolean update(MODEL entity, Wrapper<MODEL> updateWrapper) {
        if (!((Model)entity).isModify()) {
            ((Model)entity).preInsert();
        } else {
            ((Model)entity).preUpdate();
        }
        return super.update(entity, updateWrapper);
    }

    public boolean updateBatchById(Collection<MODEL> entityList) {
        return super.updateBatchById(entityList);
    }

    public boolean saveOrUpdate(MODEL entity, Wrapper<MODEL> updateWrapper) {
        if (!((Model)entity).isModify()) {
            ((Model)entity).preInsert();
        } else {
            ((Model)entity).preUpdate();
        }
        return super.saveOrUpdate(entity, updateWrapper);
    }

    public KEY getMaxId() {
        return (KEY)((Serializable)this.getColumnsByWhere("max(id) as id", this.getKeyClass(), new QueryWrapper()));
    }

    public void setEntityClass(Class<MODEL> entityClass) {
        this.entityClass = entityClass;
    }

    public void setKeyClass(Class<KEY> keyClass) {
        this.keyClass = keyClass;
    }

    public boolean updateColumnByIds(String columnName, Object value, Collection<KEY> ids) {
        HashMap<String, Object> columnNameValues = new HashMap<String, Object>();
        columnNameValues.put(columnName, value);
        return this.updateColumnsByIds(columnNameValues, ids);
    }

    public boolean updateColumnsByWhere(Map<String, Object> columnNameValues, QueryWrapper<MODEL> wrapper) {
        List<KEY> ids = this.findIdsByWhere(wrapper);
        return this.updateColumnsByIds(columnNameValues, ids);
    }

    public boolean updateColumnByWhere(String columnName, Object value, QueryWrapper<MODEL> wrapper) {
        List<KEY> ids = this.findIdsByWhere(wrapper);
        HashMap<String, Object> columnNameValues = new HashMap<String, Object>();
        columnNameValues.put(columnName, value);
        return this.updateColumnsByWhere(columnNameValues, wrapper);
    }

    public boolean updateColumnsByIds(Map<String, Object> columnNameValues, Collection<KEY> ids) {
        if (ids.size() == 0) {
            return true;
        }
        UpdateWrapper upwrapper = new UpdateWrapper();
        for (Map.Entry<String, Object> entry : columnNameValues.entrySet()) {
            upwrapper.set((Object)entry.getKey(), entry.getValue());
        }
        upwrapper.in(ids.size() > 0, (Object)"id", ids);
        return super.update(null, (Wrapper)upwrapper);
    }

    @Override
    public boolean updateHiddenByIds(boolean hidden, Collection<KEY> ids) {
        if (ids == null || ids.size() == 0) {
            return true;
        }
        return this.updateColumnByIds("hidden", hidden, ids);
    }

    @Override
    public boolean updateStatusByIds(int status, Collection<KEY> ids) {
        if (ids == null || ids.size() == 0) {
            return true;
        }
        return this.updateColumnByIds("status", status, ids);
    }
}

