/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.dylink.mybatis.plus.util;

import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.net.vidyo.dylink.mybatis.plus.enums.BusinessExceptionEnum;
import cn.net.vidyo.dylink.mybatis.plus.util.excel.ExcelImportProcess;
import cn.net.vidyo.framework.common.domain.IErrorEnum;
import cn.net.vidyo.framework.common.domain.Result;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExcelImportUtil {
    public static Result importExcel(File file, int sheetIndex, int startRowIndex, ExcelImportProcess process) {
        return ExcelImportUtil.importExcelWithMultiSheet(file, process, sheetIndex, startRowIndex);
    }

    public static Result importExcelWithMultiSheet(File file, ExcelImportProcess process, int ... sheetIndexAndstartRowIndexs) {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (Exception e) {
            return Result.Fail((IErrorEnum)BusinessExceptionEnum.EXCEL_IMPORT_ACCESS_EXCEPTION);
        }
        return ExcelImportUtil.importExcelWithMultiSheet(inputStream, process, sheetIndexAndstartRowIndexs);
    }

    public static Result importExcelWithMultiSheet(InputStream inputStream, ExcelImportProcess process, int ... sheetIndexAndstartRowIndexs) {
        HashMap<Integer, HashMap<Integer, List<Object>>> sheetsData = new HashMap<Integer, HashMap<Integer, List<Object>>>();
        ArrayList errors = new ArrayList();
        try {
            for (int index = 0; index < sheetIndexAndstartRowIndexs.length; ++index) {
                int sheetIndex = sheetIndexAndstartRowIndexs[index];
                int startRowIndex = sheetIndexAndstartRowIndexs[index + 1];
                ++index;
                HashMap<Integer, List<Object>> sheetData = new HashMap<Integer, List<Object>>();
                ExcelReader reader = ExcelUtil.getReader((InputStream)inputStream, (int)sheetIndex);
                List read = reader.read(startRowIndex, reader.getRowCount());
                int rowIndex = startRowIndex;
                for (List rowData : read) {
                    sheetData.put(rowIndex, rowData);
                    Result check = process.check(sheetIndex, rowIndex, rowData);
                    if (!check.isSuccess()) {
                        List errs = (List)check.getData();
                        errors.addAll(errs);
                    }
                    ++rowIndex;
                }
                Result check = process.checkSheet(sheetIndex, sheetData);
                if (!check.isSuccess()) {
                    List errs = (List)check.getData();
                    errors.addAll(errs);
                }
                sheetsData.put(sheetIndex, sheetData);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex != null && ex.getMessage() != null && ex.getMessage().indexOf("OOXML") > 0) {
                return Result.Fail((IErrorEnum)BusinessExceptionEnum.EXCEL_IMPORT_FORMAT_EXCEPTION);
            }
            return Result.Fail((IErrorEnum)BusinessExceptionEnum.EXCEL_IMPORT_FORMAT_EXCEPTION);
        }
        if (errors.size() > 0) {
            return Result.Fail((IErrorEnum)BusinessExceptionEnum.EXCEL_IMPORT_Data_EXCEPTION, errors);
        }
        for (Map.Entry sheetEntry : sheetsData.entrySet()) {
            int sheetIndex = (Integer)sheetEntry.getKey();
            for (Map.Entry entry : ((Map)sheetEntry.getValue()).entrySet()) {
                Result check = process.process(sheetIndex, (Integer)entry.getKey(), (List)entry.getValue());
                if (check.isSuccess()) continue;
                List errs = (List)check.getData();
                errors.addAll(errs);
                return Result.Fail((IErrorEnum)BusinessExceptionEnum.EXCEL_IMPORT_Data_EXCEPTION, errors);
            }
        }
        return Result.Success();
    }
}

