/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.dylink.mybatis.plus.util;

import cn.net.vidyo.dylink.mybatis.plus.domain.GeoMetry;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.ognl.ParseException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class GeometryTypeHandler
extends BaseTypeHandler<GeoMetry> {
    public void setNonNullParameter(PreparedStatement ps, int i, GeoMetry parameter, JdbcType jdbcType) throws SQLException {
        byte[] wkb = GeometryTypeHandler.convertPointToWKB(parameter);
        ps.setBytes(i, wkb);
    }

    public GeoMetry getNullableResult(ResultSet rs, String columnName) throws SQLException {
        byte[] wkb = rs.getBytes(columnName);
        try {
            return GeometryTypeHandler.parseWKBToPoint(wkb);
        }
        catch (ParseException e) {
            throw new SQLException(e);
        }
    }

    public GeoMetry getNullableResult(ResultSet resultSet, int columnIndex) throws SQLException {
        try {
            byte[] wkb = resultSet.getBytes(columnIndex);
            return GeometryTypeHandler.parseWKBToPoint(wkb);
        }
        catch (Exception e) {
            throw new SQLException("Failed to parse WKB from ResultSet index: " + e.getMessage());
        }
    }

    public GeoMetry getNullableResult(CallableStatement callableStatement, int columnIndex) throws SQLException {
        try {
            byte[] wkb = callableStatement.getBytes(columnIndex);
            return GeometryTypeHandler.parseWKBToPoint(wkb);
        }
        catch (Exception e) {
            throw new SQLException("Failed to parse WKB from CallableStatement: " + e.getMessage());
        }
    }

    public static byte[] convertPointToWKB(GeoMetry point) {
        ByteBuffer buffer = ByteBuffer.allocate(25);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)1);
        buffer.putInt(1);
        buffer.putDouble(point.getLng().doubleValue());
        buffer.putDouble(point.getLat().doubleValue());
        return buffer.array();
    }

    public static GeoMetry parseWKBToPoint(byte[] wkb) throws ParseException {
        try {
            byte byteOrder;
            int offset = 0;
            if (wkb.length > 25) {
                offset = 4;
            }
            boolean isLittleEndian = (byteOrder = wkb[offset]) == 1;
            int geomType = ByteBuffer.wrap(wkb, offset + 1, 4).order(isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN).getInt();
            if (geomType != 1) {
                throw new ParseException("Non-point geometry type detected");
            }
            ByteBuffer coordBuffer = ByteBuffer.wrap(wkb, offset + 5, 16).order(isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            double lng = coordBuffer.getDouble();
            double lat = coordBuffer.getDouble();
            return new GeoMetry(BigDecimal.valueOf(lng), BigDecimal.valueOf(lat));
        }
        catch (Exception e) {
            throw new ParseException("Invalid WKB format: " + e.getMessage());
        }
    }
}

